/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.activemq.jms.pool.ConnectionKey;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jms.pool.PooledConnection;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledConnectionFactory.class);
    protected final AtomicBoolean stopped = new AtomicBoolean(false);
    private GenericKeyedObjectPool<ConnectionKey, ConnectionPool> connectionsPool;
    protected Object connectionFactory;
    private int maximumActiveSessionPerConnection = 500;
    private int idleTimeout = 30000;
    private int connectionTimeout = 30000;
    private boolean blockIfSessionPoolIsFull = true;
    private long blockIfSessionPoolIsFullTimeout = -1L;
    private long expiryTimeout = 0L;
    private boolean createConnectionOnStartup = true;
    private boolean useAnonymousProducers = true;
    private boolean reconnectOnException = true;
    private final AtomicReference<ConnectionPool> mostRecentlyCreated = new AtomicReference<Object>(null);

    public void initConnectionsPool() {
        if (this.connectionsPool == null) {
            GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
            poolConfig.setJmxEnabled(false);
            this.connectionsPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new KeyedPooledObjectFactory<ConnectionKey, ConnectionPool>(){

                public PooledObject<ConnectionPool> makeObject(ConnectionKey connectionKey) throws Exception {
                    Connection delegate = PooledConnectionFactory.this.createConnection(connectionKey);
                    ConnectionPool connection = PooledConnectionFactory.this.createConnectionPool(delegate);
                    connection.setIdleTimeout(PooledConnectionFactory.this.getIdleTimeout());
                    connection.setExpiryTimeout(PooledConnectionFactory.this.getExpiryTimeout());
                    connection.setMaximumActiveSessionPerConnection(PooledConnectionFactory.this.getMaximumActiveSessionPerConnection());
                    connection.setBlockIfSessionPoolIsFull(PooledConnectionFactory.this.isBlockIfSessionPoolIsFull());
                    if (PooledConnectionFactory.this.isBlockIfSessionPoolIsFull() && PooledConnectionFactory.this.getBlockIfSessionPoolIsFullTimeout() > 0L) {
                        connection.setBlockIfSessionPoolIsFullTimeout(PooledConnectionFactory.this.getBlockIfSessionPoolIsFullTimeout());
                    }
                    connection.setUseAnonymousProducers(PooledConnectionFactory.this.isUseAnonymousProducers());
                    connection.setReconnectOnException(PooledConnectionFactory.this.isReconnectOnException());
                    LOG.trace("Created new connection: {}", (Object)connection);
                    PooledConnectionFactory.this.mostRecentlyCreated.set(connection);
                    return new DefaultPooledObject((Object)connection);
                }

                public void destroyObject(ConnectionKey connectionKey, PooledObject<ConnectionPool> pooledObject) throws Exception {
                    ConnectionPool connection = (ConnectionPool)pooledObject.getObject();
                    try {
                        LOG.trace("Destroying connection: {}", (Object)connection);
                        connection.close();
                    }
                    catch (Exception e) {
                        LOG.warn("Close connection failed for connection: " + connection + ". This exception will be ignored.", (Throwable)e);
                    }
                }

                public boolean validateObject(ConnectionKey connectionKey, PooledObject<ConnectionPool> pooledObject) {
                    ConnectionPool connection = (ConnectionPool)pooledObject.getObject();
                    if (connection != null && connection.expiredCheck()) {
                        LOG.trace("Connection has expired: {} and will be destroyed", (Object)connection);
                        return false;
                    }
                    return true;
                }

                public void activateObject(ConnectionKey connectionKey, PooledObject<ConnectionPool> pooledObject) throws Exception {
                }

                public void passivateObject(ConnectionKey connectionKey, PooledObject<ConnectionPool> pooledObject) throws Exception {
                }
            }, poolConfig);
            this.connectionsPool.setMaxWaitMillis((long)this.getConnectionTimeout());
            this.connectionsPool.setMaxIdlePerKey(1);
            this.connectionsPool.setLifo(false);
            this.connectionsPool.setTestOnBorrow(true);
            this.connectionsPool.setTestWhileIdle(true);
        }
    }

    public Object getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(Object toUse) {
        if (!(toUse instanceof ConnectionFactory)) {
            throw new IllegalArgumentException("connectionFactory should implement javax.jms.ConnectionFactory");
        }
        this.connectionFactory = toUse;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        if (this.stopped.get()) {
            LOG.debug("PooledConnectionFactory is stopped, skip create new connection.");
            return null;
        }
        ConnectionPool connection = null;
        ConnectionKey key = new ConnectionKey(userName, password);
        if (this.getConnectionsPool().getNumIdle((Object)key) < this.getMaxConnections()) {
            try {
                this.connectionsPool.addObject((Object)key);
                connection = this.mostRecentlyCreated.getAndSet(null);
                connection.incrementReferenceCount();
                return this.newPooledConnection(connection);
            }
            catch (Exception e) {
                throw this.createJmsException("Error while attempting to add new Connection to the pool", e);
            }
        }
        try {
            while (connection == null) {
                block14: {
                    try {
                        connection = (ConnectionPool)this.connectionsPool.borrowObject((Object)key);
                    }
                    catch (NoSuchElementException ex) {
                        if ("Timeout waiting for idle object".equals(ex.getMessage())) break block14;
                        throw ex;
                    }
                }
                if (connection == null) continue;
                ConnectionPool ex = connection;
                synchronized (ex) {
                    if (connection.getConnection() != null) {
                        connection.incrementReferenceCount();
                        break;
                    }
                    this.connectionsPool.returnObject((Object)key, (Object)connection);
                    connection = null;
                }
            }
        }
        catch (Exception e) {
            throw this.createJmsException("Error while attempting to retrieve a connection from the pool", e);
        }
        try {
            this.connectionsPool.returnObject((Object)key, (Object)connection);
            return this.newPooledConnection(connection);
        }
        catch (Exception e) {
            throw this.createJmsException("Error when returning connection to the pool", e);
        }
    }

    protected Connection newPooledConnection(ConnectionPool connection) {
        return new PooledConnection(connection);
    }

    private JMSException createJmsException(String msg, Exception cause) {
        JMSException exception = new JMSException(msg);
        exception.setLinkedException(cause);
        exception.initCause((Throwable)cause);
        return exception;
    }

    protected Connection createConnection(ConnectionKey key) throws JMSException {
        if (this.connectionFactory instanceof ConnectionFactory) {
            if (key.getUserName() == null && key.getPassword() == null) {
                return ((ConnectionFactory)this.connectionFactory).createConnection();
            }
            return ((ConnectionFactory)this.connectionFactory).createConnection(key.getUserName(), key.getPassword());
        }
        throw new IllegalStateException("connectionFactory should implement javax.jms.ConnectionFactory");
    }

    public void start() {
        LOG.debug("Staring the PooledConnectionFactory: create on start = {}", (Object)this.isCreateConnectionOnStartup());
        this.stopped.set(false);
        if (this.isCreateConnectionOnStartup()) {
            try {
                this.createConnection().close();
            }
            catch (JMSException e) {
                LOG.warn("Create pooled connection during start failed. This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            LOG.debug("Stopping the PooledConnectionFactory, number of connections in cache: {}", (Object)(this.connectionsPool != null ? this.connectionsPool.getNumActive() : 0));
            try {
                if (this.connectionsPool != null) {
                    this.connectionsPool.close();
                    this.connectionsPool = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clear() {
        if (this.stopped.get()) {
            return;
        }
        this.getConnectionsPool().clear();
    }

    public int getMaximumActiveSessionPerConnection() {
        return this.maximumActiveSessionPerConnection;
    }

    public void setMaximumActiveSessionPerConnection(int maximumActiveSessionPerConnection) {
        this.maximumActiveSessionPerConnection = maximumActiveSessionPerConnection;
    }

    public void setBlockIfSessionPoolIsFull(boolean block) {
        this.blockIfSessionPoolIsFull = block;
    }

    public boolean isBlockIfSessionPoolIsFull() {
        return this.blockIfSessionPoolIsFull;
    }

    public int getMaxConnections() {
        return this.getConnectionsPool().getMaxIdlePerKey();
    }

    public void setMaxConnections(int maxConnections) {
        this.getConnectionsPool().setMaxIdlePerKey(maxConnections);
        this.getConnectionsPool().setMaxTotalPerKey(maxConnections);
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }

    public boolean isCreateConnectionOnStartup() {
        return this.createConnectionOnStartup;
    }

    public void setCreateConnectionOnStartup(boolean createConnectionOnStartup) {
        this.createConnectionOnStartup = createConnectionOnStartup;
    }

    public boolean isUseAnonymousProducers() {
        return this.useAnonymousProducers;
    }

    public void setUseAnonymousProducers(boolean value) {
        this.useAnonymousProducers = value;
    }

    protected GenericKeyedObjectPool<ConnectionKey, ConnectionPool> getConnectionsPool() {
        this.initConnectionsPool();
        return this.connectionsPool;
    }

    public void setTimeBetweenExpirationCheckMillis(long timeBetweenExpirationCheckMillis) {
        this.getConnectionsPool().setTimeBetweenEvictionRunsMillis(timeBetweenExpirationCheckMillis);
    }

    public long getTimeBetweenExpirationCheckMillis() {
        return this.getConnectionsPool().getTimeBetweenEvictionRunsMillis();
    }

    public int getNumConnections() {
        return this.getConnectionsPool().getNumIdle();
    }

    protected ConnectionPool createConnectionPool(Connection connection) {
        return new ConnectionPool(connection);
    }

    public long getBlockIfSessionPoolIsFullTimeout() {
        return this.blockIfSessionPoolIsFullTimeout;
    }

    public void setBlockIfSessionPoolIsFullTimeout(long blockIfSessionPoolIsFullTimeout) {
        this.blockIfSessionPoolIsFullTimeout = blockIfSessionPoolIsFullTimeout;
    }

    public boolean isReconnectOnException() {
        return this.reconnectOnException;
    }

    public void setReconnectOnException(boolean reconnectOnException) {
        this.reconnectOnException = reconnectOnException;
    }

    protected void populateProperties(Properties props) {
        props.setProperty("maximumActiveSessionPerConnection", Integer.toString(this.getMaximumActiveSessionPerConnection()));
        props.setProperty("maxConnections", Integer.toString(this.getMaxConnections()));
        props.setProperty("idleTimeout", Integer.toString(this.getIdleTimeout()));
        props.setProperty("expiryTimeout", Long.toString(this.getExpiryTimeout()));
        props.setProperty("timeBetweenExpirationCheckMillis", Long.toString(this.getTimeBetweenExpirationCheckMillis()));
        props.setProperty("createConnectionOnStartup", Boolean.toString(this.isCreateConnectionOnStartup()));
        props.setProperty("useAnonymousProducers", Boolean.toString(this.isUseAnonymousProducers()));
        props.setProperty("blockIfSessionPoolIsFullTimeout", Long.toString(this.getBlockIfSessionPoolIsFullTimeout()));
        props.setProperty("reconnectOnException", Boolean.toString(this.isReconnectOnException()));
    }
}

