/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.bulk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.clientImpl.bulk.Bulk;
import org.apache.accumulo.core.clientImpl.bulk.LoadMappingIterator;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.hadoop.fs.Path;

public class BulkSerialize {
    static Gson createGson() {
        return new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter()).create();
    }

    public static void writeLoadMapping(SortedMap<KeyExtent, Bulk.Files> loadMapping, String sourceDir, Output output) throws IOException {
        Path lmFile = new Path(sourceDir, "loadmap.json");
        try (OutputStream fsOut = output.create(lmFile);
             JsonWriter writer = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(fsOut, StandardCharsets.UTF_8)));){
            Gson gson = BulkSerialize.createGson();
            writer.setIndent("  ");
            writer.beginArray();
            Set<Map.Entry<KeyExtent, Bulk.Files>> es = loadMapping.entrySet();
            for (Map.Entry<KeyExtent, Bulk.Files> entry : es) {
                Bulk.Mapping mapping = new Bulk.Mapping(entry.getKey(), entry.getValue());
                gson.toJson((Object)mapping, Bulk.Mapping.class, writer);
            }
            writer.endArray();
        }
    }

    public static LoadMappingIterator readLoadMapping(String bulkDir, TableId tableId, Input input) throws IOException {
        Path lmFile = new Path(bulkDir, "loadmap.json");
        return new LoadMappingIterator(tableId, input.open(lmFile));
    }

    public static void writeRenameMap(Map<String, String> oldToNewNameMap, String bulkDir, Output output) throws IOException {
        Path renamingFile = new Path(bulkDir, "renames.json");
        try (OutputStream fsOut = output.create(renamingFile);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fsOut));){
            new Gson().toJson(oldToNewNameMap, (Appendable)writer);
        }
    }

    public static Map<String, String> readRenameMap(String bulkDir, Input input) throws IOException {
        Map oldToNewNameMap;
        Path renamingFile = new Path(bulkDir, "renames.json");
        Gson gson = BulkSerialize.createGson();
        try (InputStream fis = input.open(renamingFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(fis));){
            oldToNewNameMap = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, String>>(){}.getType());
        }
        return oldToNewNameMap;
    }

    public static LoadMappingIterator getUpdatedLoadMapping(String bulkDir, TableId tableId, Input input) throws IOException {
        Map<String, String> renames = BulkSerialize.readRenameMap(bulkDir, input);
        LoadMappingIterator lmi = BulkSerialize.readLoadMapping(bulkDir, tableId, input);
        lmi.setRenameMap(renames);
        return lmi;
    }

    public static interface Input {
        public InputStream open(Path var1) throws IOException;
    }

    public static interface Output {
        public OutputStream create(Path var1) throws IOException;
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        Base64.Encoder encoder = Base64.getUrlEncoder();

        private ByteArrayToBase64TypeAdapter() {
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.decoder.decode(json.getAsString());
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(this.encoder.encodeToString(src));
        }
    }
}

