/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.InitialTableState;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.UserCompactionUtils;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftNotActiveServiceException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.manager.thrift.FateOperation;
import org.apache.accumulo.core.manager.thrift.FateService;
import org.apache.accumulo.core.manager.thrift.ThriftPropertyException;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.Validator;
import org.apache.accumulo.core.util.Validators;
import org.apache.accumulo.core.util.tables.TableNameUtil;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ChangeTableState;
import org.apache.accumulo.manager.tableOps.TraceRepo;
import org.apache.accumulo.manager.tableOps.bulkVer1.BulkImport;
import org.apache.accumulo.manager.tableOps.bulkVer2.PrepBulkImport;
import org.apache.accumulo.manager.tableOps.clone.CloneTable;
import org.apache.accumulo.manager.tableOps.compact.CompactRange;
import org.apache.accumulo.manager.tableOps.compact.cancel.CancelCompactions;
import org.apache.accumulo.manager.tableOps.create.CreateTable;
import org.apache.accumulo.manager.tableOps.delete.PreDeleteTable;
import org.apache.accumulo.manager.tableOps.merge.TableRangeOp;
import org.apache.accumulo.manager.tableOps.namespace.create.CreateNamespace;
import org.apache.accumulo.manager.tableOps.namespace.delete.DeleteNamespace;
import org.apache.accumulo.manager.tableOps.namespace.rename.RenameNamespace;
import org.apache.accumulo.manager.tableOps.rename.RenameTable;
import org.apache.accumulo.manager.tableOps.tableExport.ExportTable;
import org.apache.accumulo.manager.tableOps.tableImport.ImportTable;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.manager.state.MergeInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;

class FateServiceHandler
implements FateService.Iface {
    private final Manager manager;
    protected static final Logger log = Manager.log;

    public FateServiceHandler(Manager manager) {
        this.manager = manager;
    }

    public long beginFateOperation(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.manager.fate().startTransaction();
    }

    public void executeFateOperation(TInfo tinfo, TCredentials c, long opid, FateOperation op, List<ByteBuffer> arguments, Map<String, String> options, boolean autoCleanup) throws ThriftSecurityException, ThriftTableOperationException, ThriftPropertyException {
        this.authenticate(c);
        String goalMessage = op.toString() + " ";
        switch (op) {
            case NAMESPACE_CREATE: {
                TableOperation tableOp = TableOperation.CREATE;
                this.validateArgumentCount(arguments, tableOp, 1);
                String namespace = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.NEW_NAMESPACE_NAME);
                if (!this.manager.security.canCreateNamespace(c)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Create " + namespace + " namespace.";
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new CreateNamespace(c.getPrincipal(), namespace, options)), autoCleanup, goalMessage);
                break;
            }
            case NAMESPACE_RENAME: {
                TableOperation tableOp = TableOperation.RENAME;
                this.validateArgumentCount(arguments, tableOp, 2);
                String oldName = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.EXISTING_NAMESPACE_NAME.and(Validators.NOT_BUILTIN_NAMESPACE));
                String newName = this.validateName(arguments.get(1), tableOp, (Validator<String>)Validators.NEW_NAMESPACE_NAME);
                NamespaceId namespaceId = ClientServiceHandler.checkNamespaceId((ClientContext)this.manager.getContext(), (String)oldName, (TableOperation)tableOp);
                if (!this.manager.security.canRenameNamespace(c, namespaceId)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Rename " + oldName + " namespace to " + newName;
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new RenameNamespace(namespaceId, oldName, newName)), autoCleanup, goalMessage);
                break;
            }
            case NAMESPACE_DELETE: {
                TableOperation tableOp = TableOperation.DELETE;
                this.validateArgumentCount(arguments, tableOp, 1);
                String namespace = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.EXISTING_NAMESPACE_NAME.and(Validators.NOT_BUILTIN_NAMESPACE));
                NamespaceId namespaceId = ClientServiceHandler.checkNamespaceId((ClientContext)this.manager.getContext(), (String)namespace, (TableOperation)tableOp);
                if (!this.manager.security.canDeleteNamespace(c, namespaceId)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Delete namespace Id: " + namespaceId;
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new DeleteNamespace(namespaceId)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_CREATE: {
                NamespaceId namespaceId;
                TableOperation tableOp = TableOperation.CREATE;
                int SPLIT_OFFSET = 4;
                if (arguments.size() < SPLIT_OFFSET) {
                    throw new ThriftTableOperationException(null, null, tableOp, TableOperationExceptionType.OTHER, "Expected at least " + SPLIT_OFFSET + " arguments, saw :" + arguments.size());
                }
                String tableName = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.NEW_TABLE_NAME.and(Validators.NOT_BUILTIN_TABLE));
                TimeType timeType = TimeType.valueOf((String)ByteBufferUtil.toString((ByteBuffer)arguments.get(1)));
                InitialTableState initialTableState = InitialTableState.valueOf((String)ByteBufferUtil.toString((ByteBuffer)arguments.get(2)));
                int splitCount = Integer.parseInt(ByteBufferUtil.toString((ByteBuffer)arguments.get(3)));
                this.validateArgumentCount(arguments, tableOp, SPLIT_OFFSET + splitCount);
                Path splitsPath = null;
                Path splitsDirsPath = null;
                if (splitCount > 0) {
                    try {
                        Path tmpDir = this.mkTempDir(opid);
                        splitsPath = new Path(tmpDir, "splits");
                        splitsDirsPath = new Path(tmpDir, "splitsDirs");
                        this.writeSplitsToFile(splitsPath, arguments, splitCount, SPLIT_OFFSET);
                    }
                    catch (IOException e) {
                        throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.OTHER, "Exception thrown while writing splits to file system");
                    }
                }
                try {
                    namespaceId = Namespaces.getNamespaceId((ClientContext)this.manager.getContext(), (String)((String)TableNameUtil.qualify((String)tableName).getFirst()));
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
                if (!this.manager.security.canCreateTable(c, tableName, namespaceId)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    if (Property.isValidProperty((String)entry.getKey(), (String)entry.getValue())) continue;
                    String errorMessage = "Property or value not valid ";
                    if (!Property.isValidTablePropertyKey((String)entry.getKey())) {
                        errorMessage = "Invalid Table Property ";
                    }
                    throw new ThriftPropertyException(entry.getKey(), entry.getValue(), errorMessage + entry.getKey() + "=" + entry.getValue());
                }
                goalMessage = goalMessage + "Create table " + tableName + " " + initialTableState + " with " + splitCount + " splits.";
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new CreateTable(c.getPrincipal(), tableName, timeType, options, splitsPath, splitCount, splitsDirsPath, initialTableState, namespaceId)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_RENAME: {
                boolean canRename;
                TableOperation tableOp = TableOperation.RENAME;
                this.validateArgumentCount(arguments, tableOp, 2);
                String oldTableName = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.EXISTING_TABLE_NAME.and(Validators.NOT_BUILTIN_TABLE));
                String newTableName = this.validateName(arguments.get(1), tableOp, (Validator<String>)Validators.NEW_TABLE_NAME.and(Validators.sameNamespaceAs((String)oldTableName)));
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.manager.getContext(), (String)oldTableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canRename = this.manager.security.canRenameTable(c, tableId, oldTableName, newTableName, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, oldTableName, TableOperation.RENAME);
                    throw e;
                }
                if (!canRename) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Rename table " + oldTableName + "(" + tableId + ") to " + oldTableName;
                try {
                    this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new RenameTable(namespaceId, tableId, oldTableName, newTableName)), autoCleanup, goalMessage);
                    break;
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, oldTableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
            }
            case TABLE_CLONE: {
                boolean canCloneTable;
                NamespaceId namespaceId;
                TableOperation tableOp = TableOperation.CLONE;
                this.validateArgumentCount(arguments, tableOp, 3);
                TableId srcTableId = this.validateTableIdArgument(arguments.get(0), tableOp, (Validator<TableId>)Validators.CAN_CLONE_TABLE);
                String tableName = this.validateName(arguments.get(1), tableOp, (Validator<String>)Validators.NEW_TABLE_NAME.and(Validators.NOT_BUILTIN_TABLE));
                boolean keepOffline = false;
                if (arguments.get(2) != null) {
                    keepOffline = Boolean.parseBoolean(ByteBufferUtil.toString((ByteBuffer)arguments.get(2)));
                }
                try {
                    namespaceId = Namespaces.getNamespaceId((ClientContext)this.manager.getContext(), (String)((String)TableNameUtil.qualify((String)tableName).getFirst()));
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
                try {
                    canCloneTable = this.manager.security.canCloneTable(c, srcTableId, tableName, namespaceId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, srcTableId, null, TableOperation.CLONE);
                    throw e;
                }
                if (!canCloneTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                HashMap<String, String> propertiesToSet = new HashMap<String, String>();
                HashSet<String> propertiesToExclude = new HashSet<String>();
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    if (entry.getKey().startsWith("!")) {
                        propertiesToExclude.add(entry.getKey().substring("!".length()));
                        continue;
                    }
                    if (!Property.isValidProperty((String)entry.getKey(), (String)entry.getValue())) {
                        String errorMessage = "Property or value not valid ";
                        if (!Property.isValidTablePropertyKey((String)entry.getKey())) {
                            errorMessage = "Invalid Table Property ";
                        }
                        throw new ThriftPropertyException(entry.getKey(), entry.getValue(), errorMessage + entry.getKey() + "=" + entry.getValue());
                    }
                    propertiesToSet.put(entry.getKey(), entry.getValue());
                }
                goalMessage = goalMessage + "Clone table " + srcTableId + " to " + tableName;
                if (keepOffline) {
                    goalMessage = goalMessage + " and keep offline.";
                }
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new CloneTable(c.getPrincipal(), namespaceId, srcTableId, tableName, propertiesToSet, propertiesToExclude, keepOffline)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_DELETE: {
                boolean canDeleteTable;
                TableOperation tableOp = TableOperation.DELETE;
                this.validateArgumentCount(arguments, tableOp, 1);
                String tableName = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.EXISTING_TABLE_NAME.and(Validators.NOT_BUILTIN_TABLE));
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.manager.getContext(), (String)tableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canDeleteTable = this.manager.security.canDeleteTable(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.DELETE);
                    throw e;
                }
                if (!canDeleteTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Delete table " + tableName + "(" + tableId + ")";
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new PreDeleteTable(namespaceId, tableId)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_ONLINE: {
                boolean canOnlineOfflineTable;
                TableOperation tableOp = TableOperation.ONLINE;
                this.validateArgumentCount(arguments, tableOp, 1);
                TableId tableId = this.validateTableIdArgument(arguments.get(0), tableOp, (Validator<TableId>)Validators.NOT_ROOT_TABLE_ID);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canOnlineOfflineTable = this.manager.security.canOnlineOfflineTable(c, tableId, op, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.ONLINE);
                    throw e;
                }
                if (!canOnlineOfflineTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Online table " + tableId;
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new ChangeTableState(namespaceId, tableId, tableOp)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_OFFLINE: {
                boolean canOnlineOfflineTable;
                TableOperation tableOp = TableOperation.OFFLINE;
                this.validateArgumentCount(arguments, tableOp, 1);
                TableId tableId = this.validateTableIdArgument(arguments.get(0), tableOp, (Validator<TableId>)Validators.NOT_ROOT_TABLE_ID);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canOnlineOfflineTable = this.manager.security.canOnlineOfflineTable(c, tableId, op, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.OFFLINE);
                    throw e;
                }
                if (!canOnlineOfflineTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Offline table " + tableId;
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new ChangeTableState(namespaceId, tableId, tableOp)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_MERGE: {
                boolean canMerge;
                TableOperation tableOp = TableOperation.MERGE;
                this.validateArgumentCount(arguments, tableOp, 3);
                String tableName = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.EXISTING_TABLE_NAME);
                Text startRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(1));
                Text endRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(2));
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.manager.getContext(), (String)tableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canMerge = this.manager.security.canMerge(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.MERGE);
                    throw e;
                }
                if (!canMerge) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                String startRowStr = (String)StringUtils.defaultIfBlank((CharSequence)startRow.toString(), (CharSequence)"-inf");
                String endRowStr = (String)StringUtils.defaultIfBlank((CharSequence)startRow.toString(), (CharSequence)"+inf");
                Manager.log.debug("Creating merge op: {} from startRow: {} to endRow: {}", new Object[]{tableId, startRowStr, endRowStr});
                goalMessage = goalMessage + "Merge table " + tableName + "(" + tableId + ") splits from " + startRowStr + " to " + endRowStr;
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new TableRangeOp(MergeInfo.Operation.MERGE, namespaceId, tableId, startRow, endRow)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_DELETE_RANGE: {
                boolean canDeleteRange;
                TableOperation tableOp = TableOperation.DELETE_RANGE;
                this.validateArgumentCount(arguments, tableOp, 3);
                String tableName = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.EXISTING_TABLE_NAME.and(Validators.NOT_METADATA_TABLE));
                Text startRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(1));
                Text endRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(2));
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.manager.getContext(), (String)tableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canDeleteRange = this.manager.security.canDeleteRange(c, tableId, tableName, startRow, endRow, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.DELETE_RANGE);
                    throw e;
                }
                if (!canDeleteRange) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Delete table " + tableName + "(" + tableId + ") range " + startRow + " to " + endRow;
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new TableRangeOp(MergeInfo.Operation.DELETE, namespaceId, tableId, startRow, endRow)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_BULK_IMPORT: {
                boolean canBulkImport;
                TableOperation tableOp = TableOperation.BULK_IMPORT;
                this.validateArgumentCount(arguments, tableOp, 4);
                String tableName = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.EXISTING_TABLE_NAME.and(Validators.NOT_BUILTIN_TABLE));
                String dir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                String failDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(2));
                boolean setTime = Boolean.parseBoolean(ByteBufferUtil.toString((ByteBuffer)arguments.get(3)));
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.manager.getContext(), (String)tableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canBulkImport = this.manager.security.canBulkImport(c, tableId, tableName, dir, failDir, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.BULK_IMPORT);
                    throw e;
                }
                if (!canBulkImport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.manager.updateBulkImportStatus(dir, BulkImportState.INITIAL);
                goalMessage = goalMessage + "Bulk import " + dir + " to " + tableName + "(" + tableId + ") failing to " + failDir;
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new BulkImport(tableId, dir, failDir, setTime)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_COMPACT: {
                boolean canCompact;
                TableOperation tableOp = TableOperation.COMPACT;
                this.validateArgumentCount(arguments, tableOp, 2);
                TableId tableId = this.validateTableIdArgument(arguments.get(0), tableOp, null);
                CompactionConfig compactionConfig = UserCompactionUtils.decodeCompactionConfig((byte[])ByteBufferUtil.toBytes((ByteBuffer)arguments.get(1)));
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canCompact = this.manager.security.canCompact(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.COMPACT);
                    throw e;
                }
                if (!canCompact) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Compact table (" + tableId + ") with config " + compactionConfig;
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new CompactRange(namespaceId, tableId, compactionConfig)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_CANCEL_COMPACT: {
                boolean canCancelCompact;
                TableOperation tableOp = TableOperation.COMPACT_CANCEL;
                this.validateArgumentCount(arguments, tableOp, 1);
                TableId tableId = this.validateTableIdArgument(arguments.get(0), tableOp, null);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canCancelCompact = this.manager.security.canCompact(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.COMPACT_CANCEL);
                    throw e;
                }
                if (!canCancelCompact) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Cancel compaction of table (" + tableId + ")";
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new CancelCompactions(namespaceId, tableId)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_IMPORT: {
                boolean canImport;
                NamespaceId namespaceId;
                TableOperation tableOp = TableOperation.IMPORT;
                int IMPORT_DIR_OFFSET = 2;
                if (arguments.size() < IMPORT_DIR_OFFSET) {
                    throw new ThriftTableOperationException(null, null, tableOp, TableOperationExceptionType.OTHER, "Expected at least " + IMPORT_DIR_OFFSET + "arguments, sar :" + arguments.size());
                }
                String tableName = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.NEW_TABLE_NAME.and(Validators.NOT_BUILTIN_TABLE));
                boolean keepOffline = Boolean.parseBoolean(ByteBufferUtil.toString((ByteBuffer)arguments.get(1)));
                boolean keepMappings = Boolean.parseBoolean(ByteBufferUtil.toString((ByteBuffer)arguments.get(2)));
                List exportDirArgs = arguments.stream().skip(3L).collect(Collectors.toList());
                Set exportDirs = ByteBufferUtil.toStringSet(exportDirArgs);
                try {
                    namespaceId = Namespaces.getNamespaceId((ClientContext)this.manager.getContext(), (String)((String)TableNameUtil.qualify((String)tableName).getFirst()));
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
                try {
                    canImport = this.manager.security.canImport(c, tableName, exportDirs, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, null, tableName, TableOperation.IMPORT);
                    throw e;
                }
                if (!canImport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Import table with new name: " + tableName + " from " + exportDirs;
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new ImportTable(c.getPrincipal(), tableName, exportDirs, namespaceId, keepMappings, !keepOffline)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_EXPORT: {
                boolean canExport;
                TableOperation tableOp = TableOperation.EXPORT;
                this.validateArgumentCount(arguments, tableOp, 2);
                String tableName = this.validateName(arguments.get(0), tableOp, (Validator<String>)Validators.EXISTING_TABLE_NAME.and(Validators.NOT_BUILTIN_TABLE));
                String exportDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.manager.getContext(), (String)tableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canExport = this.manager.security.canExport(c, tableId, tableName, exportDir, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.EXPORT);
                    throw e;
                }
                if (!canExport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                goalMessage = goalMessage + "Export table " + tableName + "(" + tableId + ") to " + exportDir;
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new ExportTable(namespaceId, tableName, tableId, exportDir)), autoCleanup, goalMessage);
                break;
            }
            case TABLE_BULK_IMPORT2: {
                boolean canBulkImport;
                String tableName;
                TableOperation tableOp = TableOperation.BULK_IMPORT;
                this.validateArgumentCount(arguments, tableOp, 3);
                TableId tableId = this.validateTableIdArgument(arguments.get(0), tableOp, (Validator<TableId>)Validators.NOT_ROOT_TABLE_ID);
                String dir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                boolean setTime = Boolean.parseBoolean(ByteBufferUtil.toString((ByteBuffer)arguments.get(2)));
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    tableName = this.manager.getContext().getTableName(tableId);
                    canBulkImport = this.manager.security.canBulkImport(c, tableId, tableName, dir, null, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, "", TableOperation.BULK_IMPORT);
                    throw e;
                }
                catch (TableNotFoundException e) {
                    throw new ThriftTableOperationException(tableId.canonical(), null, TableOperation.BULK_IMPORT, TableOperationExceptionType.NOTFOUND, "Table no longer exists");
                }
                if (!canBulkImport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.manager.updateBulkImportStatus(dir, BulkImportState.INITIAL);
                goalMessage = goalMessage + "Bulk import (v2)  " + dir + " to " + tableName + "(" + tableId + ")";
                this.manager.fate().seedTransaction(op.toString(), opid, new TraceRepo<Manager>(new PrepBulkImport(tableId, dir, setTime)), autoCleanup, goalMessage);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private NamespaceId getNamespaceIdFromTableId(TableOperation tableOp, TableId tableId) throws ThriftTableOperationException {
        NamespaceId namespaceId;
        try {
            namespaceId = this.manager.getContext().getNamespaceId(tableId);
        }
        catch (TableNotFoundException e) {
            throw new ThriftTableOperationException(tableId.canonical(), null, tableOp, TableOperationExceptionType.NOTFOUND, e.getMessage());
        }
        return namespaceId;
    }

    private void throwIfTableMissingSecurityException(ThriftSecurityException e, TableId tableId, String tableName, TableOperation op) throws ThriftTableOperationException {
        if (e.isSetCode() && e.getCode() == SecurityErrorCode.TABLE_DOESNT_EXIST) {
            throw new ThriftTableOperationException(tableId.canonical(), tableName, op, TableOperationExceptionType.NOTFOUND, "Table no longer exists");
        }
    }

    public String waitForFateOperation(TInfo tinfo, TCredentials credentials, long opid) throws ThriftSecurityException, ThriftTableOperationException {
        this.authenticate(credentials);
        ReadOnlyTStore.TStatus status = this.manager.fate().waitForCompletion(opid);
        if (status == ReadOnlyTStore.TStatus.FAILED) {
            Exception e = this.manager.fate().getException(opid);
            if (e instanceof ThriftTableOperationException) {
                throw (ThriftTableOperationException)e;
            }
            if (e instanceof ThriftSecurityException) {
                throw (ThriftSecurityException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        String ret = this.manager.fate().getReturn(opid);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public void finishFateOperation(TInfo tinfo, TCredentials credentials, long opid) throws ThriftSecurityException {
        this.authenticate(credentials);
        this.manager.fate().delete(opid);
    }

    protected void authenticate(TCredentials credentials) throws ThriftSecurityException {
        if (!this.manager.security.authenticateUser(credentials, credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
        }
    }

    private TableId validateTableIdArgument(ByteBuffer tableIdArg, TableOperation op, Validator<TableId> userValidator) throws ThriftTableOperationException {
        TableId tableId = tableIdArg == null ? null : ByteBufferUtil.toTableId((ByteBuffer)tableIdArg);
        try {
            return (TableId)Validators.VALID_TABLE_ID.and(userValidator).validate((Object)tableId);
        }
        catch (IllegalArgumentException e) {
            String why = e.getMessage();
            log.debug(why);
            throw new ThriftTableOperationException(tableId == null ? "null" : tableId.canonical(), null, op, TableOperationExceptionType.INVALID_NAME, why);
        }
    }

    private void validateArgumentCount(List<ByteBuffer> arguments, TableOperation op, int expected) throws ThriftTableOperationException {
        if (arguments.size() != expected) {
            throw new ThriftTableOperationException(null, null, op, TableOperationExceptionType.OTHER, "Unexpected number of arguments : " + expected + " != " + arguments.size());
        }
    }

    private String validateName(ByteBuffer argument, TableOperation op, Validator<String> validator) throws ThriftTableOperationException {
        String arg = argument == null ? null : ByteBufferUtil.toString((ByteBuffer)argument);
        try {
            return (String)validator.validate((Object)arg);
        }
        catch (IllegalArgumentException e) {
            String why = e.getMessage();
            log.debug(why);
            throw new ThriftTableOperationException(null, String.valueOf(arg), op, TableOperationExceptionType.INVALID_NAME, why);
        }
    }

    private void writeSplitsToFile(Path splitsPath, List<ByteBuffer> arguments, int splitCount, int splitOffset) throws IOException {
        FileSystem fs = splitsPath.getFileSystem(this.manager.getContext().getHadoopConf());
        try (FSDataOutputStream stream = fs.create(splitsPath);){
            for (int i = splitOffset; i < splitCount + splitOffset; ++i) {
                byte[] splitBytes = ByteBufferUtil.toBytes((ByteBuffer)arguments.get(i));
                String encodedSplit = Base64.getEncoder().encodeToString(splitBytes);
                stream.write((encodedSplit + "\n").getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            log.error("Error in FateServiceHandler while writing splits to {}: {}", (Object)splitsPath, (Object)e.getMessage());
            throw e;
        }
    }

    public Path mkTempDir(long opid) throws IOException {
        Volume vol = this.manager.getVolumeManager().getFirst();
        Path p = vol.prefixChild("/tmp/fate-" + FastFormat.toHexString((long)opid));
        FileSystem fs = vol.getFileSystem();
        if (fs.exists(p)) {
            fs.delete(p, true);
        }
        fs.mkdirs(p);
        return p;
    }

    public boolean cancelFateOperation(TInfo tinfo, TCredentials credentials, long opid) throws ThriftSecurityException, ThriftNotActiveServiceException {
        if (!this.manager.security.canPerformSystemActions(credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.manager.fate().cancel(opid);
    }
}

