/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.auto.service.AutoService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Optional;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.compaction.thrift.TExternalCompactionList;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionKind;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.core.util.compaction.RunningCompaction;
import org.apache.accumulo.core.util.compaction.RunningCompactionInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class ECAdmin
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(ECAdmin.class);

    public static void main(String[] args) {
        new ECAdmin().execute(args);
    }

    public String keyword() {
        return "ec-admin";
    }

    public KeywordExecutable.UsageGroup usageGroup() {
        return KeywordExecutable.UsageGroup.CORE;
    }

    public String description() {
        return "Executes administrative commands for external compactions";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit okay for CLI tool")
    public void execute(String[] args) {
        ServerUtilOpts opts = new ServerUtilOpts();
        JCommander cl = new JCommander((Object)opts);
        cl.setProgramName("accumulo ec-admin");
        CancelCommand cancelOps = new CancelCommand();
        cl.addCommand("cancel", (Object)cancelOps);
        ListCompactorsCommand listCompactorsOpts = new ListCompactorsCommand();
        cl.addCommand("listCompactors", (Object)listCompactorsOpts);
        RunningCommand runningOpts = new RunningCommand();
        cl.addCommand("running", (Object)runningOpts);
        cl.parse(args);
        if (opts.help || cl.getParsedCommand() == null) {
            cl.usage();
            return;
        }
        ServerContext context = opts.getServerContext();
        try {
            if (cl.getParsedCommand().equals("listCompactors")) {
                this.listCompactorsByQueue(context);
            } else if (cl.getParsedCommand().equals("cancel")) {
                this.cancelCompaction(context, cancelOps.ecid);
            } else if (cl.getParsedCommand().equals("running")) {
                this.runningCompactions(context, runningOpts.details);
            } else {
                log.error("Unknown command {}", (Object)cl.getParsedCommand());
                cl.usage();
                System.exit(1);
            }
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
        finally {
            SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.CLOSED);
        }
    }

    private void cancelCompaction(ServerContext context, String ecid) {
        CompactionCoordinatorService.Client coordinatorClient = null;
        ecid = ExternalCompactionId.from((String)ecid).canonical();
        try {
            coordinatorClient = this.getCoordinatorClient(context);
            coordinatorClient.cancel(TraceUtil.traceInfo(), context.rpcCreds(), ecid);
            System.out.println("Cancel sent to coordinator for " + ecid);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception calling cancel compaction for " + ecid, e);
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)context);
        }
    }

    private void listCompactorsByQueue(ServerContext context) {
        Map queueToCompactorsMap = ExternalCompactionUtil.getCompactorAddrs((ClientContext)context);
        if (queueToCompactorsMap.isEmpty()) {
            System.out.println("No Compactors found.");
        } else {
            queueToCompactorsMap.forEach((q, compactors) -> System.out.println(q + ": " + compactors));
        }
    }

    private void runningCompactions(ServerContext context, boolean details) {
        CompactionCoordinatorService.Client coordinatorClient = null;
        try {
            coordinatorClient = this.getCoordinatorClient(context);
            TExternalCompactionList running = coordinatorClient.getRunningCompactions(TraceUtil.traceInfo(), context.rpcCreds());
            if (running == null) {
                System.out.println("No running compactions found.");
                return;
            }
            Map ecidMap = running.getCompactions();
            if (ecidMap == null) {
                System.out.println("No running compactions found.");
                return;
            }
            ecidMap.forEach((ecid, ec) -> {
                if (ec != null) {
                    RunningCompaction runningCompaction = new RunningCompaction(ec);
                    String addr = runningCompaction.getCompactorAddress();
                    TCompactionKind kind = runningCompaction.getJob().kind;
                    String queue = runningCompaction.getQueueName();
                    KeyExtent ke = KeyExtent.fromThrift((TKeyExtent)runningCompaction.getJob().extent);
                    System.out.format("%s %s %s %s TableId: %s\n", ecid, addr, kind, queue, ke.tableId());
                    if (details) {
                        RunningCompactionInfo runningCompactionInfo = new RunningCompactionInfo(ec);
                        String status = runningCompactionInfo.status;
                        long last = runningCompactionInfo.lastUpdate;
                        long duration = runningCompactionInfo.duration;
                        int numFiles = runningCompactionInfo.numFiles;
                        float progress = runningCompactionInfo.progress;
                        System.out.format("  %s Last Update: %dms Duration: %dms Files: %d Progress: %.2f%%\n", status, last, duration, numFiles, Float.valueOf(progress));
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get running compactions.", e);
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)context);
        }
    }

    private CompactionCoordinatorService.Client getCoordinatorClient(ServerContext context) {
        CompactionCoordinatorService.Client coordinatorClient;
        Optional coordinatorHost = ExternalCompactionUtil.findCompactionCoordinator((ClientContext)context);
        if (coordinatorHost.isEmpty()) {
            throw new IllegalStateException("Unable to find coordinator. Check that it is running.");
        }
        HostAndPort address = (HostAndPort)coordinatorHost.get();
        try {
            coordinatorClient = (CompactionCoordinatorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.COORDINATOR, (HostAndPort)address, (ClientContext)context);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get Compaction coordinator at " + address, e);
        }
        System.out.println("Connected to coordinator at " + address);
        return coordinatorClient;
    }

    @Parameters(commandDescription="list all compactors in zookeeper")
    static class ListCompactorsCommand {
        ListCompactorsCommand() {
        }
    }

    @Parameters(commandDescription="list the running compactions")
    static class RunningCommand {
        @Parameter(names={"-d", "--details"}, description="display details about the running compactions")
        boolean details = false;

        RunningCommand() {
        }
    }

    @Parameters(commandDescription="cancel the external compaction with given ECID")
    static class CancelCommand {
        @Parameter(names={"-ecid"}, description="<ecid>", required=true)
        String ecid;

        CancelCommand() {
        }
    }
}

