/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.RuntimeFixedProperties;
import org.apache.accumulo.server.conf.ZooBasedConfiguration;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfiguration
extends ZooBasedConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SystemConfiguration.class);
    private final RuntimeFixedProperties runtimeFixedProps;

    public SystemConfiguration(ServerContext context, SystemPropKey propStoreKey, AccumuloConfiguration parent) {
        super(log, context, propStoreKey, parent);
        this.runtimeFixedProps = new RuntimeFixedProperties(this.getSnapshot(), context.getSiteConfiguration());
    }

    @Override
    public String get(Property property) {
        log.trace("system config get() - property request for {}", (Object)property);
        if (Property.isFixedZooPropertyKey((Property)property)) {
            return this.runtimeFixedProps.get(property);
        }
        String key = property.getKey();
        String value = null;
        if (Property.isValidZooPropertyKey((String)key)) {
            value = this.getSnapshot().get(key);
        }
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error("Using parent value for {} due to improperly formatted {}: {}", new Object[]{key, property.getType(), value});
            }
            value = this.getParent().get(property);
        }
        return value;
    }

    @Override
    public boolean isPropertySet(Property prop) {
        return this.runtimeFixedProps.get(prop) != null || super.isPropertySet(prop);
    }
}

