/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.bulkVer1;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.ClientService;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.bulkVer1.CompleteBulkImport;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoadFiles
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private static final SecureRandom random = new SecureRandom();
    private static ExecutorService threadPool = null;
    private static final Logger log = LoggerFactory.getLogger(LoadFiles.class);
    private TableId tableId;
    private String source;
    private String bulk;
    private String errorDir;
    private boolean setTime;

    public LoadFiles(TableId tableId, String source, String bulk, String errorDir, boolean setTime) {
        this.tableId = tableId;
        this.source = source;
        this.bulk = bulk;
        this.errorDir = errorDir;
        this.setTime = setTime;
    }

    @Override
    public long isReady(long tid, Manager manager) {
        if (manager.onlineTabletServers().isEmpty()) {
            return 500L;
        }
        return 0L;
    }

    private static synchronized ExecutorService getThreadPool(Manager manager) {
        if (threadPool == null) {
            threadPool = ThreadPools.getServerThreadPools().createExecutorService(manager.getConfiguration(), Property.MANAGER_BULK_THREADPOOL_SIZE, true);
        }
        return threadPool;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        manager.updateBulkImportStatus(this.source, BulkImportState.LOADING);
        ExecutorService executor = LoadFiles.getThreadPool(manager);
        AccumuloConfiguration conf = manager.getConfiguration();
        VolumeManager fs = manager.getVolumeManager();
        ArrayList files = new ArrayList();
        Collections.addAll(files, fs.listStatus(new Path(this.bulk)));
        log.debug(FateTxId.formatTid((long)tid) + " importing " + files.size() + " files");
        Path writable = new Path(this.errorDir, ".iswritable");
        if (!fs.createNewFile(writable)) {
            fs.delete(writable);
            if (!fs.createNewFile(writable)) {
                throw new AcceptableThriftTableOperationException(this.tableId.canonical(), null, TableOperation.BULK_IMPORT, TableOperationExceptionType.BULK_BAD_ERROR_DIRECTORY, "Unable to write to " + this.errorDir);
            }
        }
        fs.delete(writable);
        Set<String> filesToLoad = Collections.synchronizedSet(new HashSet());
        for (FileStatus f : files) {
            filesToLoad.add(f.getPath().toString());
        }
        int RETRIES = Math.max(1, conf.getCount(Property.MANAGER_BULK_RETRIES));
        for (int attempt = 0; attempt < RETRIES && !filesToLoad.isEmpty(); ++attempt) {
            TServerInstance[] servers;
            ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
            if (manager.onlineTabletServers().isEmpty()) {
                log.warn("There are no tablet server to process bulk import, waiting (tid = " + FateTxId.formatTid((long)tid) + ")");
            }
            while (manager.onlineTabletServers().isEmpty()) {
                UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            List loaded = Collections.synchronizedList(new ArrayList());
            String prop = conf.get(Property.MANAGER_BULK_TSERVER_REGEX);
            if (prop == null || "".equals(prop)) {
                servers = manager.onlineTabletServers().toArray(new TServerInstance[0]);
            } else {
                Pattern regex = Pattern.compile(prop);
                ArrayList arrayList = new ArrayList();
                manager.onlineTabletServers().forEach(t -> {
                    if (regex.matcher(t.getHost()).matches()) {
                        subset.add(t);
                    }
                });
                if (arrayList.isEmpty()) {
                    log.warn("There are no tablet servers online that match supplied regex: {}", (Object)conf.get(Property.MANAGER_BULK_TSERVER_REGEX));
                }
                servers = arrayList.toArray(new TServerInstance[0]);
            }
            if (servers.length > 0) {
                for (String string : filesToLoad) {
                    results.add(executor.submit(() -> {
                        ClientService.Client client = null;
                        HostAndPort server = null;
                        try {
                            long timeInMillis = manager.getConfiguration().getTimeInMillis(Property.MANAGER_BULK_TIMEOUT);
                            server = servers[random.nextInt(servers.length)].getHostAndPort();
                            client = (ClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.CLIENT, (HostAndPort)server, (ClientContext)manager.getContext(), (long)timeInMillis);
                            List<String> attempt1 = Collections.singletonList(file);
                            log.debug("Asking " + server + " to bulk import " + file);
                            List fail = client.bulkImportFiles(TraceUtil.traceInfo(), manager.getContext().rpcCreds(), tid, this.tableId.canonical(), attempt1, this.errorDir, this.setTime);
                            if (fail.isEmpty()) {
                                loaded.add(file);
                            }
                            ThriftUtil.returnClient((TServiceClient)client, (ClientContext)manager.getContext());
                        }
                        catch (Exception ex) {
                            log.error("rpc failed server:" + server + ", tid:" + FateTxId.formatTid((long)tid) + " " + ex);
                        }
                        finally {
                            ThriftUtil.returnClient(client, (ClientContext)manager.getContext());
                        }
                        return null;
                    }));
                }
            }
            for (Future future : results) {
                future.get();
            }
            filesToLoad.removeAll(loaded);
            if (filesToLoad.isEmpty()) continue;
            log.debug(FateTxId.formatTid((long)tid) + " attempt " + (attempt + 1) + " " + LoadFiles.sampleList(filesToLoad, 10) + " failed");
            UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        FSDataOutputStream failFile = fs.overwrite(new Path(this.errorDir, "failures.txt"));
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)failFile, StandardCharsets.UTF_8));){
            for (String f : filesToLoad) {
                out.write(f);
                out.write("\n");
            }
        }
        return new CompleteBulkImport(this.tableId, this.source, this.bulk, this.errorDir);
    }

    static String sampleList(Collection<?> potentiallyLongList, int max) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        int i = 0;
        for (Object obj : potentiallyLongList) {
            result.append(obj);
            if (i >= max) {
                result.append("...");
                break;
            }
            result.append(", ");
            ++i;
        }
        if (i < max) {
            result.delete(result.length() - 2, result.length());
        }
        result.append("]");
        return result.toString();
    }
}

