/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.bulkVer1;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.ValidationUtil;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.bulkVer1.CleanUpBulkImport;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CopyFailed
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(CopyFailed.class);
    private static final long serialVersionUID = 1L;
    private TableId tableId;
    private String source;
    private String bulk;
    private String error;

    public CopyFailed(TableId tableId, String source, String bulk, String error) {
        this.tableId = tableId;
        this.source = source;
        this.bulk = bulk;
        this.error = error;
    }

    @Override
    public long isReady(long tid, Manager manager) {
        HashSet<TServerInstance> finished = new HashSet<TServerInstance>();
        Set<TServerInstance> running = manager.onlineTabletServers();
        for (TServerInstance server : running) {
            try {
                LiveTServerSet.TServerConnection client = manager.getConnection(server);
                if (client == null || client.isActive(tid)) continue;
                finished.add(server);
            }
            catch (TException ex) {
                log.info("Ignoring error trying to check on tid " + FateTxId.formatTid((long)tid) + " from server " + server + ": " + ex);
            }
        }
        if (finished.containsAll(running)) {
            return 0L;
        }
        return 500L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        Object path;
        manager.updateBulkImportStatus(this.source, BulkImportState.COPY_FILES);
        VolumeManager fs = manager.getVolumeManager();
        if (!fs.exists(new Path(this.error, "failures.txt"))) {
            return new CleanUpBulkImport(this.tableId, this.source, this.bulk, this.error);
        }
        HashSet<Path> failures = new HashSet<Path>();
        HashSet<Path> loadedFailures = new HashSet<Path>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(this.error, "failures.txt")), StandardCharsets.UTF_8));){
            String line = null;
            while ((line = in.readLine()) != null) {
                path = new Path(line);
                if (fs.exists(new Path(this.error, path.getName()))) continue;
                failures.add((Path)path);
            }
        }
        ServerContext client = manager.getContext();
        try (IsolatedScanner mscanner = new IsolatedScanner(client.createScanner(MetadataTable.NAME, Authorizations.EMPTY));){
            mscanner.setRange(new KeyExtent(this.tableId, null, null).toMetaRange());
            mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
            path = mscanner.iterator();
            while (path.hasNext()) {
                Path loadedFile;
                Map.Entry entry = (Map.Entry)path.next();
                if (MetadataSchema.TabletsSection.BulkFileColumnFamily.getBulkLoadTid((Value)((Value)entry.getValue())) != tid || !failures.remove(loadedFile = new Path(ValidationUtil.validate((String)((Key)entry.getKey()).getColumnQualifierData().toString())))) continue;
                loadedFailures.add(loadedFile);
            }
        }
        for (Path orig : failures) {
            Path dest = new Path(this.error, orig.getName());
            fs.rename(orig, dest);
            log.debug(FateTxId.formatTid((long)tid) + " renamed " + orig + " to " + dest + ": import failed");
        }
        if (!loadedFailures.isEmpty()) {
            DistributedWorkQueue bifCopyQueue = new DistributedWorkQueue("/accumulo/" + manager.getInstanceID() + "/bulk_failed_copyq", manager.getConfiguration(), manager.getContext());
            HashSet<String> workIds = new HashSet<String>();
            for (Path orig : loadedFailures) {
                Path dest = new Path(this.error, orig.getName());
                if (fs.exists(dest)) continue;
                bifCopyQueue.addWork(orig.getName(), (orig + "," + dest).getBytes(StandardCharsets.UTF_8));
                workIds.add(orig.getName());
                log.debug(FateTxId.formatTid((long)tid) + " added to copyq: " + orig + " to " + dest + ": failed");
            }
            bifCopyQueue.waitUntilDone(workIds);
        }
        fs.deleteRecursively(new Path(this.error, "failures.txt"));
        return new CleanUpBulkImport(this.tableId, this.source, this.bulk, this.error);
    }
}

