/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionMetadata;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.tabletserver.log.LogEntry;

public class TabletData {
    private MetadataTime time = null;
    private SortedMap<StoredTabletFile, DataFileValue> dataFiles = new TreeMap<StoredTabletFile, DataFileValue>();
    private List<LogEntry> logEntries = new ArrayList<LogEntry>();
    private HashSet<StoredTabletFile> scanFiles = new HashSet();
    private long flushID = -1L;
    private long compactID = -1L;
    private TServerInstance lastLocation = null;
    private Map<Long, List<TabletFile>> bulkImported = new HashMap<Long, List<TabletFile>>();
    private long splitTime = 0L;
    private String directoryName = null;
    private Map<ExternalCompactionId, ExternalCompactionMetadata> extCompactions;

    public TabletData(TabletMetadata meta) {
        this.time = meta.getTime();
        this.compactID = meta.getCompactId().orElse(-1L);
        this.flushID = meta.getFlushId().orElse(-1L);
        this.directoryName = meta.getDirName();
        this.logEntries.addAll(meta.getLogs());
        this.scanFiles.addAll(meta.getScans());
        if (meta.getLast() != null) {
            this.lastLocation = meta.getLast();
        }
        this.dataFiles.putAll(meta.getFilesMap());
        meta.getLoaded().forEach((path, txid) -> this.bulkImported.computeIfAbsent((Long)txid, k -> new ArrayList()).add(path));
        this.extCompactions = meta.getExternalCompactions();
    }

    public TabletData(String dirName, SortedMap<StoredTabletFile, DataFileValue> highDatafileSizes, MetadataTime time, long lastFlushID, long lastCompactID, TServerInstance lastLocation, Map<Long, List<TabletFile>> bulkIngestedFiles) {
        this.directoryName = dirName;
        this.dataFiles = highDatafileSizes;
        this.time = time;
        this.flushID = lastFlushID;
        this.compactID = lastCompactID;
        this.lastLocation = lastLocation;
        this.bulkImported = bulkIngestedFiles;
        this.splitTime = System.currentTimeMillis();
        this.extCompactions = Map.of();
    }

    public MetadataTime getTime() {
        return this.time;
    }

    public SortedMap<StoredTabletFile, DataFileValue> getDataFiles() {
        return this.dataFiles;
    }

    public List<LogEntry> getLogEntries() {
        return this.logEntries;
    }

    public HashSet<StoredTabletFile> getScanFiles() {
        return this.scanFiles;
    }

    public long getFlushID() {
        return this.flushID;
    }

    public long getCompactID() {
        return this.compactID;
    }

    public TServerInstance getLastLocation() {
        return this.lastLocation;
    }

    public Map<Long, List<TabletFile>> getBulkImported() {
        return this.bulkImported;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public long getSplitTime() {
        return this.splitTime;
    }

    public Map<ExternalCompactionId, ExternalCompactionMetadata> getExternalCompactions() {
        return this.extCompactions;
    }
}

