/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.metrics.TabletServerScanMetrics;
import org.apache.accumulo.tserver.tablet.ScanDataSource;
import org.apache.accumulo.tserver.tablet.TabletBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotTablet
extends TabletBase {
    private static final Logger log = LoggerFactory.getLogger(SnapshotTablet.class);
    private final TabletHostingServer server;
    private final SortedMap<StoredTabletFile, DataFileValue> files;
    private final TabletServerResourceManager.TabletResourceManager tabletResources;
    private boolean closed = false;
    private final AtomicLong dataSourceDeletions = new AtomicLong(0L);

    public SnapshotTablet(TabletHostingServer server, TabletMetadata metadata, TabletServerResourceManager.TabletResourceManager tabletResources) {
        super(server, metadata.getExtent());
        this.server = server;
        this.files = Collections.unmodifiableSortedMap(new TreeMap(metadata.getFilesMap()));
        this.tabletResources = tabletResources;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public SortedMap<StoredTabletFile, DataFileValue> getDatafiles() {
        return this.files;
    }

    @Override
    public void addToYieldMetric(int i) {
        this.server.getScanMetrics().addYield(i);
    }

    @Override
    public long getDataSourceDeletions() {
        return this.dataSourceDeletions.get();
    }

    @Override
    TabletServerResourceManager.TabletResourceManager getTabletResources() {
        return this.tabletResources;
    }

    @Override
    public List<InMemoryMap.MemoryIterator> getMemIterators(SamplerConfigurationImpl samplerConfig) {
        return List.of();
    }

    @Override
    public void returnMemIterators(List<InMemoryMap.MemoryIterator> iters) {
    }

    @Override
    public Pair<Long, Map<TabletFile, DataFileValue>> reserveFilesForScan() {
        return new Pair((Object)0L, this.getDatafiles());
    }

    @Override
    public void returnFilesForScan(long scanId) {
    }

    @Override
    public TabletServerScanMetrics getScanMetrics() {
        return this.server.getScanMetrics();
    }

    @Override
    public synchronized void close(boolean b) throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.dataSourceDeletions.incrementAndGet();
        for (ScanDataSource activeScan : this.activeScans) {
            activeScan.interrupt();
        }
        while (!this.activeScans.isEmpty()) {
            try {
                log.debug("Closing tablet {} waiting for {} scans", (Object)this.extent, (Object)this.activeScans.size());
                this.wait(50L);
            }
            catch (InterruptedException e) {
                log.error(e.toString());
            }
        }
    }
}

