/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.system.IterationInterruptedException;
import org.apache.accumulo.core.iteratorsImpl.system.SourceSwitchingIterator;
import org.apache.accumulo.core.util.ShutdownUtil;
import org.apache.accumulo.tserver.scan.ScanParameters;
import org.apache.accumulo.tserver.tablet.Batch;
import org.apache.accumulo.tserver.tablet.KVEntry;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.apache.accumulo.tserver.tablet.ScanDataSource;
import org.apache.accumulo.tserver.tablet.TabletBase;
import org.apache.accumulo.tserver.tablet.TabletClosedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scanner {
    private static final Logger log = LoggerFactory.getLogger(Scanner.class);
    private final TabletBase tablet;
    private final ScanParameters scanParams;
    private Range range;
    private SortedKeyValueIterator<Key, Value> isolatedIter;
    private ScanDataSource isolatedDataSource;
    private boolean sawException = false;
    private boolean scanClosed = false;
    private Semaphore scannerSemaphore;
    private AtomicBoolean interruptFlag;

    Scanner(TabletBase tablet, Range range, ScanParameters scanParams, AtomicBoolean interruptFlag) {
        this.tablet = tablet;
        this.range = range;
        this.scanParams = scanParams;
        this.scannerSemaphore = new Semaphore(1, true);
        this.interruptFlag = interruptFlag;
    }

    public ScanBatch read() throws IOException, TabletClosedException {
        ScanDataSource dataSource = null;
        Batch results = null;
        try {
            SortedKeyValueIterator<Key, Value> iter;
            try {
                this.scannerSemaphore.acquire();
            }
            catch (InterruptedException e) {
                this.sawException = true;
            }
            if (this.sawException) {
                throw new IllegalStateException("Tried to use scanner after exception occurred.");
            }
            if (this.scanClosed) {
                throw new IllegalStateException("Tried to use scanner after it was closed.");
            }
            if (this.scanParams.isIsolated()) {
                if (this.isolatedDataSource == null) {
                    this.isolatedDataSource = this.tablet.createDataSource(this.scanParams, true, this.interruptFlag);
                }
                dataSource = this.isolatedDataSource;
            } else {
                dataSource = this.tablet.createDataSource(this.scanParams, true, this.interruptFlag);
            }
            if (this.scanParams.isIsolated()) {
                if (this.isolatedIter == null) {
                    this.isolatedIter = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)dataSource, true);
                } else {
                    this.isolatedDataSource.reattachFileManager();
                }
                iter = this.isolatedIter;
            } else {
                iter = new SortedKeyValueIterator<Key, Value>((SourceSwitchingIterator.DataSource)dataSource, false);
            }
            results = this.tablet.nextBatch(iter, this.range, this.scanParams);
            if (results.getResults() == null) {
                this.range = null;
                ScanBatch scanBatch = new ScanBatch(new ArrayList<KVEntry>(), false);
                return scanBatch;
            }
            if (results.getContinueKey() == null) {
                ScanBatch scanBatch = new ScanBatch(results.getResults(), false);
                return scanBatch;
            }
            this.range = new Range(results.getContinueKey(), !results.isSkipContinueKey(), this.range.getEndKey(), this.range.isEndKeyInclusive());
            ScanBatch scanBatch = new ScanBatch(results.getResults(), true);
            return scanBatch;
        }
        catch (IterationInterruptedException iie) {
            this.sawException = true;
            if (this.tablet.isClosed()) {
                throw new TabletClosedException((Exception)((Object)iie));
            }
            throw iie;
        }
        catch (IOException ioe) {
            if (ShutdownUtil.wasCausedByHadoopShutdown((Exception)ioe)) {
                log.debug("IOException while shutdown in progress ", (Throwable)ioe);
                throw new TabletClosedException(ioe);
            }
            this.sawException = true;
            dataSource.close(true);
            throw ioe;
        }
        catch (RuntimeException re) {
            if (ShutdownUtil.wasCausedByHadoopShutdown((Exception)re)) {
                log.debug("RuntimeException while shutdown in progress ", (Throwable)re);
                throw new TabletClosedException(re);
            }
            this.sawException = true;
            throw re;
        }
        finally {
            if (dataSource != null && !this.scanParams.isIsolated()) {
                dataSource.close(false);
            } else if (dataSource != null) {
                dataSource.detachFileManager();
            }
            if (results != null && results.getResults() != null) {
                this.tablet.updateQueryStats(results.getResults().size(), results.getNumBytes());
            }
            this.scannerSemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        this.interruptFlag.set(true);
        boolean obtainedLock = false;
        try {
            obtainedLock = this.scannerSemaphore.tryAcquire(10L, TimeUnit.MILLISECONDS);
            if (!obtainedLock) {
                boolean bl = false;
                return bl;
            }
            this.scanClosed = true;
            if (this.isolatedDataSource != null) {
                this.isolatedDataSource.close(false);
            }
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (obtainedLock) {
                this.scannerSemaphore.release();
            }
        }
        return true;
    }
}

