/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.security.AuthorizationContainer;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.constraints.SystemEnvironment;
import org.apache.accumulo.server.security.SecurityOperation;

public class TservConstraintEnv
implements SystemEnvironment,
Constraint.Environment {
    private final ServerContext context;
    private final TCredentials credentials;
    private final SecurityOperation security;
    private KeyExtent ke;

    TservConstraintEnv(ServerContext context, SecurityOperation secOp, TCredentials credentials) {
        this.context = context;
        this.security = secOp;
        this.credentials = credentials;
    }

    public void setExtent(KeyExtent ke) {
        this.ke = ke;
    }

    public KeyExtent getExtent() {
        return this.ke;
    }

    public TabletId getTablet() {
        return new TabletIdImpl(this.ke);
    }

    public String getUser() {
        return this.credentials.getPrincipal();
    }

    public AuthorizationContainer getAuthorizationsContainer() {
        return auth -> this.security.authenticatedUserHasAuthorizations(this.credentials, Collections.singletonList(ByteBuffer.wrap(auth.getBackingArray(), auth.offset(), auth.length())));
    }

    public ServerContext getServerContext() {
        return this.context;
    }
}

