/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.compaction.CompactionExecutorId;
import org.apache.accumulo.core.spi.compaction.CompactionPlanner;
import org.apache.accumulo.core.spi.compaction.CompactionServiceId;
import org.apache.accumulo.core.spi.compaction.ExecutorManager;
import org.apache.accumulo.core.util.compaction.CompactionExecutorIdImpl;

public class CompactionPlannerInitParams
implements CompactionPlanner.InitParameters {
    private final Map<String, String> plannerOpts;
    private final Map<CompactionExecutorId, Integer> requestedExecutors;
    private final Set<CompactionExecutorId> requestedExternalExecutors;
    private final ServiceEnvironment senv;
    private final CompactionServiceId serviceId;

    public CompactionPlannerInitParams(CompactionServiceId serviceId, Map<String, String> plannerOpts, ServiceEnvironment senv) {
        this.serviceId = serviceId;
        this.plannerOpts = plannerOpts;
        this.requestedExecutors = new HashMap<CompactionExecutorId, Integer>();
        this.requestedExternalExecutors = new HashSet<CompactionExecutorId>();
        this.senv = senv;
    }

    @Override
    public ServiceEnvironment getServiceEnvironment() {
        return this.senv;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.plannerOpts;
    }

    @Override
    public String getFullyQualifiedOption(String key) {
        return Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + this.serviceId + ".opts." + key;
    }

    @Override
    public ExecutorManager getExecutorManager() {
        return new ExecutorManager(){

            @Override
            public CompactionExecutorId createExecutor(String executorName, int threads) {
                Preconditions.checkArgument((threads > 0 ? 1 : 0) != 0, (String)"Positive number of threads required : %s", (int)threads);
                CompactionExecutorId ceid = CompactionExecutorIdImpl.internalId(CompactionPlannerInitParams.this.serviceId, executorName);
                Preconditions.checkState((!CompactionPlannerInitParams.this.getRequestedExecutors().containsKey(ceid) ? 1 : 0) != 0);
                CompactionPlannerInitParams.this.getRequestedExecutors().put(ceid, threads);
                return ceid;
            }

            @Override
            public CompactionExecutorId getExternalExecutor(String name) {
                CompactionExecutorId ceid = CompactionExecutorIdImpl.externalId(name);
                Preconditions.checkArgument((!CompactionPlannerInitParams.this.getRequestedExternalExecutors().contains(ceid) ? 1 : 0) != 0, (Object)("Duplicate external executor for queue " + name));
                CompactionPlannerInitParams.this.getRequestedExternalExecutors().add(ceid);
                return ceid;
            }
        };
    }

    public Map<CompactionExecutorId, Integer> getRequestedExecutors() {
        return this.requestedExecutors;
    }

    public Set<CompactionExecutorId> getRequestedExternalExecutors() {
        return this.requestedExternalExecutors;
    }
}

