/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.util.Objects;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.hadoop.fs.Path;

public class ValidationUtil {
    public static String validate(String path) {
        Path p = new Path(path);
        return ValidationUtil.validate(p).toString();
    }

    public static ReferenceFile validate(ReferenceFile reference) {
        ValidationUtil.validate(new Path(reference.getMetadataEntry()));
        return reference;
    }

    public static Path validate(Path path) {
        if (path.toUri().getScheme() == null) {
            throw new IllegalArgumentException("Invalid path provided, no scheme in " + path);
        }
        return path;
    }

    public static void validateRFileName(String fileName) {
        Objects.requireNonNull(fileName);
        if (!fileName.endsWith(".rf") && !fileName.endsWith("_tmp")) {
            throw new IllegalArgumentException("Provided filename (" + fileName + ") does not end with '.rf' or '_tmp'");
        }
    }

    public static void validateFileName(String fileName) {
        Objects.requireNonNull(fileName);
        if (!fileName.matches("[\\dA-Za-z._-]+")) {
            throw new IllegalArgumentException("Provided filename (" + fileName + ") contains invalid characters.");
        }
    }
}

