/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.thrift.TMutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.UnsynchronizedBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class Mutation
implements Writable {
    static final int VALUE_SIZE_COPY_CUTOFF = 32768;
    static final long MAX_MUTATION_SIZE = 0x80000000L;
    static final long SERIALIZATION_OVERHEAD = 5L;
    private boolean useOldDeserialize = false;
    private byte[] row;
    private byte[] data;
    private int entries;
    private List<byte[]> values;
    @VisibleForTesting
    long estRowAndLargeValSize = 0L;
    private UnsynchronizedBuffer.Writer buffer;
    private List<ColumnUpdate> updates;
    private static final Set<String> EMPTY = Collections.emptySet();
    private Set<String> replicationSources = EMPTY;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private int cachedValLens = -1;

    private void serialize() {
        if (this.buffer != null) {
            this.data = this.buffer.toArray();
            this.buffer = null;
        }
    }

    private ByteBuffer serializedSnapshot() {
        if (this.buffer != null) {
            return this.buffer.toByteBuffer();
        }
        return ByteBuffer.wrap(this.data);
    }

    public Mutation(byte[] row) {
        this(row, 0, row.length);
    }

    public Mutation(byte[] row, int initialBufferSize) {
        this(row, 0, row.length, initialBufferSize);
    }

    public Mutation(byte[] row, int start, int length) {
        this(row, start, length, 64);
    }

    public Mutation(byte[] row, int start, int length, int initialBufferSize) {
        this.row = new byte[length];
        System.arraycopy(row, start, this.row, 0, length);
        this.buffer = new UnsynchronizedBuffer.Writer(initialBufferSize);
        this.estRowAndLargeValSize = (long)length + 5L;
    }

    public Mutation(Text row) {
        this(row.getBytes(), 0, row.getLength());
    }

    public Mutation(Text row, int initialBufferSize) {
        this(row.getBytes(), 0, row.getLength(), initialBufferSize);
    }

    public Mutation(CharSequence row) {
        this(new Text(row.toString()));
    }

    public Mutation(CharSequence row, int initialBufferSize) {
        this(new Text(row.toString()), initialBufferSize);
    }

    public Mutation() {
    }

    public Mutation(TMutation tmutation) {
        this.row = ByteBufferUtil.toBytes(tmutation.row);
        this.data = ByteBufferUtil.toBytes(tmutation.data);
        this.entries = tmutation.entries;
        this.values = ByteBufferUtil.toBytesList(tmutation.values);
        if (tmutation.isSetSources()) {
            this.replicationSources = new HashSet<String>(tmutation.sources);
        }
        if (this.row == null) {
            throw new IllegalArgumentException("null row");
        }
        if (this.data == null) {
            throw new IllegalArgumentException("null serialized data");
        }
    }

    public Mutation(Mutation m) {
        m.serialize();
        this.row = m.row;
        this.data = m.data;
        this.entries = m.entries;
        this.values = m.values;
        this.replicationSources = m.replicationSources;
    }

    public byte[] getRow() {
        return this.row;
    }

    private void fill(byte[] b) {
        this.fill(b, b.length);
    }

    private void fill(byte[] b, int length) {
        this.buffer.writeVLong(length);
        this.buffer.add(b, 0, length);
    }

    private void fill(boolean b) {
        this.buffer.add(b);
    }

    private void fill(int i) {
        this.buffer.writeVLong(i);
    }

    private void fill(long l) {
        this.buffer.writeVLong(l);
    }

    private void put(byte[] cf, byte[] cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        this.put(cf, cf.length, cq, cq.length, cv, hasts, ts, deleted, val, val.length);
    }

    private void put(Text cf, Text cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        this.put(cf.getBytes(), cf.getLength(), cq.getBytes(), cq.getLength(), cv, hasts, ts, deleted, val, val.length);
    }

    private void put(byte[] cf, int cfLength, byte[] cq, int cqLength, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val, int valLength) {
        if (this.buffer == null) {
            throw new IllegalStateException("Can not add to mutation after serializing it");
        }
        long estimatedSizeAfterPut = this.estRowAndLargeValSize + (long)this.buffer.size() + (long)cfLength + (long)cqLength + (long)cv.length + (long)(hasts ? 8 : 0) + (long)valLength + 2L + 20L;
        Preconditions.checkArgument((estimatedSizeAfterPut < 0x80000000L && estimatedSizeAfterPut >= 0L ? 1 : 0) != 0, (Object)"Maximum mutation size must be less than 2GB ");
        this.fill(cf, cfLength);
        this.fill(cq, cqLength);
        this.fill(cv);
        this.fill(hasts);
        if (hasts) {
            this.fill(ts);
        }
        this.fill(deleted);
        if (valLength < 32768) {
            this.fill(val, valLength);
        } else {
            if (this.values == null) {
                this.values = new ArrayList<byte[]>();
            }
            byte[] copy = new byte[valLength];
            System.arraycopy(val, 0, copy, 0, valLength);
            this.values.add(copy);
            this.fill(-1 * this.values.size());
            this.estRowAndLargeValSize += (long)valLength + 5L;
        }
        ++this.entries;
    }

    private void put(CharSequence cf, CharSequence cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        this.put(new Text(cf.toString()), new Text(cq.toString()), cv, hasts, ts, deleted, val);
    }

    private void put(Text cf, Text cq, byte[] cv, boolean hasts, long ts, boolean deleted, Text val) {
        this.put(cf.getBytes(), cf.getLength(), cq.getBytes(), cq.getLength(), cv, hasts, ts, deleted, val.getBytes(), val.getLength());
    }

    private void put(CharSequence cf, CharSequence cq, byte[] cv, boolean hasts, long ts, boolean deleted, CharSequence val) {
        this.put(new Text(cf.toString()), new Text(cq.toString()), cv, hasts, ts, deleted, new Text(val.toString()));
    }

    public void put(Text columnFamily, Text columnQualifier, Value value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, false, value.get());
    }

    public void put(Text columnFamily, Text columnQualifier, ColumnVisibility columnVisibility, Value value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, false, value.get());
    }

    public void put(Text columnFamily, Text columnQualifier, long timestamp, Value value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, false, value.get());
    }

    public void put(Text columnFamily, Text columnQualifier, ColumnVisibility columnVisibility, long timestamp, Value value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, false, value.get());
    }

    public void putDelete(Text columnFamily, Text columnQualifier) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(Text columnFamily, Text columnQualifier, ColumnVisibility columnVisibility) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(Text columnFamily, Text columnQualifier, long timestamp) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, true, EMPTY_BYTES);
    }

    public void putDelete(Text columnFamily, Text columnQualifier, ColumnVisibility columnVisibility, long timestamp) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, true, EMPTY_BYTES);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, Value value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, false, value.get());
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, Value value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, false, value.get());
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, long timestamp, Value value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, false, value.get());
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, long timestamp, Value value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, false, value.get());
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier, long timestamp) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, true, EMPTY_BYTES);
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, long timestamp) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, true, EMPTY_BYTES);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, CharSequence value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, false, value);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, CharSequence value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, false, value);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, long timestamp, CharSequence value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, false, value);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, long timestamp, CharSequence value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, false, value);
    }

    public void put(byte[] columnFamily, byte[] columnQualifier, byte[] value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, false, value);
    }

    public void put(byte[] columnFamily, byte[] columnQualifier, ColumnVisibility columnVisibility, byte[] value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, false, value);
    }

    public void put(byte[] columnFamily, byte[] columnQualifier, long timestamp, byte[] value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, false, value);
    }

    public void put(byte[] columnFamily, byte[] columnQualifier, ColumnVisibility columnVisibility, long timestamp, byte[] value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, false, value);
    }

    public void putDelete(byte[] columnFamily, byte[] columnQualifier) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(byte[] columnFamily, byte[] columnQualifier, ColumnVisibility columnVisibility) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(byte[] columnFamily, byte[] columnQualifier, long timestamp) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, true, EMPTY_BYTES);
    }

    public void putDelete(byte[] columnFamily, byte[] columnQualifier, ColumnVisibility columnVisibility, long timestamp) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, true, EMPTY_BYTES);
    }

    public FamilyOptions at() {
        return new Options();
    }

    private byte[] oldReadBytes(UnsynchronizedBuffer.Reader in) {
        int len = in.readInt();
        if (len == 0) {
            return EMPTY_BYTES;
        }
        byte[] bytes = new byte[len];
        in.readBytes(bytes);
        return bytes;
    }

    private byte[] readBytes(UnsynchronizedBuffer.Reader in) {
        int len = (int)in.readVLong();
        if (len == 0) {
            return EMPTY_BYTES;
        }
        byte[] bytes = new byte[len];
        in.readBytes(bytes);
        return bytes;
    }

    public List<ColumnUpdate> getUpdates() {
        this.serialize();
        UnsynchronizedBuffer.Reader in = new UnsynchronizedBuffer.Reader(this.data);
        if (this.updates == null) {
            if (this.entries == 1) {
                this.updates = Collections.singletonList(this.deserializeColumnUpdate(in));
            } else {
                ColumnUpdate[] tmpUpdates = new ColumnUpdate[this.entries];
                for (int i = 0; i < this.entries; ++i) {
                    tmpUpdates[i] = this.deserializeColumnUpdate(in);
                }
                this.updates = Arrays.asList(tmpUpdates);
            }
        }
        return this.updates;
    }

    protected ColumnUpdate newColumnUpdate(byte[] cf, byte[] cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        return new ColumnUpdate(cf, cq, cv, hasts, ts, deleted, val);
    }

    private ColumnUpdate deserializeColumnUpdate(UnsynchronizedBuffer.Reader in) {
        byte[] val;
        byte[] cf = this.readBytes(in);
        byte[] cq = this.readBytes(in);
        byte[] cv = this.readBytes(in);
        boolean hasts = in.readBoolean();
        long ts = 0L;
        if (hasts) {
            ts = in.readVLong();
        }
        boolean deleted = in.readBoolean();
        int valLen = (int)in.readVLong();
        if (valLen < 0) {
            val = this.values.get(-1 * valLen - 1);
        } else if (valLen == 0) {
            val = EMPTY_BYTES;
        } else {
            val = new byte[valLen];
            in.readBytes(val);
        }
        return this.newColumnUpdate(cf, cq, cv, hasts, ts, deleted, val);
    }

    long getValueLengths() {
        if (this.values == null) {
            return 0L;
        }
        if (this.cachedValLens == -1) {
            int tmpCVL = 0;
            for (byte[] val : this.values) {
                tmpCVL += val.length;
            }
            this.cachedValLens = tmpCVL;
        }
        return this.cachedValLens;
    }

    public long numBytes() {
        this.serialize();
        return (long)(this.row.length + this.data.length) + this.getValueLengths();
    }

    public long estimatedMemoryUsed() {
        return this.numBytes() + 238L;
    }

    public int size() {
        return this.entries;
    }

    public void addReplicationSource(String peer) {
        if (this.replicationSources == null || this.replicationSources == EMPTY) {
            this.replicationSources = new HashSet<String>();
        }
        this.replicationSources.add(peer);
    }

    public void setReplicationSources(Set<String> sources) {
        Objects.requireNonNull(sources);
        this.replicationSources = sources;
    }

    public Set<String> getReplicationSources() {
        if (this.replicationSources == null) {
            return EMPTY;
        }
        return Collections.unmodifiableSet(this.replicationSources);
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        boolean valuesPresent;
        this.updates = null;
        this.cachedValLens = -1;
        this.buffer = null;
        this.useOldDeserialize = false;
        byte first = in.readByte();
        if ((first & 0x80) != 128) {
            this.oldReadFields(first, in);
            this.useOldDeserialize = true;
            return;
        }
        int len = WritableUtils.readVInt((DataInput)in);
        this.row = new byte[len];
        in.readFully(this.row);
        len = WritableUtils.readVInt((DataInput)in);
        this.data = new byte[len];
        in.readFully(this.data);
        this.entries = WritableUtils.readVInt((DataInput)in);
        boolean bl = valuesPresent = (first & 1) == 1;
        if (valuesPresent) {
            this.values = new ArrayList<byte[]>();
            int numValues = WritableUtils.readVInt((DataInput)in);
            for (i = 0; i < numValues; ++i) {
                len = WritableUtils.readVInt((DataInput)in);
                byte[] val = new byte[len];
                in.readFully(val);
                this.values.add(val);
            }
        } else {
            this.values = null;
        }
        if ((first & 2) == 2) {
            int numMutations = WritableUtils.readVInt((DataInput)in);
            this.replicationSources = new HashSet<String>();
            for (i = 0; i < numMutations; ++i) {
                this.replicationSources.add(WritableUtils.readString((DataInput)in));
            }
        }
    }

    protected void droppingOldTimestamp(long ts) {
    }

    private void oldReadFields(byte first, DataInput in) throws IOException {
        int i;
        ArrayList<byte[]> localValues;
        byte b = in.readByte();
        byte c = in.readByte();
        byte d = in.readByte();
        int len = (first & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
        this.row = new byte[len];
        in.readFully(this.row);
        len = in.readInt();
        byte[] localData = new byte[len];
        in.readFully(localData);
        int localEntries = in.readInt();
        boolean valuesPresent = in.readBoolean();
        if (valuesPresent) {
            localValues = new ArrayList<byte[]>();
            int numValues = in.readInt();
            for (i = 0; i < numValues; ++i) {
                len = in.readInt();
                byte[] val = new byte[len];
                in.readFully(val);
                localValues.add(val);
            }
        } else {
            localValues = null;
        }
        UnsynchronizedBuffer.Reader din = new UnsynchronizedBuffer.Reader(localData);
        this.buffer = new UnsynchronizedBuffer.Writer();
        for (i = 0; i < localEntries; ++i) {
            byte[] val;
            byte[] cf = this.oldReadBytes(din);
            byte[] cq = this.oldReadBytes(din);
            byte[] cv = this.oldReadBytes(din);
            boolean hasts = din.readBoolean();
            long ts = din.readLong();
            boolean deleted = din.readBoolean();
            int valLen = din.readInt();
            if (valLen < 0) {
                val = (byte[])localValues.get(-1 * valLen - 1);
            } else if (valLen == 0) {
                val = EMPTY_BYTES;
            } else {
                val = new byte[valLen];
                din.readBytes(val);
            }
            this.put(cf, cq, cv, hasts, ts, deleted, val);
            if (hasts) continue;
            this.droppingOldTimestamp(ts);
        }
        this.serialize();
    }

    public void write(DataOutput out) throws IOException {
        int hasValues;
        byte[] integerBuffer = new byte[5];
        this.serialize();
        int n = hasValues = this.values == null ? 0 : 1;
        if (!this.replicationSources.isEmpty()) {
            hasValues = (byte)(2 | hasValues);
        }
        out.write((byte)(0x80 | hasValues));
        UnsynchronizedBuffer.writeVInt(out, integerBuffer, this.row.length);
        out.write(this.row);
        UnsynchronizedBuffer.writeVInt(out, integerBuffer, this.data.length);
        out.write(this.data);
        UnsynchronizedBuffer.writeVInt(out, integerBuffer, this.entries);
        if ((1 & hasValues) == 1) {
            UnsynchronizedBuffer.writeVInt(out, integerBuffer, this.values.size());
            for (byte[] val : this.values) {
                UnsynchronizedBuffer.writeVInt(out, integerBuffer, val.length);
                out.write(val);
            }
        }
        if ((2 & hasValues) == 2) {
            UnsynchronizedBuffer.writeVInt(out, integerBuffer, this.replicationSources.size());
            for (String source : this.replicationSources) {
                WritableUtils.writeString((DataOutput)out, (String)source);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o.getClass().equals(this.getClass())) {
            return this.equalMutation((Mutation)o);
        }
        return false;
    }

    public int hashCode() {
        return this.serializedSnapshot().hashCode();
    }

    public boolean equals(Mutation m) {
        return this.equals((Object)m);
    }

    private boolean equalMutation(Mutation m) {
        ByteBuffer myData = this.serializedSnapshot();
        ByteBuffer otherData = m.serializedSnapshot();
        if (Arrays.equals(this.row, m.row) && this.entries == m.entries && myData.equals(otherData)) {
            if (!this.replicationSources.equals(m.replicationSources)) {
                return false;
            }
            if (this.values == null && m.values == null) {
                return true;
            }
            if (this.values != null && m.values != null && this.values.size() == m.values.size()) {
                for (int i = 0; i < this.values.size(); ++i) {
                    if (Arrays.equals(this.values.get(i), m.values.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public TMutation toThrift() {
        return this.toThrift(true);
    }

    private TMutation toThrift(boolean serialize) {
        if (serialize) {
            this.serialize();
        }
        ByteBuffer data = this.serializedSnapshot();
        TMutation tmutation = new TMutation(ByteBuffer.wrap(this.row), data, ByteBufferUtil.toByteBuffers(this.values), this.entries);
        if (!this.replicationSources.isEmpty()) {
            tmutation.setSources(new ArrayList<String>(this.replicationSources));
        }
        return tmutation;
    }

    protected SERIALIZED_FORMAT getSerializedFormat() {
        return this.useOldDeserialize ? SERIALIZED_FORMAT.VERSION1 : SERIALIZED_FORMAT.VERSION2;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("mutation: ").append(new String(this.row, StandardCharsets.UTF_8)).append('\n');
        for (ColumnUpdate update2 : this.getUpdates()) {
            sb.append(" update: ");
            sb.append(new String(update2.getColumnFamily(), StandardCharsets.UTF_8));
            sb.append(':');
            sb.append(new String(update2.getColumnQualifier(), StandardCharsets.UTF_8));
            sb.append(" value ");
            if (update2.isDeleted()) {
                sb.append("[delete]");
            } else {
                sb.append(new String(update2.getValue(), StandardCharsets.UTF_8));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private class Options
    implements FamilyOptions {
        byte[] columnFamily;
        int columnFamilyLength;
        byte[] columnQualifier;
        int columnQualifierLength;
        byte[] columnVisibility = null;
        int columnVisibilityLength;
        boolean hasTs = false;
        long timestamp;

        private Options() {
        }

        private QualifierOptions family(byte[] colFam, int colFamLength) {
            this.columnFamily = colFam;
            this.columnFamilyLength = colFamLength;
            return this;
        }

        @Override
        public QualifierOptions family(byte[] colFam) {
            return this.family(colFam, colFam.length);
        }

        @Override
        public QualifierOptions family(ByteBuffer colFam) {
            return this.family(ByteBufferUtil.toBytes(colFam));
        }

        @Override
        public QualifierOptions family(CharSequence colFam) {
            return this.family(new Text(colFam.toString()));
        }

        @Override
        public QualifierOptions family(Text colFam) {
            return this.family(colFam.getBytes(), colFam.getLength());
        }

        private VisibilityOptions qualifier(byte[] colQual, int colQualLength) {
            this.columnQualifier = colQual;
            this.columnQualifierLength = colQualLength;
            return this;
        }

        @Override
        public VisibilityOptions qualifier(byte[] colQual) {
            return this.qualifier(colQual, colQual.length);
        }

        @Override
        public VisibilityOptions qualifier(ByteBuffer colQual) {
            return this.qualifier(ByteBufferUtil.toBytes(colQual));
        }

        @Override
        public VisibilityOptions qualifier(CharSequence colQual) {
            return this.qualifier(new Text(colQual.toString()));
        }

        @Override
        public VisibilityOptions qualifier(Text colQual) {
            return this.qualifier(colQual.getBytes(), colQual.getLength());
        }

        private TimestampOptions visibility(byte[] colVis, int colVisLen) {
            this.columnVisibility = colVis;
            this.columnVisibilityLength = colVisLen;
            return this;
        }

        @Override
        public TimestampOptions visibility(byte[] colVis) {
            return this.visibility(colVis, colVis.length);
        }

        @Override
        public TimestampOptions visibility(ByteBuffer colVis) {
            return this.visibility(ByteBufferUtil.toBytes(colVis));
        }

        @Override
        public TimestampOptions visibility(CharSequence colVis) {
            return this.visibility(new Text(colVis.toString()));
        }

        @Override
        public TimestampOptions visibility(ColumnVisibility colVis) {
            return this.visibility(colVis.getExpression());
        }

        @Override
        public TimestampOptions visibility(Text colVis) {
            return this.visibility(colVis.toString().getBytes());
        }

        @Override
        public MutationOptions timestamp(long ts) {
            this.hasTs = true;
            this.timestamp = ts;
            return this;
        }

        private Mutation put(byte[] val, boolean delete) {
            if (Mutation.this.buffer == null) {
                throw new IllegalStateException("Can not add to mutation after serializing it");
            }
            Mutation.this.fill(this.columnFamily, this.columnFamilyLength);
            Mutation.this.fill(this.columnQualifier, this.columnQualifierLength);
            if (this.columnVisibility == null) {
                Mutation.this.fill(EMPTY_BYTES, EMPTY_BYTES.length);
            } else {
                Mutation.this.fill(this.columnVisibility, this.columnVisibilityLength);
            }
            Mutation.this.fill(this.hasTs);
            if (this.hasTs) {
                Mutation.this.fill(this.timestamp);
            }
            Mutation.this.fill(delete);
            if (val.length < 32768) {
                Mutation.this.fill(val, val.length);
            } else {
                if (Mutation.this.values == null) {
                    Mutation.this.values = new ArrayList<byte[]>();
                }
                byte[] copy = new byte[val.length];
                System.arraycopy(val, 0, copy, 0, val.length);
                Mutation.this.values.add(copy);
                Mutation.this.fill(-1 * Mutation.this.values.size());
            }
            ++Mutation.this.entries;
            return Mutation.this;
        }

        @Override
        public Mutation put(byte[] val) {
            return this.put(val, false);
        }

        @Override
        public Mutation put(ByteBuffer val) {
            return this.put(ByteBufferUtil.toBytes(val), false);
        }

        @Override
        public Mutation put(CharSequence val) {
            return this.put(new Text(val.toString()));
        }

        @Override
        public Mutation put(Text val) {
            return this.put(val.toString().getBytes(), false);
        }

        @Override
        public Mutation put(Value val) {
            return this.put(val.get(), false);
        }

        @Override
        public Mutation delete() {
            return this.put(EMPTY_BYTES, true);
        }
    }

    public static interface MutationOptions {
        public Mutation put(byte[] var1);

        public Mutation put(ByteBuffer var1);

        public Mutation put(CharSequence var1);

        public Mutation put(Text var1);

        public Mutation put(Value var1);

        public Mutation delete();
    }

    public static interface TimestampOptions
    extends MutationOptions {
        public MutationOptions timestamp(long var1);
    }

    public static interface VisibilityOptions
    extends TimestampOptions {
        public TimestampOptions visibility(byte[] var1);

        public TimestampOptions visibility(ByteBuffer var1);

        public TimestampOptions visibility(CharSequence var1);

        public TimestampOptions visibility(ColumnVisibility var1);

        public TimestampOptions visibility(Text var1);
    }

    public static interface QualifierOptions
    extends VisibilityOptions {
        public VisibilityOptions qualifier(byte[] var1);

        public VisibilityOptions qualifier(ByteBuffer var1);

        public VisibilityOptions qualifier(CharSequence var1);

        public VisibilityOptions qualifier(Text var1);
    }

    public static interface FamilyOptions
    extends QualifierOptions {
        public QualifierOptions family(byte[] var1);

        public QualifierOptions family(ByteBuffer var1);

        public QualifierOptions family(CharSequence var1);

        public QualifierOptions family(Text var1);
    }

    public static enum SERIALIZED_FORMAT {
        VERSION1,
        VERSION2;

    }
}

