/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf.cluster;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class ClusterConfigParser {
    private static final String PROPERTY_FORMAT = "%s=\"%s\"%n";
    private static final String[] SECTIONS = new String[]{"manager", "monitor", "gc", "tserver"};

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="paths not set by user input")
    public static Map<String, String> parseConfiguration(String configFile) throws IOException {
        HashMap<String, String> results = new HashMap<String, String>();
        try (InputStream fis = Files.newInputStream(Paths.get(configFile, new String[0]), StandardOpenOption.READ);){
            Yaml y = new Yaml();
            Map config = (Map)y.load(fis);
            config.forEach((k, v) -> ClusterConfigParser.flatten("", k, v, results));
        }
        return results;
    }

    private static String addTheDot(String key) {
        return key.endsWith(".") ? "" : ".";
    }

    private static void flatten(String parentKey, String key, Object value, Map<String, String> results) {
        String parent;
        String string = parent = parentKey == null || parentKey.equals("") ? "" : parentKey + ClusterConfigParser.addTheDot(parentKey);
        if (value instanceof String) {
            results.put(parent + key, (String)value);
            return;
        }
        if (value instanceof List) {
            ((List)value).forEach(l -> {
                if (l instanceof String) {
                    String val = value.toString();
                    results.put(parent + key, val.substring(1, val.length() - 1).replace(", ", " "));
                    return;
                }
                ClusterConfigParser.flatten(parent, key, l, results);
            });
        } else if (value instanceof Map) {
            Map map = (Map)value;
            map.forEach((k, v) -> ClusterConfigParser.flatten(parent + key, k, v, results));
        } else {
            if (value instanceof Number) {
                results.put(parent + key, value.toString());
                return;
            }
            throw new RuntimeException("Unhandled object type: " + value.getClass());
        }
    }

    public static void outputShellVariables(Map<String, String> config, PrintStream out) {
        for (String section : SECTIONS) {
            if (config.containsKey(section)) {
                out.printf(PROPERTY_FORMAT, section.toUpperCase() + "_HOSTS", config.get(section));
                continue;
            }
            if (section.equals("manager") || section.equals("tserver")) {
                throw new RuntimeException("Required configuration section is missing: " + section);
            }
            System.err.println("WARN: " + section + " is missing");
        }
        if (config.containsKey("compaction.coordinator")) {
            out.printf(PROPERTY_FORMAT, "COORDINATOR_HOSTS", config.get("compaction.coordinator"));
        }
        String compactorPrefix = "compaction.compactor.";
        Set compactorQueues = config.keySet().stream().filter(k -> k.startsWith(compactorPrefix)).map(k -> k.substring(compactorPrefix.length())).collect(Collectors.toSet());
        if (!compactorQueues.isEmpty()) {
            out.printf(PROPERTY_FORMAT, "COMPACTION_QUEUES", compactorQueues.stream().collect(Collectors.joining(" ")));
            for (String queue : compactorQueues) {
                out.printf(PROPERTY_FORMAT, "COMPACTOR_HOSTS_" + queue, config.get("compaction.compactor." + queue));
            }
        }
        String sserverPrefix = "sserver.";
        Set<String> sserverGroups = config.keySet().stream().filter(k -> k.startsWith(sserverPrefix)).map(k -> k.substring(sserverPrefix.length())).collect(Collectors.toSet());
        if (!sserverGroups.isEmpty()) {
            out.printf(PROPERTY_FORMAT, "SSERVER_GROUPS", sserverGroups.stream().collect(Collectors.joining(" ")));
            sserverGroups.forEach(ssg -> out.printf(PROPERTY_FORMAT, "SSERVER_HOSTS_" + ssg, config.get(sserverPrefix + ssg)));
        }
        String numTservers = config.getOrDefault("tservers_per_host", "1");
        out.print("NUM_TSERVERS=\"${NUM_TSERVERS:=" + numTservers + "}\"\n");
        String numSservers = config.getOrDefault("sservers_per_host", "1");
        out.print("NUM_SSERVERS=\"${NUM_SSERVERS:=" + numSservers + "}\"\n");
        out.flush();
    }

    public static void main(String[] args) throws IOException {
        if (args == null || args.length != 1) {
            System.err.println("Usage: ClusterConfigParser <configFile>");
            System.exit(1);
        }
        ClusterConfigParser.outputShellVariables(ClusterConfigParser.parseConfiguration(args[0]), System.out);
    }
}

