/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.accumulo.core.conf.Property;
import org.apache.commons.lang3.Range;
import org.apache.hadoop.fs.Path;

public enum PropertyType {
    PREFIX(null, x -> false, null),
    TIMEDURATION("duration", PropertyType.boundedUnits(0L, Long.MAX_VALUE, true, "", "ms", "s", "m", "h", "d"), "A non-negative integer optionally followed by a unit of time (whitespace disallowed), as in 30s.\nIf no unit of time is specified, seconds are assumed. Valid units are 'ms', 's', 'm', 'h' for milliseconds, seconds, minutes, and hours.\nExamples of valid durations are '600', '30s', '45m', '30000ms', '3d', and '1h'.\nExamples of invalid durations are '1w', '1h30m', '1s 200ms', 'ms', '', and 'a'.\nUnless otherwise stated, the max value for the duration represented in milliseconds is 9223372036854775807"),
    BYTES("bytes", PropertyType.boundedUnits(0L, Long.MAX_VALUE, false, "", "B", "K", "M", "G"), "A positive integer optionally followed by a unit of memory (whitespace disallowed).\nIf no unit is specified, bytes are assumed. Valid units are 'B', 'K', 'M' or 'G' for bytes, kilobytes, megabytes, gigabytes.\nExamples of valid memories are '1024', '20B', '100K', '1500M', '2G', '20%'.\nExamples of invalid memories are '1M500K', '1M 2K', '1MB', '1.5G', '1,024K', '', and 'a'.\nUnless otherwise stated, the max value for the memory represented in bytes is 9223372036854775807"),
    MEMORY("memory", PropertyType.boundedUnits(0L, Long.MAX_VALUE, false, "", "B", "K", "M", "G", "%"), "A positive integer optionally followed by a unit of memory or a percentage (whitespace disallowed).\nIf a percentage is specified, memory will be a percentage of the max memory allocated to a Java process (set by the JVM option -Xmx).\nIf no unit is specified, bytes are assumed. Valid units are 'B', 'K', 'M', 'G', '%' for bytes, kilobytes, megabytes, gigabytes, and percentage.\nExamples of valid memories are '1024', '20B', '100K', '1500M', '2G', '20%'.\nExamples of invalid memories are '1M500K', '1M 2K', '1MB', '1.5G', '1,024K', '', and 'a'.\nUnless otherwise stated, the max value for the memory represented in bytes is 9223372036854775807"),
    HOSTLIST("host list", new Matches("[\\w-]+(?:\\.[\\w-]+)*(?:\\:\\d{1,5})?(?:,[\\w-]+(?:\\.[\\w-]+)*(?:\\:\\d{1,5})?)*"), "A comma-separated list of hostnames or ip addresses, with optional port numbers.\nExamples of valid host lists are 'localhost:2000,www.example.com,10.10.1.1:500' and 'localhost'.\nExamples of invalid host lists are '', ':1000', and 'localhost:80000'"),
    PORT("port", x -> Stream.of(new Bounds(1024L, 65535L), PropertyType.in(true, "0"), new PortRange("\\d{4,5}-\\d{4,5}")).anyMatch(y -> y.test(x)), "An positive integer in the range 1024-65535 (not already in use or specified elsewhere in the configuration),\nzero to indicate any open ephemeral port, or a range of positive integers specified as M-N"),
    COUNT("count", new Bounds(0L, Integer.MAX_VALUE), "A non-negative integer in the range of 0-2147483647"),
    FRACTION("fraction/percentage", new FractionPredicate(), "A floating point number that represents either a fraction or, if suffixed with the '%' character, a percentage.\nExamples of valid fractions/percentages are '10', '1000%', '0.05', '5%', '0.2%', '0.0005'.\nExamples of invalid fractions/percentages are '', '10 percent', 'Hulk Hogan'"),
    PATH("path", x -> true, "A string that represents a filesystem path, which can be either relative or absolute to some directory. The filesystem depends on the property. Substitutions of the ACCUMULO_HOME environment variable can be done in the system config file using '${env:ACCUMULO_HOME}' or similar."),
    ABSOLUTEPATH("absolute path", x -> x == null || x.trim().isEmpty() || new Path(x.trim()).isAbsolute() || x.equals(Property.VFS_CLASSLOADER_CACHE_DIR.getDefaultValue()), "An absolute filesystem path. The filesystem depends on the property. This is the same as path, but enforces that its root is explicitly specified."),
    CLASSNAME("java class", new Matches("[\\w$.]*"), "A fully qualified java class name representing a class on the classpath.\nAn example is 'java.lang.String', rather than 'String'"),
    CLASSNAMELIST("java class list", new Matches("[\\w$.,]*"), "A list of fully qualified java class names representing classes on the classpath.\nAn example is 'java.lang.String', rather than 'String'"),
    DURABILITY("durability", PropertyType.in(false, null, "default", "none", "log", "flush", "sync"), "One of 'none', 'log', 'flush' or 'sync'."),
    GC_POST_ACTION("gc_post_action", PropertyType.in(true, null, "none", "flush", "compact"), "One of 'none', 'flush', or 'compact'."),
    STRING("string", x -> true, "An arbitrary string of characters whose format is unspecified and interpreted based on the context of the property to which it applies."),
    BOOLEAN("boolean", PropertyType.in(false, null, "true", "false"), "Has a value of either 'true' or 'false' (case-insensitive)"),
    URI("uri", x -> true, "A valid URI");

    private String shortname;
    private String format;
    private transient Predicate<String> predicate;
    private static final Pattern SUFFIX_REGEX;
    private static final Function<String, String> stripUnits;

    private PropertyType(String shortname, Predicate<String> predicate, String formatDescription) {
        this.shortname = shortname;
        this.predicate = Objects.requireNonNull(predicate);
        this.format = formatDescription;
    }

    public String toString() {
        return this.shortname;
    }

    String getFormatDescription() {
        return this.format;
    }

    public boolean isValidFormat(String value) {
        Preconditions.checkState((this.predicate != null ? 1 : 0) != 0, (Object)"Predicate was null, maybe this enum was serialized????");
        return this.predicate.test(value);
    }

    private static Predicate<String> in(boolean caseSensitive, String ... allowedSet) {
        if (caseSensitive) {
            return x -> Arrays.stream(allowedSet).anyMatch(y -> x == null && y == null || x != null && x.equals(y));
        }
        Function<String, String> toLower = x -> x == null ? null : x.toLowerCase();
        return x -> Arrays.stream(allowedSet).map(toLower).anyMatch(y -> x == null && y == null || x != null && ((String)toLower.apply((String)x)).equals(y));
    }

    private static Predicate<String> boundedUnits(long lowerBound, long upperBound, boolean caseSensitive, String ... suffixes) {
        HasSuffix suffixCheck = new HasSuffix(caseSensitive, suffixes);
        return x -> x == null || suffixCheck.test(x) && new Bounds(lowerBound, upperBound).test(stripUnits.apply((String)x));
    }

    static {
        SUFFIX_REGEX = Pattern.compile("[^\\d]*$");
        stripUnits = x -> x == null ? null : SUFFIX_REGEX.matcher(x.trim()).replaceAll("");
    }

    public static class PortRange
    extends Matches {
        public static final Range<Integer> VALID_RANGE = Range.between((Comparable)Integer.valueOf(1024), (Comparable)Integer.valueOf(65535));

        public PortRange(String pattern) {
            super(pattern);
        }

        @Override
        public boolean test(String input) {
            if (super.test(input)) {
                try {
                    PortRange.parse(input);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            return false;
        }

        public static IntStream parse(String portRange) {
            int idx = portRange.indexOf(45);
            if (idx != -1) {
                int low = Integer.parseInt(portRange.substring(0, idx));
                int high = Integer.parseInt(portRange.substring(idx + 1));
                if (!VALID_RANGE.contains((Object)low) || !VALID_RANGE.contains((Object)high) || low > high) {
                    throw new IllegalArgumentException("Invalid port range specified, only 1024 to 65535 supported.");
                }
                return IntStream.rangeClosed(low, high);
            }
            throw new IllegalArgumentException("Invalid port range specification, must use M-N notation.");
        }
    }

    private static class Matches
    implements Predicate<String> {
        protected final Pattern pattern;

        public Matches(String pattern) {
            this(pattern, 32);
        }

        public Matches(String pattern, int flags) {
            this(Pattern.compile(Objects.requireNonNull(pattern), flags));
        }

        public Matches(Pattern pattern) {
            Objects.requireNonNull(pattern);
            this.pattern = pattern;
        }

        @Override
        public boolean test(String input) {
            return input == null || this.pattern.matcher(input).matches();
        }
    }

    private static class Bounds
    implements Predicate<String> {
        private final long lowerBound;
        private final long upperBound;
        private final boolean lowerInclusive;
        private final boolean upperInclusive;

        public Bounds(long lowerBound, long upperBound) {
            this(lowerBound, true, upperBound, true);
        }

        public Bounds(long lowerBound, boolean lowerInclusive, long upperBound, boolean upperInclusive) {
            this.lowerBound = lowerBound;
            this.lowerInclusive = lowerInclusive;
            this.upperBound = upperBound;
            this.upperInclusive = upperInclusive;
        }

        @Override
        public boolean test(String input) {
            long number;
            if (input == null) {
                return true;
            }
            try {
                number = Long.parseLong(input);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (number < this.lowerBound || !this.lowerInclusive && number == this.lowerBound) {
                return false;
            }
            return number <= this.upperBound && (this.upperInclusive || number != this.upperBound);
        }
    }

    private static class FractionPredicate
    implements Predicate<String> {
        private FractionPredicate() {
        }

        @Override
        public boolean test(String input) {
            if (input == null) {
                return true;
            }
            try {
                double d = !input.isEmpty() && input.charAt(input.length() - 1) == '%' ? Double.parseDouble(input.substring(0, input.length() - 1)) : Double.parseDouble(input);
                return d >= 0.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    private static class HasSuffix
    implements Predicate<String> {
        private final Predicate<String> p;

        public HasSuffix(boolean caseSensitive, String ... suffixes) {
            this.p = PropertyType.in(caseSensitive, suffixes);
        }

        @Override
        public boolean test(String input) {
            Objects.requireNonNull(input);
            Matcher m = SUFFIX_REGEX.matcher(input);
            if (m.find()) {
                if (m.groupCount() != 0) {
                    throw new AssertionError(m.groupCount());
                }
                return this.p.test(m.group());
            }
            return true;
        }
    }
}

