/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.accumulo.core.conf.ClientProperty;

public class ClientConfigGenerate {
    private PrintStream doc;
    private final TreeMap<String, ClientProperty> sortedProps = new TreeMap();

    private ClientConfigGenerate(PrintStream doc) {
        Objects.requireNonNull(doc);
        this.doc = doc;
        for (ClientProperty prop : ClientProperty.values()) {
            this.sortedProps.put(prop.getKey(), prop);
        }
    }

    private void generateMarkdown() {
        new Markdown().generate();
    }

    private void generateConfigFile() {
        new ConfigFile().generate();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 2) {
            try (PrintStream stream = new PrintStream(args[1], StandardCharsets.UTF_8);){
                ClientConfigGenerate clientConfigGenerate = new ClientConfigGenerate(stream);
                if (args[0].equals("--generate-markdown")) {
                    clientConfigGenerate.generateMarkdown();
                    return;
                }
                if (args[0].equals("--generate-config")) {
                    clientConfigGenerate.generateConfigFile();
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Usage: " + ClientConfigGenerate.class.getName() + " [--generate-markdown|--generate-config] <filename>");
    }

    private class ConfigFile
    extends Format {
        private ConfigFile() {
        }

        @Override
        void beginSection(String section) {
            ClientConfigGenerate.this.doc.println("\n## " + section + " properties");
            ClientConfigGenerate.this.doc.println("## --------------");
        }

        @Override
        void pageHeader() {
            ClientConfigGenerate.this.doc.println("# Licensed to the Apache Software Foundation (ASF) under one or more");
            ClientConfigGenerate.this.doc.println("# contributor license agreements.  See the NOTICE file distributed with");
            ClientConfigGenerate.this.doc.println("# this work for additional information regarding copyright ownership.");
            ClientConfigGenerate.this.doc.println("# The ASF licenses this file to You under the Apache License, Version 2.0");
            ClientConfigGenerate.this.doc.println("# (the \"License\"); you may not use this file except in compliance with");
            ClientConfigGenerate.this.doc.println("# the License.  You may obtain a copy of the License at");
            ClientConfigGenerate.this.doc.println("#");
            ClientConfigGenerate.this.doc.println("#     https://www.apache.org/licenses/LICENSE-2.0");
            ClientConfigGenerate.this.doc.println("#");
            ClientConfigGenerate.this.doc.println("# Unless required by applicable law or agreed to in writing, software");
            ClientConfigGenerate.this.doc.println("# distributed under the License is distributed on an \"AS IS\" BASIS,");
            ClientConfigGenerate.this.doc.println("# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
            ClientConfigGenerate.this.doc.println("# See the License for the specific language governing permissions and");
            ClientConfigGenerate.this.doc.println("# limitations under the License.\n");
            ClientConfigGenerate.this.doc.println("################################");
            ClientConfigGenerate.this.doc.println("## Accumulo client configuration");
            ClientConfigGenerate.this.doc.println("################################\n");
            ClientConfigGenerate.this.doc.println("## NOTE - All properties that have a default are set with it. Properties that");
            ClientConfigGenerate.this.doc.println("## are uncommented must be set by the user.");
        }

        @Override
        void property(ClientProperty prop) {
            ClientConfigGenerate.this.doc.println("## " + prop.getDescription());
            if (!prop.isRequired()) {
                ClientConfigGenerate.this.doc.print("#");
            }
            ClientConfigGenerate.this.doc.println(prop.getKey() + "=" + prop.getDefaultValue() + "\n");
        }
    }

    private class Markdown
    extends Format {
        private Markdown() {
        }

        @Override
        void beginSection(String section) {
        }

        @Override
        void pageHeader() {
            ClientConfigGenerate.this.doc.println("---");
            ClientConfigGenerate.this.doc.println("title: Client Properties");
            ClientConfigGenerate.this.doc.println("category: configuration");
            ClientConfigGenerate.this.doc.println("order: 3");
            ClientConfigGenerate.this.doc.println("---\n");
            ClientConfigGenerate.this.doc.println("<!-- WARNING: Do not edit this file. It is a generated file that is copied from Accumulo build (from core/target/generated-docs) -->");
            ClientConfigGenerate.this.doc.println("<!-- Generated by : " + this.getClass().getName() + " -->\n");
            ClientConfigGenerate.this.doc.println("Below are properties set in `accumulo-client.properties` that configure [Accumulo clients]({{ page.docs_baseurl }}/getting-started/clients#connecting). All properties have been part of the API since 2.0.0 (unless otherwise specified):\n");
            ClientConfigGenerate.this.doc.println("| Property | Default value | Since | Description |");
            ClientConfigGenerate.this.doc.println("|----------|---------------|-------|-------------|");
        }

        @Override
        void property(ClientProperty prop) {
            Objects.requireNonNull(prop);
            ClientConfigGenerate.this.doc.print("| <a name=\"" + prop.getKey().replace(".", "_") + "\" class=\"prop\"></a> " + prop.getKey() + " | ");
            String defaultValue = this.sanitize(prop.getDefaultValue()).trim();
            if (defaultValue.isEmpty()) {
                defaultValue = "*empty*";
            }
            ClientConfigGenerate.this.doc.println(defaultValue + " | " + prop.getSince() + " | " + this.sanitize(prop.getDescription() + " |"));
        }

        String sanitize(String str) {
            return str.replace("\n", "<br>");
        }
    }

    private abstract class Format {
        private Format() {
        }

        abstract void beginSection(String var1);

        abstract void pageHeader();

        abstract void property(ClientProperty var1);

        void generate() {
            this.pageHeader();
            this.generateSection("Instance", "instance.");
            this.generateSection("Authentication", "auth.", "auth.type", "auth.principal");
            this.generateSection("Batch Writer", "batch.writer.");
            this.generateSection("Batch Scanner", "batch.scanner.");
            this.generateSection("Scanner", "scanner.");
            this.generateSection("SSL", "ssl.");
            this.generateSection("SASL", "sasl.");
            this.generateSection("Tracing", "trace.");
            ClientConfigGenerate.this.doc.close();
        }

        void generateSection(String section, String prefix, String ... prefixProps) {
            this.beginSection(section);
            for (String prop : prefixProps) {
                ClientProperty cp = ClientConfigGenerate.this.sortedProps.get(prop);
                if (cp == null) continue;
                this.property(cp);
            }
            HashSet prefixSet = Sets.newHashSet((Object[])prefixProps);
            for (ClientProperty prop : ClientConfigGenerate.this.sortedProps.values()) {
                if (!prop.getKey().startsWith(prefix) || prefixSet.contains(prop.getKey())) continue;
                this.property(prop);
            }
        }

        void generateSection(String section, String prefix) {
            this.generateSection(section, prefix, "");
        }
    }
}

