/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.FileConverter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.clientImpl.ClientInfoImpl;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.hadoop.security.UserGroupInformation;

public class ShellOptionsJC {
    @Parameter(names={"-u", "--user"}, description="username")
    private String username = null;
    @Parameter(names={"-p", "--password"}, description="password (can be specified as '<password>', 'pass:<password>', 'file:<local file containing the password>', 'env:<variable containing the pass>', or stdin)", converter=ClientOpts.PasswordConverter.class)
    private String password;
    @DynamicParameter(names={"-l"}, description="command line properties in the format key=value. Reuse -l for each property")
    private Map<String, String> commandLineProperties = new TreeMap<String, String>();
    @Parameter(names={"--disable-tab-completion"}, description="disables tab completion (for less overhead when scripting)")
    private boolean tabCompletionDisabled;
    @Parameter(names={"--debug"}, description="enables client debugging; deprecated, configure debugging through your logging configuration file")
    private boolean debugEnabled;
    @Parameter(names={"-?", "--help"}, help=true, description="display this help")
    private boolean helpEnabled;
    @Parameter(names={"-e", "--execute-command"}, description="executes a command, and then exits")
    private String execCommand;
    @Parameter(names={"-f", "--execute-file"}, description="executes commands from a file at startup", converter=FileConverter.class)
    private File execFile;
    @Parameter(names={"-fv", "--execute-file-verbose"}, description="executes commands from a file at startup, with commands shown", converter=FileConverter.class)
    private File execFileVerbose;
    @Parameter(names={"-z", "--zooKeeperInstance"}, description="use a zookeeper instance with the given instance name and list of zoo hosts. Syntax: -z <zoo-instance-name> <zoo-hosts>. Where <zoo-hosts> is a comma separated list of zookeeper servers.", arity=2)
    private List<String> zooKeeperInstance = new ArrayList<String>();
    @Parameter(names={"--ssl"}, description="use ssl to connect to accumulo")
    private boolean useSsl = false;
    @Parameter(names={"--sasl"}, description="use SASL to connect to Accumulo (Kerberos)")
    private boolean useSasl = false;
    @Parameter(names={"--config-file"}, description="Read the given accumulo-client.properties file. If omitted, the following locations will be searched ~/.accumulo/accumulo-client.properties:$ACCUMULO_CONF_DIR/accumulo-client.properties:/etc/accumulo/accumulo-client.properties")
    private String clientConfigFile = null;
    @Parameter(names={"-zi", "--zooKeeperInstanceName"}, description="use a zookeeper instance with the given instance name. This parameter is used in conjunction with -zh.")
    private String zooKeeperInstanceName;
    @Parameter(names={"-zh", "--zooKeeperHosts"}, description="use a zookeeper instance with the given comma separated list of zookeeper servers. This parameter is used in conjunction with -zi.")
    private String zooKeeperHosts;
    @Parameter(names={"--auth-timeout"}, description="minutes the shell can be idle without re-entering a password", validateWith={PositiveInteger.class})
    private int authTimeout = 60;
    @Parameter(names={"--disable-auth-timeout"}, description="disables requiring the user to re-type a password after being idle")
    private boolean authTimeoutDisabled;
    @Parameter(hidden=true)
    private List<String> unrecognizedOptions;

    public String getUsername() throws Exception {
        if (this.username == null) {
            this.username = this.getClientProperties().getProperty(ClientProperty.AUTH_PRINCIPAL.getKey());
            if (this.username == null || this.username.isEmpty()) {
                if (ClientProperty.SASL_ENABLED.getBoolean(this.getClientProperties())) {
                    if (!UserGroupInformation.isSecurityEnabled()) {
                        throw new IllegalArgumentException("Kerberos security is not enabled. Run with --sasl or set 'sasl.enabled' in accumulo-client.properties");
                    }
                    UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                    this.username = ugi.getUserName();
                } else {
                    throw new IllegalArgumentException("Username is not set. Run with '-u myuser' or set 'auth.principal' in accumulo-client.properties");
                }
            }
        }
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isTabCompletionDisabled() {
        return this.tabCompletionDisabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isHelpEnabled() {
        return this.helpEnabled;
    }

    public String getExecCommand() {
        return this.execCommand;
    }

    public File getExecFile() {
        return this.execFile;
    }

    public File getExecFileVerbose() {
        return this.execFileVerbose;
    }

    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public boolean isAuthTimeoutDisabled() {
        if (this.useSasl) {
            return true;
        }
        return this.authTimeoutDisabled;
    }

    public List<String> getUnrecognizedOptions() {
        return this.unrecognizedOptions;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="user-provided paths intentional")
    public String getClientPropertiesFile() {
        if (this.clientConfigFile == null) {
            LinkedList<Object> searchPaths = new LinkedList<Object>();
            searchPaths.add(System.getProperty("user.home") + "/.accumulo/accumulo-client.properties");
            if (System.getenv("ACCUMULO_CONF_DIR") != null) {
                searchPaths.add(System.getenv("ACCUMULO_CONF_DIR") + "/accumulo-client.properties");
            }
            searchPaths.add("/etc/accumulo/accumulo-client.properties");
            for (String string : searchPaths) {
                File file = new File(string);
                if (!file.isFile() || !file.canRead()) continue;
                this.clientConfigFile = file.getAbsolutePath();
                System.out.println("Loading configuration from " + this.clientConfigFile);
                break;
            }
        }
        return this.clientConfigFile;
    }

    public Properties getClientProperties() {
        Properties props = new Properties();
        if (this.getClientPropertiesFile() != null) {
            props = ClientInfoImpl.toProperties((String)this.getClientPropertiesFile());
        }
        for (Map.Entry<String, String> entry : this.commandLineProperties.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        if (this.useSsl) {
            props.setProperty(ClientProperty.SSL_ENABLED.getKey(), "true");
        }
        if (this.useSasl) {
            props.setProperty(ClientProperty.SASL_ENABLED.getKey(), "true");
        }
        if (!this.zooKeeperInstance.isEmpty()) {
            String instanceName = this.zooKeeperInstance.get(0);
            String hosts = this.zooKeeperInstance.get(1);
            props.setProperty(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), hosts);
            props.setProperty(ClientProperty.INSTANCE_NAME.getKey(), instanceName);
        }
        if (this.zooKeeperHosts != null && !this.zooKeeperHosts.isEmpty()) {
            props.setProperty(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), this.zooKeeperHosts);
        }
        if (this.zooKeeperInstanceName != null && !this.zooKeeperInstanceName.isEmpty()) {
            props.setProperty(ClientProperty.INSTANCE_NAME.getKey(), this.zooKeeperInstanceName);
        }
        return props;
    }

    static class PositiveInteger
    implements IParameterValidator {
        PositiveInteger() {
        }

        public void validate(String name, String value) throws ParameterException {
            int n = -1;
            try {
                n = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n < 0) {
                throw new ParameterException("Parameter " + name + " should be a positive integer (was " + value + ")");
            }
        }
    }
}

