/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor;

import jakarta.inject.Singleton;
import jakarta.servlet.Servlet;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.compaction.thrift.TExternalCompaction;
import org.apache.accumulo.core.compaction.thrift.TExternalCompactionList;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.gc.thrift.GCMonitorService;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.manager.thrift.ManagerClientService;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletScanClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.Halt;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.monitor.EmbeddedWebServer;
import org.apache.accumulo.monitor.rest.compactions.external.ExternalCompactionInfo;
import org.apache.accumulo.monitor.util.logging.RecentLogs;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.HighlyAvailableService;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.util.TableInfoUtil;
import org.apache.thrift.TServiceClient;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor
extends AbstractServer
implements HighlyAvailableService {
    private static final Logger log = LoggerFactory.getLogger(Monitor.class);
    private static final int REFRESH_TIME = 5;
    private final long START_TIME;
    private final AtomicLong lastRecalc = new AtomicLong(0L);
    private double totalIngestRate = 0.0;
    private double totalQueryRate = 0.0;
    private double totalScanRate = 0.0;
    private long totalEntries = 0L;
    private int totalTabletCount = 0;
    private long totalHoldTime = 0L;
    private long totalLookups = 0L;
    private int totalTables = 0;
    private final AtomicBoolean monitorInitialized = new AtomicBoolean(false);
    private final List<Pair<Long, Double>> loadOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> ingestRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> ingestByteRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Integer>> minorCompactionsOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Integer>> majorCompactionsOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> lookupsOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Long>> queryRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Long>> scanRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> queryByteRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> indexCacheHitRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> dataCacheHitRateOverTime = Monitor.newMaxList();
    private EventCounter lookupRateTracker = new EventCounter();
    private EventCounter indexCacheHitTracker = new EventCounter();
    private EventCounter indexCacheRequestTracker = new EventCounter();
    private EventCounter dataCacheHitTracker = new EventCounter();
    private EventCounter dataCacheRequestTracker = new EventCounter();
    private final AtomicBoolean fetching = new AtomicBoolean(false);
    private ManagerMonitorInfo mmi;
    private Map<TableId, Map<ProblemType, Integer>> problemSummary = Collections.emptyMap();
    private Exception problemException;
    private GCStatus gcStatus;
    private Optional<HostAndPort> coordinatorHost = Optional.empty();
    private long coordinatorCheckNanos = 0L;
    private CompactionCoordinatorService.Client coordinatorClient;
    private final String coordinatorMissingMsg = "Error getting the compaction coordinator. Check that it is running. It is not started automatically with other cluster processes so must be started by running 'accumulo compaction-coordinator'.";
    private EmbeddedWebServer server;
    private int livePort = 0;
    private ServiceLock monitorLock;
    private final Map<HostAndPort, ScanStats> tserverScans = new HashMap<HostAndPort, ScanStats>();
    private final Map<HostAndPort, ScanStats> sserverScans = new HashMap<HostAndPort, ScanStats>();
    private final Map<HostAndPort, CompactionStats> allCompactions = new HashMap<HostAndPort, CompactionStats>();
    private final RecentLogs recentLogs = new RecentLogs();
    private final ExternalCompactionInfo ecInfo = new ExternalCompactionInfo();
    private final Map<String, TExternalCompaction> ecRunningMap = new ConcurrentHashMap<String, TExternalCompaction>();
    private long scansFetchedNanos = 0L;
    private long compactsFetchedNanos = 0L;
    private long ecInfoFetchedNanos = 0L;
    private final long fetchTimeNanos = TimeUnit.MINUTES.toNanos(1L);
    private final long ageOffEntriesMillis = TimeUnit.MINUTES.toMillis(15L);

    public static void main(String[] args) throws Exception {
        try (Monitor monitor = new Monitor(new ServerOpts(), args);){
            monitor.runServer();
        }
    }

    Monitor(ServerOpts opts, String[] args) {
        super("monitor", opts, args);
        this.START_TIME = System.currentTimeMillis();
    }

    private static <T> List<Pair<Long, T>> newMaxList() {
        return Collections.synchronizedList(new LinkedList<Pair<Long, T>>(){
            private static final long serialVersionUID = 1L;
            private final long maxDelta = TimeUnit.HOURS.toMillis(1L);

            @Override
            public boolean add(Pair<Long, T> obj) {
                boolean result = super.add(obj);
                if ((Long)obj.getFirst() - (Long)((Pair)this.get(0)).getFirst() > this.maxDelta) {
                    this.remove(0);
                }
                return result;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchData() {
        ServerContext context = this.getContext();
        double totalIngestRate = 0.0;
        double totalIngestByteRate = 0.0;
        double totalQueryRate = 0.0;
        double totalQueryByteRate = 0.0;
        double totalScanRate = 0.0;
        long totalEntries = 0L;
        int totalTabletCount = 0;
        long totalHoldTime = 0L;
        long totalLookups = 0L;
        boolean retry = true;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRecalc.get() < 5000L) {
            return;
        }
        if (!this.fetching.compareAndSet(false, true)) {
            return;
        }
        try {
            while (retry) {
                ManagerClientService.Client client = null;
                try {
                    client = ThriftClientTypes.MANAGER.getConnection((ClientContext)context);
                    if (client != null) {
                        this.mmi = client.getManagerStats(TraceUtil.traceInfo(), context.rpcCreds());
                        retry = false;
                    } else {
                        this.mmi = null;
                        log.error("Unable to get info from Manager");
                    }
                    this.gcStatus = this.fetchGcStatus();
                }
                catch (Exception e) {
                    this.mmi = null;
                    log.info("Error fetching stats: ", (Throwable)e);
                }
                finally {
                    if (client != null) {
                        ThriftUtil.close((TServiceClient)client, (ClientContext)context);
                    }
                }
                if (this.mmi != null) continue;
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            if (this.mmi != null) {
                int majorCompactions = 0;
                int minorCompactions = 0;
                this.lookupRateTracker.startingUpdates();
                this.indexCacheHitTracker.startingUpdates();
                this.indexCacheRequestTracker.startingUpdates();
                this.dataCacheHitTracker.startingUpdates();
                this.dataCacheRequestTracker.startingUpdates();
                for (Object server : this.mmi.tServerInfo) {
                    TableInfo summary = TableInfoUtil.summarizeTableStats((TabletServerStatus)server);
                    totalIngestRate += summary.ingestRate;
                    totalIngestByteRate += summary.ingestByteRate;
                    totalQueryRate += summary.queryRate;
                    totalScanRate += summary.scanRate;
                    totalQueryByteRate += summary.queryByteRate;
                    totalEntries += summary.recs;
                    totalHoldTime += ((TabletServerStatus)server).holdTime;
                    totalLookups += ((TabletServerStatus)server).lookups;
                    majorCompactions += summary.majors.running;
                    minorCompactions += summary.minors.running;
                    this.lookupRateTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).lookups);
                    this.indexCacheHitTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).indexCacheHits);
                    this.indexCacheRequestTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).indexCacheRequest);
                    this.dataCacheHitTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).dataCacheHits);
                    this.dataCacheRequestTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).dataCacheRequest);
                }
                this.lookupRateTracker.finishedUpdating();
                this.indexCacheHitTracker.finishedUpdating();
                this.indexCacheRequestTracker.finishedUpdating();
                this.dataCacheHitTracker.finishedUpdating();
                this.dataCacheRequestTracker.finishedUpdating();
                int totalTables = 0;
                for (TableInfo tInfo : this.mmi.tableMap.values()) {
                    totalTabletCount += tInfo.tablets;
                    ++totalTables;
                }
                this.totalIngestRate = totalIngestRate;
                this.totalTables = totalTables;
                totalIngestByteRate /= 1000000.0;
                this.totalQueryRate = totalQueryRate;
                this.totalScanRate = totalScanRate;
                totalQueryByteRate /= 1000000.0;
                this.totalEntries = totalEntries;
                this.totalTabletCount = totalTabletCount;
                this.totalHoldTime = totalHoldTime;
                this.totalLookups = totalLookups;
                this.ingestRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalIngestRate));
                this.ingestByteRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalIngestByteRate));
                double totalLoad = 0.0;
                for (TabletServerStatus status : this.mmi.tServerInfo) {
                    if (status == null) continue;
                    totalLoad += status.osLoad;
                }
                this.loadOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalLoad));
                this.minorCompactionsOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)minorCompactions));
                this.majorCompactionsOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)majorCompactions));
                this.lookupsOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)this.lookupRateTracker.calculateRate()));
                this.queryRateOverTime.add((Pair<Long, Long>)new Pair((Object)currentTime, (Object)((long)totalQueryRate)));
                this.queryByteRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalQueryByteRate));
                this.scanRateOverTime.add((Pair<Long, Long>)new Pair((Object)currentTime, (Object)((long)totalScanRate)));
                Monitor.calcCacheHitRate(this.indexCacheHitRateOverTime, currentTime, this.indexCacheHitTracker, this.indexCacheRequestTracker);
                Monitor.calcCacheHitRate(this.dataCacheHitRateOverTime, currentTime, this.dataCacheHitTracker, this.dataCacheRequestTracker);
            }
            try {
                this.problemSummary = ProblemReports.getInstance((ServerContext)context).summarize();
                this.problemException = null;
            }
            catch (Exception e) {
                log.info("Failed to obtain problem reports ", (Throwable)e);
                this.problemSummary = Collections.emptyMap();
                this.problemException = e;
            }
            if (System.nanoTime() - this.coordinatorCheckNanos > this.fetchTimeNanos) {
                Optional<HostAndPort> previousHost = this.coordinatorHost;
                this.coordinatorHost = ExternalCompactionUtil.findCompactionCoordinator((ClientContext)context);
                this.coordinatorCheckNanos = System.nanoTime();
                if (previousHost.isEmpty() && this.coordinatorHost.isPresent()) {
                    log.info("External Compaction Coordinator found at {}", (Object)this.coordinatorHost.get());
                }
            }
        }
        finally {
            if (this.coordinatorClient != null) {
                ThriftUtil.returnClient((TServiceClient)this.coordinatorClient, (ClientContext)context);
                this.coordinatorClient = null;
            }
            this.lastRecalc.set(currentTime);
            if (!this.fetching.compareAndSet(true, false)) {
                throw new AssertionError((Object)"Not supposed to happen; somebody broke this code");
            }
        }
    }

    private static void calcCacheHitRate(List<Pair<Long, Double>> hitRate, long currentTime, EventCounter cacheHits, EventCounter cacheReq) {
        long req = cacheReq.calculateCount();
        if (req > 0L) {
            hitRate.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)((double)cacheHits.calculateCount() / (double)cacheReq.calculateCount())));
        } else {
            hitRate.add((Pair<Long, Double>)new Pair((Object)currentTime, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GCStatus fetchGcStatus() {
        GCStatus result;
        block5: {
            ServerContext context = this.getContext();
            result = null;
            HostAndPort address = null;
            try {
                ZooReaderWriter zk = context.getZooReaderWriter();
                ServiceLock.ServiceLockPath path = ServiceLock.path((String)(context.getZooKeeperRoot() + "/gc/lock"));
                List locks = ServiceLock.validateAndSort((ServiceLock.ServiceLockPath)path, (List)zk.getChildren(path.toString()));
                if (locks == null || locks.isEmpty()) break block5;
                address = new ServerServices(new String(zk.getData(path + "/" + (String)locks.get(0)), StandardCharsets.UTF_8)).getAddress(ServerServices.Service.GC_CLIENT);
                GCMonitorService.Client client = (GCMonitorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.GC, (HostAndPort)address, (ClientContext)context);
                try {
                    result = client.getStatus(TraceUtil.traceInfo(), context.rpcCreds());
                }
                finally {
                    ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
                }
            }
            catch (Exception ex) {
                log.warn("Unable to contact the garbage collector at " + address, (Throwable)ex);
            }
        }
        return result;
    }

    public void run() {
        int[] ports;
        ServerContext context = this.getContext();
        for (int port : ports = this.getConfiguration().getPort(Property.MONITOR_PORT)) {
            try {
                log.debug("Trying monitor on port {}", (Object)port);
                this.server = new EmbeddedWebServer(this, port);
                this.server.addServlet(this.getDefaultServlet(), "/resources/*");
                this.server.addServlet(this.getRestServlet(), "/rest/*");
                this.server.addServlet(this.getViewServlet(), "/*");
                this.server.start();
                this.livePort = port;
                break;
            }
            catch (Exception ex) {
                log.error("Unable to start embedded web server", (Throwable)ex);
            }
        }
        if (!this.server.isRunning()) {
            throw new RuntimeException("Unable to start embedded web server on ports: " + Arrays.toString(ports));
        }
        log.debug("Monitor started on port {}", (Object)this.livePort);
        try {
            this.getMonitorLock();
        }
        catch (Exception e) {
            log.error("Failed to get Monitor ZooKeeper lock");
            throw new RuntimeException(e);
        }
        String advertiseHost = this.getHostname();
        if (advertiseHost.equals("0.0.0.0")) {
            try {
                advertiseHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.error("Unable to get hostname", (Throwable)e);
            }
        }
        log.debug("Using {} to advertise monitor location in ZooKeeper", (Object)advertiseHost);
        try {
            URL url = new URL(this.server.isSecure() ? "https" : "http", advertiseHost, this.server.getPort(), "/");
            String path = context.getZooKeeperRoot() + "/monitor/http_addr";
            ZooReaderWriter zoo = context.getZooReaderWriter();
            zoo.delete(path);
            zoo.putEphemeralData(path, url.toString().getBytes(StandardCharsets.UTF_8));
            log.info("Set monitor address in zookeeper to {}", (Object)url);
        }
        catch (Exception ex) {
            log.error("Unable to advertise monitor HTTP address in zookeeper", (Throwable)ex);
        }
        Threads.createThread((String)"Data fetcher", () -> {
            while (true) {
                try {
                    this.fetchData();
                }
                catch (Exception e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                }
                UtilWaitThread.sleepUninterruptibly((long)333L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }).start();
        this.monitorInitialized.set(true);
    }

    private ServletHolder getDefaultServlet() {
        return new ServletHolder((Servlet)new DefaultServlet(){
            private static final long serialVersionUID = 1L;

            public Resource getResource(String pathInContext) {
                return Resource.newClassPathResource((String)("/org/apache/accumulo/monitor" + pathInContext));
            }
        });
    }

    private ServletHolder getViewServlet() {
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"org.apache.accumulo.monitor.view"}).register((Object)new MonitorFactory(this)).register((Object)new LoggingFeature(java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName()))).register(FreemarkerMvcFeature.class).property("jersey.config.server.mvc.templateBasePath", (Object)"/org/apache/accumulo/monitor/templates");
        return new ServletHolder((Servlet)new ServletContainer(rc));
    }

    private ServletHolder getRestServlet() {
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"org.apache.accumulo.monitor.rest"}).register((Object)new MonitorFactory(this)).register((Object)new LoggingFeature(java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName()))).register(JacksonFeature.class);
        return new ServletHolder((Servlet)new ServletContainer(rc));
    }

    public synchronized Map<HostAndPort, ScanStats> getScans() {
        if (System.nanoTime() - this.scansFetchedNanos > this.fetchTimeNanos) {
            log.info("User initiated fetch of Active TabletServer Scans");
            this.fetchScans();
        }
        return Map.copyOf(this.tserverScans);
    }

    public synchronized Map<HostAndPort, ScanStats> getScanServerScans() {
        if (System.nanoTime() - this.scansFetchedNanos > this.fetchTimeNanos) {
            log.info("User initiated fetch of Active ScanServer Scans");
            this.fetchScans();
        }
        return Map.copyOf(this.sserverScans);
    }

    public synchronized Map<HostAndPort, CompactionStats> getCompactions() {
        if (System.nanoTime() - this.compactsFetchedNanos > this.fetchTimeNanos) {
            log.info("User initiated fetch of Active Compactions");
            this.fetchCompactions();
        }
        return Map.copyOf(this.allCompactions);
    }

    public synchronized ExternalCompactionInfo getCompactorsInfo() {
        if (this.coordinatorHost.isEmpty()) {
            throw new IllegalStateException("Tried fetching from compaction coordinator that's missing");
        }
        if (System.nanoTime() - this.ecInfoFetchedNanos > this.fetchTimeNanos) {
            log.info("User initiated fetch of External Compaction info");
            Map compactors = ExternalCompactionUtil.getCompactorAddrs((ClientContext)this.getContext());
            log.debug("Found compactors: " + compactors);
            this.ecInfo.setFetchedTimeMillis(System.currentTimeMillis());
            this.ecInfo.setCompactors(compactors);
            this.ecInfo.setCoordinatorHost(this.coordinatorHost);
            this.ecInfoFetchedNanos = System.nanoTime();
        }
        return this.ecInfo;
    }

    public synchronized Map<String, TExternalCompaction> fetchRunningInfo() {
        TExternalCompactionList running;
        if (this.coordinatorHost.isEmpty()) {
            throw new IllegalStateException("Error getting the compaction coordinator. Check that it is running. It is not started automatically with other cluster processes so must be started by running 'accumulo compaction-coordinator'.");
        }
        HostAndPort ccHost = this.coordinatorHost.get();
        log.info("User initiated fetch of running External Compactions from " + ccHost);
        CompactionCoordinatorService.Client client = this.getCoordinator(ccHost);
        try {
            running = client.getRunningCompactions(TraceUtil.traceInfo(), this.getContext().rpcCreds());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get running compactions from " + ccHost, e);
        }
        this.ecRunningMap.clear();
        if (running.getCompactions() != null) {
            this.ecRunningMap.putAll(running.getCompactions());
        }
        return this.ecRunningMap;
    }

    public Map<String, TExternalCompaction> getEcRunningMap() {
        return this.ecRunningMap;
    }

    private CompactionCoordinatorService.Client getCoordinator(HostAndPort address) {
        if (this.coordinatorClient == null) {
            try {
                this.coordinatorClient = (CompactionCoordinatorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.COORDINATOR, (HostAndPort)address, (ClientContext)this.getContext());
            }
            catch (Exception e) {
                log.error("Unable to get Compaction coordinator at {}", (Object)address);
                throw new IllegalStateException("Error getting the compaction coordinator. Check that it is running. It is not started automatically with other cluster processes so must be started by running 'accumulo compaction-coordinator'.", e);
            }
        }
        return this.coordinatorClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchScans() {
        ServerContext context = this.getContext();
        for (String server : context.instanceOperations().getTabletServers()) {
            HostAndPort parsedServer = HostAndPort.fromString((String)server);
            TabletScanClientService.Client tserver = null;
            try {
                tserver = (TabletScanClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SCAN, (HostAndPort)parsedServer, (ClientContext)context);
                List scans = tserver.getActiveScans(null, context.rpcCreds());
                this.tserverScans.put(parsedServer, new ScanStats(scans));
                this.scansFetchedNanos = System.nanoTime();
            }
            catch (Exception ex) {
                try {
                    log.error("Failed to get active scans from {}", (Object)server, (Object)ex);
                }
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(tserver, (ClientContext)context);
                    throw throwable;
                }
                ThriftUtil.returnClient((TServiceClient)tserver, (ClientContext)context);
                continue;
            }
            ThriftUtil.returnClient((TServiceClient)tserver, (ClientContext)context);
        }
        Iterator<Map.Entry<HostAndPort, ScanStats>> tserverIter = this.tserverScans.entrySet().iterator();
        long now = System.currentTimeMillis();
        while (tserverIter.hasNext()) {
            Map.Entry<HostAndPort, ScanStats> entry = tserverIter.next();
            if (now - ((ScanStats)entry.getValue()).fetched <= this.ageOffEntriesMillis) continue;
            tserverIter.remove();
        }
        for (String server : context.instanceOperations().getScanServers()) {
            HostAndPort parsedServer = HostAndPort.fromString((String)server);
            TabletScanClientService.Client sserver = null;
            try {
                sserver = (TabletScanClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SCAN, (HostAndPort)parsedServer, (ClientContext)context);
                List scans = sserver.getActiveScans(null, context.rpcCreds());
                this.sserverScans.put(parsedServer, new ScanStats(scans));
                this.scansFetchedNanos = System.nanoTime();
            }
            catch (Exception ex) {
                try {
                    log.error("Failed to get active scans from {}", (Object)server, (Object)ex);
                }
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(sserver, (ClientContext)context);
                    throw throwable;
                }
                ThriftUtil.returnClient((TServiceClient)sserver, (ClientContext)context);
                continue;
            }
            ThriftUtil.returnClient((TServiceClient)sserver, (ClientContext)context);
        }
        Iterator<Map.Entry<HostAndPort, ScanStats>> sserverIter = this.sserverScans.entrySet().iterator();
        now = System.currentTimeMillis();
        while (sserverIter.hasNext()) {
            Map.Entry<HostAndPort, ScanStats> entry = sserverIter.next();
            if (now - entry.getValue().fetched <= this.ageOffEntriesMillis) continue;
            sserverIter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchCompactions() {
        ServerContext context = this.getContext();
        for (String server : context.instanceOperations().getTabletServers()) {
            HostAndPort parsedServer = HostAndPort.fromString((String)server);
            TabletClientService.Client tserver = null;
            try {
                tserver = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)parsedServer, (ClientContext)context);
                List compacts = tserver.getActiveCompactions(null, context.rpcCreds());
                this.allCompactions.put(parsedServer, new CompactionStats(compacts));
                this.compactsFetchedNanos = System.nanoTime();
            }
            catch (Exception ex) {
                try {
                    log.debug("Failed to get active compactions from {}", (Object)server, (Object)ex);
                }
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(tserver, (ClientContext)context);
                    throw throwable;
                }
                ThriftUtil.returnClient((TServiceClient)tserver, (ClientContext)context);
                continue;
            }
            ThriftUtil.returnClient((TServiceClient)tserver, (ClientContext)context);
        }
        Iterator<Map.Entry<HostAndPort, CompactionStats>> entryIter = this.allCompactions.entrySet().iterator();
        long now = System.currentTimeMillis();
        while (entryIter.hasNext()) {
            Map.Entry<HostAndPort, CompactionStats> entry = entryIter.next();
            if (now - entry.getValue().fetched <= this.ageOffEntriesMillis) continue;
            entryIter.remove();
        }
    }

    private void getMonitorLock() throws KeeperException, InterruptedException {
        ServerContext context = this.getContext();
        String zRoot = context.getZooKeeperRoot();
        String monitorPath = zRoot + "/monitor";
        ServiceLock.ServiceLockPath monitorLockPath = ServiceLock.path((String)(zRoot + "/monitor/lock"));
        ZooReaderWriter zoo = context.getZooReaderWriter();
        if (zoo.exists(monitorPath)) {
            byte[] data = zoo.getData(monitorPath);
            if (data.length != 0) {
                zoo.recursiveDelete(monitorPath, ZooUtil.NodeMissingPolicy.SKIP);
                zoo.putPersistentData(monitorPath, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
                zoo.putPersistentData(monitorLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            } else if (!zoo.exists(monitorLockPath.toString())) {
                zoo.putPersistentData(monitorLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            }
        } else {
            zoo.putPersistentData(zRoot + "/monitor", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            if (!zoo.exists(monitorLockPath.toString())) {
                zoo.putPersistentData(monitorLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            }
        }
        UUID zooLockUUID = UUID.randomUUID();
        while (true) {
            MoniterLockWatcher monitorLockWatcher = new MoniterLockWatcher();
            this.monitorLock = new ServiceLock(zoo.getZooKeeper(), monitorLockPath, zooLockUUID);
            this.monitorLock.lock((ServiceLock.AccumuloLockWatcher)monitorLockWatcher, new byte[0]);
            monitorLockWatcher.waitForChange();
            if (monitorLockWatcher.acquiredLock) break;
            if (!monitorLockWatcher.failedToAcquireLock) {
                throw new IllegalStateException("monitor lock in unknown state");
            }
            this.monitorLock.tryToCancelAsyncLockOrUnlock();
            UtilWaitThread.sleepUninterruptibly((long)context.getConfiguration().getTimeInMillis(Property.MONITOR_LOCK_CHECK_INTERVAL), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        log.info("Got Monitor lock.");
    }

    public ManagerMonitorInfo getMmi() {
        return this.mmi;
    }

    public int getTotalTables() {
        return this.totalTables;
    }

    public int getTotalTabletCount() {
        return this.totalTabletCount;
    }

    public long getTotalEntries() {
        return this.totalEntries;
    }

    public double getTotalIngestRate() {
        return this.totalIngestRate;
    }

    public double getTotalQueryRate() {
        return this.totalQueryRate;
    }

    public double getTotalScanRate() {
        return this.totalScanRate;
    }

    public long getTotalHoldTime() {
        return this.totalHoldTime;
    }

    public Exception getProblemException() {
        return this.problemException;
    }

    public Map<TableId, Map<ProblemType, Integer>> getProblemSummary() {
        return this.problemSummary;
    }

    public GCStatus getGcStatus() {
        return this.gcStatus;
    }

    public long getTotalLookups() {
        return this.totalLookups;
    }

    public long getStartTime() {
        return this.START_TIME;
    }

    public List<Pair<Long, Double>> getLoadOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.loadOverTime);
    }

    public List<Pair<Long, Double>> getIngestRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.ingestRateOverTime);
    }

    public List<Pair<Long, Double>> getIngestByteRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.ingestByteRateOverTime);
    }

    public List<Pair<Long, Integer>> getMinorCompactionsOverTime() {
        return new ArrayList<Pair<Long, Integer>>(this.minorCompactionsOverTime);
    }

    public List<Pair<Long, Integer>> getMajorCompactionsOverTime() {
        return new ArrayList<Pair<Long, Integer>>(this.majorCompactionsOverTime);
    }

    public List<Pair<Long, Double>> getLookupsOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.lookupsOverTime);
    }

    public double getLookupRate() {
        return this.lookupRateTracker.calculateRate();
    }

    public List<Pair<Long, Long>> getQueryRateOverTime() {
        return new ArrayList<Pair<Long, Long>>(this.queryRateOverTime);
    }

    public List<Pair<Long, Long>> getScanRateOverTime() {
        return new ArrayList<Pair<Long, Long>>(this.scanRateOverTime);
    }

    public List<Pair<Long, Double>> getQueryByteRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.queryByteRateOverTime);
    }

    public List<Pair<Long, Double>> getIndexCacheHitRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.indexCacheHitRateOverTime);
    }

    public List<Pair<Long, Double>> getDataCacheHitRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.dataCacheHitRateOverTime);
    }

    public boolean isActiveService() {
        return this.monitorInitialized.get();
    }

    public RecentLogs recentLogs() {
        return this.recentLogs;
    }

    public Optional<HostAndPort> getCoordinatorHost() {
        return this.coordinatorHost;
    }

    public int getLivePort() {
        return this.livePort;
    }

    private static class MoniterLockWatcher
    implements ServiceLock.AccumuloLockWatcher {
        boolean acquiredLock = false;
        boolean failedToAcquireLock = false;

        private MoniterLockWatcher() {
        }

        public void lostLock(ServiceLock.LockLossReason reason) {
            Halt.halt((String)("Monitor lock in zookeeper lost (reason = " + reason + "), exiting!"), (int)-1);
        }

        public void unableToMonitorLockNode(Exception e) {
            Halt.halt((int)-1, () -> log.error("No longer able to monitor Monitor lock node", (Throwable)e));
        }

        public synchronized void acquiredLock() {
            if (this.acquiredLock || this.failedToAcquireLock) {
                Halt.halt((String)("Zoolock in unexpected state AL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
            }
            this.acquiredLock = true;
            this.notifyAll();
        }

        public synchronized void failedToAcquireLock(Exception e) {
            log.warn("Failed to get monitor lock " + e);
            if (this.acquiredLock) {
                Halt.halt((String)("Zoolock in unexpected state FAL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
            }
            this.failedToAcquireLock = true;
            this.notifyAll();
        }

        public synchronized void waitForChange() {
            while (!this.acquiredLock && !this.failedToAcquireLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class CompactionStats {
        public final long count;
        public final Long oldest;
        public final long fetched;

        CompactionStats(List<ActiveCompaction> active) {
            this.count = active.size();
            long oldest = -1L;
            for (ActiveCompaction a : active) {
                oldest = Math.max(oldest, a.age);
            }
            this.oldest = oldest < 0L ? null : Long.valueOf(oldest);
            this.fetched = System.currentTimeMillis();
        }
    }

    public static class ScanStats {
        public final long scanCount;
        public final Long oldestScan;
        public final long fetched;

        ScanStats(List<ActiveScan> active) {
            this.scanCount = active.size();
            long oldest = -1L;
            for (ActiveScan scan : active) {
                oldest = Math.max(oldest, scan.age);
            }
            this.oldestScan = oldest < 0L ? null : Long.valueOf(oldest);
            this.fetched = System.currentTimeMillis();
        }
    }

    public static class MonitorFactory
    extends AbstractBinder
    implements Factory<Monitor> {
        private final Monitor monitor;

        public MonitorFactory(Monitor monitor) {
            this.monitor = monitor;
        }

        public Monitor provide() {
            return this.monitor;
        }

        public void dispose(Monitor instance) {
        }

        protected void configure() {
            this.bindFactory(this).to(Monitor.class).in(Singleton.class);
        }
    }

    private static class EventCounter {
        Map<String, Pair<Long, Long>> prevSamples = new HashMap<String, Pair<Long, Long>>();
        Map<String, Pair<Long, Long>> samples = new HashMap<String, Pair<Long, Long>>();
        Set<String> serversUpdated = new HashSet<String>();

        private EventCounter() {
        }

        void startingUpdates() {
            this.serversUpdated.clear();
        }

        void updateTabletServer(String name, long sampleTime, long numEvents) {
            Pair newSample = new Pair((Object)sampleTime, (Object)numEvents);
            Pair<Long, Long> lastSample = this.samples.get(name);
            if (lastSample == null || !lastSample.equals((Object)newSample)) {
                this.samples.put(name, (Pair<Long, Long>)newSample);
                if (lastSample != null) {
                    this.prevSamples.put(name, lastSample);
                }
            }
            this.serversUpdated.add(name);
        }

        void finishedUpdating() {
            this.samples.keySet().retainAll(this.serversUpdated);
            this.prevSamples.keySet().retainAll(this.serversUpdated);
        }

        double calculateRate() {
            double totalRate = 0.0;
            for (Map.Entry<String, Pair<Long, Long>> entry : this.prevSamples.entrySet()) {
                Pair<Long, Long> prevSample = entry.getValue();
                Pair<Long, Long> sample = this.samples.get(entry.getKey());
                totalRate += (double)((Long)sample.getSecond() - (Long)prevSample.getSecond()) / ((double)((Long)sample.getFirst() - (Long)prevSample.getFirst()) / 1000.0);
            }
            return totalRate;
        }

        long calculateCount() {
            long count = 0L;
            for (Map.Entry<String, Pair<Long, Long>> entry : this.prevSamples.entrySet()) {
                Pair<Long, Long> prevSample = entry.getValue();
                Pair<Long, Long> sample = this.samples.get(entry.getKey());
                count += (Long)sample.getSecond() - (Long)prevSample.getSecond();
            }
            return count;
        }
    }
}

