/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.singletons.SingletonService;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.zookeeper.Watcher;

public class ZooCacheFactory {
    private static Map<String, ZooCache> instances = new HashMap<String, ZooCache>();
    private static boolean enabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEnabled() {
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            return enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enable() {
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            enabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disable() {
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            try {
                instances.values().forEach(zc -> zc.close());
            }
            finally {
                instances.clear();
                enabled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZooCache getZooCache(String zooKeepers, int sessionTimeout) {
        String key = zooKeepers + ":" + sessionTimeout;
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            if (!ZooCacheFactory.isEnabled()) {
                throw new IllegalStateException("\"The Accumulo singleton for zookeeper caching is disabled. This is likely caused by all AccumuloClients being closed");
            }
            ZooCache zc = instances.get(key);
            if (zc == null) {
                zc = new ZooCache(zooKeepers, sessionTimeout);
                instances.put(key, zc);
            }
            return zc;
        }
    }

    public ZooCache getZooCache(String zooKeepers, int sessionTimeout, Watcher watcher) {
        if (watcher == null) {
            return this.getZooCache(zooKeepers, sessionTimeout);
        }
        return new ZooCache(zooKeepers, sessionTimeout, watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            instances.clear();
        }
    }

    static {
        SingletonManager.register(new SingletonService(){

            @Override
            public synchronized boolean isEnabled() {
                return ZooCacheFactory.isEnabled();
            }

            @Override
            public synchronized void enable() {
                ZooCacheFactory.enable();
            }

            @Override
            public synchronized void disable() {
                ZooCacheFactory.disable();
            }
        });
    }
}

