/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.function.Predicate;

public abstract class Validator<T>
implements Predicate<T> {
    public final T validate(T argument) {
        if (!this.test(argument)) {
            throw new IllegalArgumentException(this.invalidMessage(argument));
        }
        return argument;
    }

    public String invalidMessage(T argument) {
        return String.format("Invalid argument %s", argument);
    }

    @Override
    public final Validator<T> and(final Validator<T> other) {
        if (other == null) {
            return this;
        }
        final Validator mine = this;
        return new Validator<T>(){

            @Override
            public boolean test(T argument) {
                return mine.test(argument) && other.test(argument);
            }

            @Override
            public String invalidMessage(T argument) {
                return (mine.test(argument) ? other : mine).invalidMessage(argument);
            }
        };
    }

    @Override
    public final Validator<T> or(final Validator<T> other) {
        if (other == null) {
            return this;
        }
        final Validator mine = this;
        return new Validator<T>(){

            @Override
            public boolean test(T argument) {
                return mine.test(argument) || other.test(argument);
            }

            @Override
            public String invalidMessage(T argument) {
                return mine.invalidMessage(argument);
            }
        };
    }

    public final Validator<T> not() {
        final Validator mine = this;
        return new Validator<T>(){

            @Override
            public boolean test(T argument) {
                return !mine.test(argument);
            }

            @Override
            public String invalidMessage(T argument) {
                return "Validation should have failed with: " + mine.invalidMessage(argument);
            }
        };
    }
}

