/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.LinkingIterator;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.hadoop.io.Text;

public class TabletMetadata {
    private TableId tableId;
    private Text prevEndRow;
    private boolean sawPrevEndRow = false;
    private Text endRow;
    private Location location;
    private Map<String, DataFileValue> files;
    private List<String> scans;
    private Set<String> loadedFiles;
    private EnumSet<FetchedColumns> fetchedCols;
    private KeyExtent extent;
    private Location last;
    private String dir;
    private String time;
    private String cloned;
    private SortedMap<Key, Value> keyValues;
    private OptionalLong flush = OptionalLong.empty();
    private List<LogEntry> logs;
    private OptionalLong compact = OptionalLong.empty();

    public TableId getTableId() {
        return this.tableId;
    }

    public KeyExtent getExtent() {
        if (this.extent == null) {
            this.extent = new KeyExtent(this.getTableId(), this.getEndRow(), this.getPrevEndRow());
        }
        return this.extent;
    }

    private void ensureFetched(FetchedColumns col) {
        Preconditions.checkState((boolean)this.fetchedCols.contains((Object)col), (String)"%s was not fetched", (Object)((Object)col));
    }

    public Text getPrevEndRow() {
        this.ensureFetched(FetchedColumns.PREV_ROW);
        if (!this.sawPrevEndRow) {
            throw new IllegalStateException("No prev endrow seen.  tableId: " + this.tableId + " endrow: " + this.endRow);
        }
        return this.prevEndRow;
    }

    public boolean sawPrevEndRow() {
        this.ensureFetched(FetchedColumns.PREV_ROW);
        return this.sawPrevEndRow;
    }

    public Text getEndRow() {
        return this.endRow;
    }

    public Location getLocation() {
        this.ensureFetched(FetchedColumns.LOCATION);
        return this.location;
    }

    public boolean hasCurrent() {
        this.ensureFetched(FetchedColumns.LOCATION);
        return this.location != null && this.location.getType() == LocationType.CURRENT;
    }

    public Set<String> getLoaded() {
        this.ensureFetched(FetchedColumns.LOADED);
        return this.loadedFiles;
    }

    public Location getLast() {
        this.ensureFetched(FetchedColumns.LAST);
        return this.last;
    }

    public Collection<String> getFiles() {
        this.ensureFetched(FetchedColumns.FILES);
        return this.files.keySet();
    }

    public Map<String, DataFileValue> getFilesMap() {
        this.ensureFetched(FetchedColumns.FILES);
        return this.files;
    }

    public Collection<LogEntry> getLogs() {
        this.ensureFetched(FetchedColumns.LOGS);
        return this.logs;
    }

    public List<String> getScans() {
        this.ensureFetched(FetchedColumns.SCANS);
        return this.scans;
    }

    public String getDir() {
        this.ensureFetched(FetchedColumns.DIR);
        return this.dir;
    }

    public String getTime() {
        this.ensureFetched(FetchedColumns.TIME);
        return this.time;
    }

    public String getCloned() {
        this.ensureFetched(FetchedColumns.CLONED);
        return this.cloned;
    }

    public OptionalLong getFlushId() {
        this.ensureFetched(FetchedColumns.FLUSH_ID);
        return this.flush;
    }

    public OptionalLong getCompactId() {
        this.ensureFetched(FetchedColumns.COMPACT_ID);
        return this.compact;
    }

    public SortedMap<Key, Value> getKeyValues() {
        Preconditions.checkState((this.keyValues != null ? 1 : 0) != 0, (Object)"Requested key values when it was not saved");
        return this.keyValues;
    }

    static TabletMetadata convertRow(Iterator<Map.Entry<Key, Value>> rowIter, EnumSet<FetchedColumns> fetchedColumns, boolean buildKeyValueMap) {
        Objects.requireNonNull(rowIter);
        TabletMetadata te = new TabletMetadata();
        ImmutableSortedMap.Builder kvBuilder = null;
        if (buildKeyValueMap) {
            kvBuilder = ImmutableSortedMap.naturalOrder();
        }
        ImmutableMap.Builder filesBuilder = ImmutableMap.builder();
        ImmutableList.Builder scansBuilder = ImmutableList.builder();
        ImmutableList.Builder logsBuilder = ImmutableList.builder();
        ImmutableSet.Builder loadedFilesBuilder = ImmutableSet.builder();
        ByteSequence row = null;
        block36: while (rowIter.hasNext()) {
            Map.Entry<Key, Value> kv = rowIter.next();
            Key key = kv.getKey();
            String val = kv.getValue().toString();
            String fam = key.getColumnFamilyData().toString();
            String qual = key.getColumnQualifierData().toString();
            if (buildKeyValueMap) {
                kvBuilder.put((Object)key, (Object)kv.getValue());
            }
            if (row == null) {
                row = key.getRowData();
                KeyExtent ke = new KeyExtent(key.getRow(), (Text)null);
                te.endRow = ke.getEndRow();
                te.tableId = ke.getTableId();
            } else if (!row.equals(key.getRowData())) {
                throw new IllegalArgumentException("Input contains more than one row : " + row + " " + key.getRowData());
            }
            switch (fam.toString()) {
                case "~tab": {
                    if (!"~pr".equals(qual)) continue block36;
                    te.prevEndRow = KeyExtent.decodePrevEndRow(kv.getValue());
                    te.sawPrevEndRow = true;
                    continue block36;
                }
                case "srv": {
                    switch (qual) {
                        case "dir": {
                            te.dir = val;
                            break;
                        }
                        case "time": {
                            te.time = val;
                            break;
                        }
                        case "flush": {
                            te.flush = OptionalLong.of(Long.parseLong(val));
                            break;
                        }
                        case "compact": {
                            te.compact = OptionalLong.of(Long.parseLong(val));
                        }
                    }
                    continue block36;
                }
                case "file": {
                    filesBuilder.put((Object)qual, (Object)new DataFileValue(val));
                    continue block36;
                }
                case "loaded": {
                    loadedFilesBuilder.add((Object)qual);
                    continue block36;
                }
                case "loc": {
                    te.setLocationOnce(val, qual, LocationType.CURRENT);
                    continue block36;
                }
                case "future": {
                    te.setLocationOnce(val, qual, LocationType.FUTURE);
                    continue block36;
                }
                case "last": {
                    te.last = new Location(val, qual, LocationType.LAST);
                    continue block36;
                }
                case "scan": {
                    scansBuilder.add((Object)qual);
                    continue block36;
                }
                case "!cloned": {
                    te.cloned = val;
                    continue block36;
                }
                case "log": {
                    logsBuilder.add((Object)LogEntry.fromKeyValue(key, val));
                    continue block36;
                }
            }
            throw new IllegalStateException("Unexpected family " + fam);
        }
        te.files = filesBuilder.build();
        te.loadedFiles = loadedFilesBuilder.build();
        te.fetchedCols = fetchedColumns;
        te.scans = scansBuilder.build();
        te.logs = logsBuilder.build();
        if (buildKeyValueMap) {
            te.keyValues = kvBuilder.build();
        }
        return te;
    }

    private void setLocationOnce(String val, String qual, LocationType lt) {
        if (this.location != null) {
            throw new IllegalStateException("Attempted to set second location for tableId: " + this.tableId + " endrow: " + this.endRow + " -- " + this.location + " " + qual + " " + val);
        }
        this.location = new Location(val, qual, lt);
    }

    static Iterable<TabletMetadata> convert(Scanner input, EnumSet<FetchedColumns> fetchedColumns, boolean checkConsistency, boolean buildKeyValueMap) {
        Range range = input.getRange();
        Function<Range, Iterator> iterFactory = r -> {
            Scanner scanner = input;
            synchronized (scanner) {
                input.setRange((Range)r);
                RowIterator rowIter = new RowIterator(input);
                return Iterators.transform((Iterator)rowIter, ri -> TabletMetadata.convertRow(ri, fetchedColumns, buildKeyValueMap));
            }
        };
        if (checkConsistency) {
            return () -> new LinkingIterator(iterFactory, range);
        }
        return () -> (Iterator)iterFactory.apply(range);
    }

    @VisibleForTesting
    static TabletMetadata create(String id, String prevEndRow, String endRow) {
        TabletMetadata te = new TabletMetadata();
        te.tableId = TableId.of(id);
        te.sawPrevEndRow = true;
        te.prevEndRow = prevEndRow == null ? null : new Text(prevEndRow);
        te.endRow = endRow == null ? null : new Text(endRow);
        te.fetchedCols = EnumSet.of(FetchedColumns.PREV_ROW);
        return te;
    }

    public static class Location {
        private final String server;
        private final String session;
        private final LocationType lt;

        Location(String server, String session, LocationType lt) {
            this.server = server;
            this.session = session;
            this.lt = lt;
        }

        public HostAndPort getHostAndPort() {
            return HostAndPort.fromString(this.server);
        }

        public String getSession() {
            return this.session;
        }

        public LocationType getType() {
            return this.lt;
        }

        public String toString() {
            return this.server + ":" + this.session + ":" + (Object)((Object)this.lt);
        }

        public String getId() {
            return this.server + "[" + this.session + "]";
        }
    }

    public static enum FetchedColumns {
        LOCATION,
        PREV_ROW,
        FILES,
        LAST,
        LOADED,
        SCANS,
        DIR,
        TIME,
        CLONED,
        FLUSH_ID,
        LOGS,
        COMPACT_ID;

    }

    public static enum LocationType {
        CURRENT,
        FUTURE,
        LAST;

    }
}

