/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.master.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.master.thrift.BulkImportStatus;
import org.apache.accumulo.core.master.thrift.DeadServer;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class MasterMonitorInfo
implements TBase<MasterMonitorInfo, _Fields>,
Serializable,
Cloneable,
Comparable<MasterMonitorInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("MasterMonitorInfo");
    private static final TField TABLE_MAP_FIELD_DESC = new TField("tableMap", 13, 1);
    private static final TField T_SERVER_INFO_FIELD_DESC = new TField("tServerInfo", 15, 2);
    private static final TField BAD_TSERVERS_FIELD_DESC = new TField("badTServers", 13, 3);
    private static final TField STATE_FIELD_DESC = new TField("state", 8, 6);
    private static final TField GOAL_STATE_FIELD_DESC = new TField("goalState", 8, 8);
    private static final TField UNASSIGNED_TABLETS_FIELD_DESC = new TField("unassignedTablets", 8, 7);
    private static final TField SERVERS_SHUTTING_DOWN_FIELD_DESC = new TField("serversShuttingDown", 14, 9);
    private static final TField DEAD_TABLET_SERVERS_FIELD_DESC = new TField("deadTabletServers", 15, 10);
    private static final TField BULK_IMPORTS_FIELD_DESC = new TField("bulkImports", 15, 11);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new MasterMonitorInfoStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new MasterMonitorInfoTupleSchemeFactory();
    @Nullable
    public Map<String, TableInfo> tableMap;
    @Nullable
    public List<TabletServerStatus> tServerInfo;
    @Nullable
    public Map<String, Byte> badTServers;
    @Nullable
    public MasterState state;
    @Nullable
    public MasterGoalState goalState;
    public int unassignedTablets;
    @Nullable
    public Set<String> serversShuttingDown;
    @Nullable
    public List<DeadServer> deadTabletServers;
    @Nullable
    public List<BulkImportStatus> bulkImports;
    private static final int __UNASSIGNEDTABLETS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public MasterMonitorInfo() {
    }

    public MasterMonitorInfo(Map<String, TableInfo> tableMap, List<TabletServerStatus> tServerInfo, Map<String, Byte> badTServers, MasterState state, MasterGoalState goalState, int unassignedTablets, Set<String> serversShuttingDown, List<DeadServer> deadTabletServers, List<BulkImportStatus> bulkImports) {
        this();
        this.tableMap = tableMap;
        this.tServerInfo = tServerInfo;
        this.badTServers = badTServers;
        this.state = state;
        this.goalState = goalState;
        this.unassignedTablets = unassignedTablets;
        this.setUnassignedTabletsIsSet(true);
        this.serversShuttingDown = serversShuttingDown;
        this.deadTabletServers = deadTabletServers;
        this.bulkImports = bulkImports;
    }

    public MasterMonitorInfo(MasterMonitorInfo other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetTableMap()) {
            HashMap<String, TableInfo> __this__tableMap = new HashMap<String, TableInfo>(other.tableMap.size());
            for (Map.Entry entry : other.tableMap.entrySet()) {
                String other_element_key = (String)entry.getKey();
                TableInfo other_element_value = (TableInfo)entry.getValue();
                String __this__tableMap_copy_key = other_element_key;
                TableInfo __this__tableMap_copy_value = new TableInfo(other_element_value);
                __this__tableMap.put(__this__tableMap_copy_key, __this__tableMap_copy_value);
            }
            this.tableMap = __this__tableMap;
        }
        if (other.isSetTServerInfo()) {
            ArrayList<TabletServerStatus> __this__tServerInfo = new ArrayList<TabletServerStatus>(other.tServerInfo.size());
            for (TabletServerStatus tabletServerStatus : other.tServerInfo) {
                __this__tServerInfo.add(new TabletServerStatus(tabletServerStatus));
            }
            this.tServerInfo = __this__tServerInfo;
        }
        if (other.isSetBadTServers()) {
            HashMap<String, Byte> __this__badTServers = new HashMap<String, Byte>(other.badTServers);
            this.badTServers = __this__badTServers;
        }
        if (other.isSetState()) {
            this.state = other.state;
        }
        if (other.isSetGoalState()) {
            this.goalState = other.goalState;
        }
        this.unassignedTablets = other.unassignedTablets;
        if (other.isSetServersShuttingDown()) {
            HashSet<String> __this__serversShuttingDown = new HashSet<String>(other.serversShuttingDown);
            this.serversShuttingDown = __this__serversShuttingDown;
        }
        if (other.isSetDeadTabletServers()) {
            ArrayList<DeadServer> __this__deadTabletServers = new ArrayList<DeadServer>(other.deadTabletServers.size());
            for (DeadServer deadServer : other.deadTabletServers) {
                __this__deadTabletServers.add(new DeadServer(deadServer));
            }
            this.deadTabletServers = __this__deadTabletServers;
        }
        if (other.isSetBulkImports()) {
            ArrayList<BulkImportStatus> __this__bulkImports = new ArrayList<BulkImportStatus>(other.bulkImports.size());
            for (BulkImportStatus bulkImportStatus : other.bulkImports) {
                __this__bulkImports.add(new BulkImportStatus(bulkImportStatus));
            }
            this.bulkImports = __this__bulkImports;
        }
    }

    public MasterMonitorInfo deepCopy() {
        return new MasterMonitorInfo(this);
    }

    public void clear() {
        this.tableMap = null;
        this.tServerInfo = null;
        this.badTServers = null;
        this.state = null;
        this.goalState = null;
        this.setUnassignedTabletsIsSet(false);
        this.unassignedTablets = 0;
        this.serversShuttingDown = null;
        this.deadTabletServers = null;
        this.bulkImports = null;
    }

    public int getTableMapSize() {
        return this.tableMap == null ? 0 : this.tableMap.size();
    }

    public void putToTableMap(String key, TableInfo val) {
        if (this.tableMap == null) {
            this.tableMap = new HashMap<String, TableInfo>();
        }
        this.tableMap.put(key, val);
    }

    @Nullable
    public Map<String, TableInfo> getTableMap() {
        return this.tableMap;
    }

    public MasterMonitorInfo setTableMap(@Nullable Map<String, TableInfo> tableMap) {
        this.tableMap = tableMap;
        return this;
    }

    public void unsetTableMap() {
        this.tableMap = null;
    }

    public boolean isSetTableMap() {
        return this.tableMap != null;
    }

    public void setTableMapIsSet(boolean value) {
        if (!value) {
            this.tableMap = null;
        }
    }

    public int getTServerInfoSize() {
        return this.tServerInfo == null ? 0 : this.tServerInfo.size();
    }

    @Nullable
    public Iterator<TabletServerStatus> getTServerInfoIterator() {
        return this.tServerInfo == null ? null : this.tServerInfo.iterator();
    }

    public void addToTServerInfo(TabletServerStatus elem) {
        if (this.tServerInfo == null) {
            this.tServerInfo = new ArrayList<TabletServerStatus>();
        }
        this.tServerInfo.add(elem);
    }

    @Nullable
    public List<TabletServerStatus> getTServerInfo() {
        return this.tServerInfo;
    }

    public MasterMonitorInfo setTServerInfo(@Nullable List<TabletServerStatus> tServerInfo) {
        this.tServerInfo = tServerInfo;
        return this;
    }

    public void unsetTServerInfo() {
        this.tServerInfo = null;
    }

    public boolean isSetTServerInfo() {
        return this.tServerInfo != null;
    }

    public void setTServerInfoIsSet(boolean value) {
        if (!value) {
            this.tServerInfo = null;
        }
    }

    public int getBadTServersSize() {
        return this.badTServers == null ? 0 : this.badTServers.size();
    }

    public void putToBadTServers(String key, byte val) {
        if (this.badTServers == null) {
            this.badTServers = new HashMap<String, Byte>();
        }
        this.badTServers.put(key, val);
    }

    @Nullable
    public Map<String, Byte> getBadTServers() {
        return this.badTServers;
    }

    public MasterMonitorInfo setBadTServers(@Nullable Map<String, Byte> badTServers) {
        this.badTServers = badTServers;
        return this;
    }

    public void unsetBadTServers() {
        this.badTServers = null;
    }

    public boolean isSetBadTServers() {
        return this.badTServers != null;
    }

    public void setBadTServersIsSet(boolean value) {
        if (!value) {
            this.badTServers = null;
        }
    }

    @Nullable
    public MasterState getState() {
        return this.state;
    }

    public MasterMonitorInfo setState(@Nullable MasterState state) {
        this.state = state;
        return this;
    }

    public void unsetState() {
        this.state = null;
    }

    public boolean isSetState() {
        return this.state != null;
    }

    public void setStateIsSet(boolean value) {
        if (!value) {
            this.state = null;
        }
    }

    @Nullable
    public MasterGoalState getGoalState() {
        return this.goalState;
    }

    public MasterMonitorInfo setGoalState(@Nullable MasterGoalState goalState) {
        this.goalState = goalState;
        return this;
    }

    public void unsetGoalState() {
        this.goalState = null;
    }

    public boolean isSetGoalState() {
        return this.goalState != null;
    }

    public void setGoalStateIsSet(boolean value) {
        if (!value) {
            this.goalState = null;
        }
    }

    public int getUnassignedTablets() {
        return this.unassignedTablets;
    }

    public MasterMonitorInfo setUnassignedTablets(int unassignedTablets) {
        this.unassignedTablets = unassignedTablets;
        this.setUnassignedTabletsIsSet(true);
        return this;
    }

    public void unsetUnassignedTablets() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetUnassignedTablets() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setUnassignedTabletsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getServersShuttingDownSize() {
        return this.serversShuttingDown == null ? 0 : this.serversShuttingDown.size();
    }

    @Nullable
    public Iterator<String> getServersShuttingDownIterator() {
        return this.serversShuttingDown == null ? null : this.serversShuttingDown.iterator();
    }

    public void addToServersShuttingDown(String elem) {
        if (this.serversShuttingDown == null) {
            this.serversShuttingDown = new HashSet<String>();
        }
        this.serversShuttingDown.add(elem);
    }

    @Nullable
    public Set<String> getServersShuttingDown() {
        return this.serversShuttingDown;
    }

    public MasterMonitorInfo setServersShuttingDown(@Nullable Set<String> serversShuttingDown) {
        this.serversShuttingDown = serversShuttingDown;
        return this;
    }

    public void unsetServersShuttingDown() {
        this.serversShuttingDown = null;
    }

    public boolean isSetServersShuttingDown() {
        return this.serversShuttingDown != null;
    }

    public void setServersShuttingDownIsSet(boolean value) {
        if (!value) {
            this.serversShuttingDown = null;
        }
    }

    public int getDeadTabletServersSize() {
        return this.deadTabletServers == null ? 0 : this.deadTabletServers.size();
    }

    @Nullable
    public Iterator<DeadServer> getDeadTabletServersIterator() {
        return this.deadTabletServers == null ? null : this.deadTabletServers.iterator();
    }

    public void addToDeadTabletServers(DeadServer elem) {
        if (this.deadTabletServers == null) {
            this.deadTabletServers = new ArrayList<DeadServer>();
        }
        this.deadTabletServers.add(elem);
    }

    @Nullable
    public List<DeadServer> getDeadTabletServers() {
        return this.deadTabletServers;
    }

    public MasterMonitorInfo setDeadTabletServers(@Nullable List<DeadServer> deadTabletServers) {
        this.deadTabletServers = deadTabletServers;
        return this;
    }

    public void unsetDeadTabletServers() {
        this.deadTabletServers = null;
    }

    public boolean isSetDeadTabletServers() {
        return this.deadTabletServers != null;
    }

    public void setDeadTabletServersIsSet(boolean value) {
        if (!value) {
            this.deadTabletServers = null;
        }
    }

    public int getBulkImportsSize() {
        return this.bulkImports == null ? 0 : this.bulkImports.size();
    }

    @Nullable
    public Iterator<BulkImportStatus> getBulkImportsIterator() {
        return this.bulkImports == null ? null : this.bulkImports.iterator();
    }

    public void addToBulkImports(BulkImportStatus elem) {
        if (this.bulkImports == null) {
            this.bulkImports = new ArrayList<BulkImportStatus>();
        }
        this.bulkImports.add(elem);
    }

    @Nullable
    public List<BulkImportStatus> getBulkImports() {
        return this.bulkImports;
    }

    public MasterMonitorInfo setBulkImports(@Nullable List<BulkImportStatus> bulkImports) {
        this.bulkImports = bulkImports;
        return this;
    }

    public void unsetBulkImports() {
        this.bulkImports = null;
    }

    public boolean isSetBulkImports() {
        return this.bulkImports != null;
    }

    public void setBulkImportsIsSet(boolean value) {
        if (!value) {
            this.bulkImports = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TABLE_MAP: {
                if (value == null) {
                    this.unsetTableMap();
                    break;
                }
                this.setTableMap((Map)value);
                break;
            }
            case T_SERVER_INFO: {
                if (value == null) {
                    this.unsetTServerInfo();
                    break;
                }
                this.setTServerInfo((List)value);
                break;
            }
            case BAD_TSERVERS: {
                if (value == null) {
                    this.unsetBadTServers();
                    break;
                }
                this.setBadTServers((Map)value);
                break;
            }
            case STATE: {
                if (value == null) {
                    this.unsetState();
                    break;
                }
                this.setState((MasterState)((Object)value));
                break;
            }
            case GOAL_STATE: {
                if (value == null) {
                    this.unsetGoalState();
                    break;
                }
                this.setGoalState((MasterGoalState)((Object)value));
                break;
            }
            case UNASSIGNED_TABLETS: {
                if (value == null) {
                    this.unsetUnassignedTablets();
                    break;
                }
                this.setUnassignedTablets((Integer)value);
                break;
            }
            case SERVERS_SHUTTING_DOWN: {
                if (value == null) {
                    this.unsetServersShuttingDown();
                    break;
                }
                this.setServersShuttingDown((Set)value);
                break;
            }
            case DEAD_TABLET_SERVERS: {
                if (value == null) {
                    this.unsetDeadTabletServers();
                    break;
                }
                this.setDeadTabletServers((List)value);
                break;
            }
            case BULK_IMPORTS: {
                if (value == null) {
                    this.unsetBulkImports();
                    break;
                }
                this.setBulkImports((List)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLE_MAP: {
                return this.getTableMap();
            }
            case T_SERVER_INFO: {
                return this.getTServerInfo();
            }
            case BAD_TSERVERS: {
                return this.getBadTServers();
            }
            case STATE: {
                return this.getState();
            }
            case GOAL_STATE: {
                return this.getGoalState();
            }
            case UNASSIGNED_TABLETS: {
                return this.getUnassignedTablets();
            }
            case SERVERS_SHUTTING_DOWN: {
                return this.getServersShuttingDown();
            }
            case DEAD_TABLET_SERVERS: {
                return this.getDeadTabletServers();
            }
            case BULK_IMPORTS: {
                return this.getBulkImports();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLE_MAP: {
                return this.isSetTableMap();
            }
            case T_SERVER_INFO: {
                return this.isSetTServerInfo();
            }
            case BAD_TSERVERS: {
                return this.isSetBadTServers();
            }
            case STATE: {
                return this.isSetState();
            }
            case GOAL_STATE: {
                return this.isSetGoalState();
            }
            case UNASSIGNED_TABLETS: {
                return this.isSetUnassignedTablets();
            }
            case SERVERS_SHUTTING_DOWN: {
                return this.isSetServersShuttingDown();
            }
            case DEAD_TABLET_SERVERS: {
                return this.isSetDeadTabletServers();
            }
            case BULK_IMPORTS: {
                return this.isSetBulkImports();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof MasterMonitorInfo) {
            return this.equals((MasterMonitorInfo)that);
        }
        return false;
    }

    public boolean equals(MasterMonitorInfo that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_tableMap = this.isSetTableMap();
        boolean that_present_tableMap = that.isSetTableMap();
        if (this_present_tableMap || that_present_tableMap) {
            if (!this_present_tableMap || !that_present_tableMap) {
                return false;
            }
            if (!this.tableMap.equals(that.tableMap)) {
                return false;
            }
        }
        boolean this_present_tServerInfo = this.isSetTServerInfo();
        boolean that_present_tServerInfo = that.isSetTServerInfo();
        if (this_present_tServerInfo || that_present_tServerInfo) {
            if (!this_present_tServerInfo || !that_present_tServerInfo) {
                return false;
            }
            if (!this.tServerInfo.equals(that.tServerInfo)) {
                return false;
            }
        }
        boolean this_present_badTServers = this.isSetBadTServers();
        boolean that_present_badTServers = that.isSetBadTServers();
        if (this_present_badTServers || that_present_badTServers) {
            if (!this_present_badTServers || !that_present_badTServers) {
                return false;
            }
            if (!this.badTServers.equals(that.badTServers)) {
                return false;
            }
        }
        boolean this_present_state = this.isSetState();
        boolean that_present_state = that.isSetState();
        if (this_present_state || that_present_state) {
            if (!this_present_state || !that_present_state) {
                return false;
            }
            if (!this.state.equals((Object)that.state)) {
                return false;
            }
        }
        boolean this_present_goalState = this.isSetGoalState();
        boolean that_present_goalState = that.isSetGoalState();
        if (this_present_goalState || that_present_goalState) {
            if (!this_present_goalState || !that_present_goalState) {
                return false;
            }
            if (!this.goalState.equals((Object)that.goalState)) {
                return false;
            }
        }
        boolean this_present_unassignedTablets = true;
        boolean that_present_unassignedTablets = true;
        if (this_present_unassignedTablets || that_present_unassignedTablets) {
            if (!this_present_unassignedTablets || !that_present_unassignedTablets) {
                return false;
            }
            if (this.unassignedTablets != that.unassignedTablets) {
                return false;
            }
        }
        boolean this_present_serversShuttingDown = this.isSetServersShuttingDown();
        boolean that_present_serversShuttingDown = that.isSetServersShuttingDown();
        if (this_present_serversShuttingDown || that_present_serversShuttingDown) {
            if (!this_present_serversShuttingDown || !that_present_serversShuttingDown) {
                return false;
            }
            if (!this.serversShuttingDown.equals(that.serversShuttingDown)) {
                return false;
            }
        }
        boolean this_present_deadTabletServers = this.isSetDeadTabletServers();
        boolean that_present_deadTabletServers = that.isSetDeadTabletServers();
        if (this_present_deadTabletServers || that_present_deadTabletServers) {
            if (!this_present_deadTabletServers || !that_present_deadTabletServers) {
                return false;
            }
            if (!this.deadTabletServers.equals(that.deadTabletServers)) {
                return false;
            }
        }
        boolean this_present_bulkImports = this.isSetBulkImports();
        boolean that_present_bulkImports = that.isSetBulkImports();
        if (this_present_bulkImports || that_present_bulkImports) {
            if (!this_present_bulkImports || !that_present_bulkImports) {
                return false;
            }
            if (!this.bulkImports.equals(that.bulkImports)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetTableMap() ? 131071 : 524287);
        if (this.isSetTableMap()) {
            hashCode = hashCode * 8191 + this.tableMap.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTServerInfo() ? 131071 : 524287);
        if (this.isSetTServerInfo()) {
            hashCode = hashCode * 8191 + this.tServerInfo.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetBadTServers() ? 131071 : 524287);
        if (this.isSetBadTServers()) {
            hashCode = hashCode * 8191 + this.badTServers.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetState() ? 131071 : 524287);
        if (this.isSetState()) {
            hashCode = hashCode * 8191 + this.state.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetGoalState() ? 131071 : 524287);
        if (this.isSetGoalState()) {
            hashCode = hashCode * 8191 + this.goalState.getValue();
        }
        hashCode = hashCode * 8191 + this.unassignedTablets;
        hashCode = hashCode * 8191 + (this.isSetServersShuttingDown() ? 131071 : 524287);
        if (this.isSetServersShuttingDown()) {
            hashCode = hashCode * 8191 + this.serversShuttingDown.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDeadTabletServers() ? 131071 : 524287);
        if (this.isSetDeadTabletServers()) {
            hashCode = hashCode * 8191 + this.deadTabletServers.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetBulkImports() ? 131071 : 524287);
        if (this.isSetBulkImports()) {
            hashCode = hashCode * 8191 + this.bulkImports.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(MasterMonitorInfo other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetTableMap()).compareTo(other.isSetTableMap());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableMap() && (lastComparison = TBaseHelper.compareTo(this.tableMap, other.tableMap)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTServerInfo()).compareTo(other.isSetTServerInfo());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTServerInfo() && (lastComparison = TBaseHelper.compareTo(this.tServerInfo, other.tServerInfo)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBadTServers()).compareTo(other.isSetBadTServers());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBadTServers() && (lastComparison = TBaseHelper.compareTo(this.badTServers, other.badTServers)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetState()).compareTo(other.isSetState());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetState() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.state), (Comparable)((Object)other.state))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGoalState()).compareTo(other.isSetGoalState());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGoalState() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.goalState), (Comparable)((Object)other.goalState))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUnassignedTablets()).compareTo(other.isSetUnassignedTablets());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUnassignedTablets() && (lastComparison = TBaseHelper.compareTo((int)this.unassignedTablets, (int)other.unassignedTablets)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetServersShuttingDown()).compareTo(other.isSetServersShuttingDown());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetServersShuttingDown() && (lastComparison = TBaseHelper.compareTo(this.serversShuttingDown, other.serversShuttingDown)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDeadTabletServers()).compareTo(other.isSetDeadTabletServers());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDeadTabletServers() && (lastComparison = TBaseHelper.compareTo(this.deadTabletServers, other.deadTabletServers)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBulkImports()).compareTo(other.isSetBulkImports());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBulkImports() && (lastComparison = TBaseHelper.compareTo(this.bulkImports, other.bulkImports)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        MasterMonitorInfo.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        MasterMonitorInfo.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MasterMonitorInfo(");
        boolean first = true;
        sb.append("tableMap:");
        if (this.tableMap == null) {
            sb.append("null");
        } else {
            sb.append(this.tableMap);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tServerInfo:");
        if (this.tServerInfo == null) {
            sb.append("null");
        } else {
            sb.append(this.tServerInfo);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("badTServers:");
        if (this.badTServers == null) {
            sb.append("null");
        } else {
            sb.append(this.badTServers);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("state:");
        if (this.state == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.state);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("goalState:");
        if (this.goalState == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.goalState);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("unassignedTablets:");
        sb.append(this.unassignedTablets);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("serversShuttingDown:");
        if (this.serversShuttingDown == null) {
            sb.append("null");
        } else {
            sb.append(this.serversShuttingDown);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("deadTabletServers:");
        if (this.deadTabletServers == null) {
            sb.append("null");
        } else {
            sb.append(this.deadTabletServers);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("bulkImports:");
        if (this.bulkImports == null) {
            sb.append("null");
        } else {
            sb.append(this.bulkImports);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    private static void unusedMethod() {
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE_MAP, new FieldMetaData("tableMap", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), (FieldValueMetaData)new StructMetaData(12, TableInfo.class))));
        tmpMap.put(_Fields.T_SERVER_INFO, new FieldMetaData("tServerInfo", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TabletServerStatus.class))));
        tmpMap.put(_Fields.BAD_TSERVERS, new FieldMetaData("badTServers", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(3))));
        tmpMap.put(_Fields.STATE, new FieldMetaData("state", 3, (FieldValueMetaData)new EnumMetaData(16, MasterState.class)));
        tmpMap.put(_Fields.GOAL_STATE, new FieldMetaData("goalState", 3, (FieldValueMetaData)new EnumMetaData(16, MasterGoalState.class)));
        tmpMap.put(_Fields.UNASSIGNED_TABLETS, new FieldMetaData("unassignedTablets", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SERVERS_SHUTTING_DOWN, new FieldMetaData("serversShuttingDown", 3, (FieldValueMetaData)new SetMetaData(14, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.DEAD_TABLET_SERVERS, new FieldMetaData("deadTabletServers", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, DeadServer.class))));
        tmpMap.put(_Fields.BULK_IMPORTS, new FieldMetaData("bulkImports", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, BulkImportStatus.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(MasterMonitorInfo.class, metaDataMap);
    }

    private static class MasterMonitorInfoTupleScheme
    extends TupleScheme<MasterMonitorInfo> {
        private MasterMonitorInfoTupleScheme() {
        }

        public void write(TProtocol prot, MasterMonitorInfo struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetTableMap()) {
                optionals.set(0);
            }
            if (struct.isSetTServerInfo()) {
                optionals.set(1);
            }
            if (struct.isSetBadTServers()) {
                optionals.set(2);
            }
            if (struct.isSetState()) {
                optionals.set(3);
            }
            if (struct.isSetGoalState()) {
                optionals.set(4);
            }
            if (struct.isSetUnassignedTablets()) {
                optionals.set(5);
            }
            if (struct.isSetServersShuttingDown()) {
                optionals.set(6);
            }
            if (struct.isSetDeadTabletServers()) {
                optionals.set(7);
            }
            if (struct.isSetBulkImports()) {
                optionals.set(8);
            }
            oprot.writeBitSet(optionals, 9);
            if (struct.isSetTableMap()) {
                oprot.writeI32(struct.tableMap.size());
                for (Map.Entry entry : struct.tableMap.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    ((TableInfo)entry.getValue()).write((TProtocol)oprot);
                }
            }
            if (struct.isSetTServerInfo()) {
                oprot.writeI32(struct.tServerInfo.size());
                for (TabletServerStatus tabletServerStatus : struct.tServerInfo) {
                    tabletServerStatus.write((TProtocol)oprot);
                }
            }
            if (struct.isSetBadTServers()) {
                oprot.writeI32(struct.badTServers.size());
                for (Map.Entry entry : struct.badTServers.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeByte(((Byte)entry.getValue()).byteValue());
                }
            }
            if (struct.isSetState()) {
                oprot.writeI32(struct.state.getValue());
            }
            if (struct.isSetGoalState()) {
                oprot.writeI32(struct.goalState.getValue());
            }
            if (struct.isSetUnassignedTablets()) {
                oprot.writeI32(struct.unassignedTablets);
            }
            if (struct.isSetServersShuttingDown()) {
                oprot.writeI32(struct.serversShuttingDown.size());
                for (String string : struct.serversShuttingDown) {
                    oprot.writeString(string);
                }
            }
            if (struct.isSetDeadTabletServers()) {
                oprot.writeI32(struct.deadTabletServers.size());
                for (DeadServer deadServer : struct.deadTabletServers) {
                    deadServer.write((TProtocol)oprot);
                }
            }
            if (struct.isSetBulkImports()) {
                oprot.writeI32(struct.bulkImports.size());
                for (BulkImportStatus bulkImportStatus : struct.bulkImports) {
                    bulkImportStatus.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, MasterMonitorInfo struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(9);
            if (incoming.get(0)) {
                TMap _map58 = new TMap(11, 12, iprot.readI32());
                struct.tableMap = new HashMap<String, TableInfo>(2 * _map58.size);
                for (int _i61 = 0; _i61 < _map58.size; ++_i61) {
                    String _key59 = iprot.readString();
                    TableInfo _val60 = new TableInfo();
                    _val60.read((TProtocol)iprot);
                    struct.tableMap.put(_key59, _val60);
                }
                struct.setTableMapIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list62 = new TList(12, iprot.readI32());
                struct.tServerInfo = new ArrayList<TabletServerStatus>(_list62.size);
                for (int _i64 = 0; _i64 < _list62.size; ++_i64) {
                    TabletServerStatus _elem63 = new TabletServerStatus();
                    _elem63.read((TProtocol)iprot);
                    struct.tServerInfo.add(_elem63);
                }
                struct.setTServerInfoIsSet(true);
            }
            if (incoming.get(2)) {
                TMap _map65 = new TMap(11, 3, iprot.readI32());
                struct.badTServers = new HashMap<String, Byte>(2 * _map65.size);
                for (int _i68 = 0; _i68 < _map65.size; ++_i68) {
                    String _key66 = iprot.readString();
                    byte _val67 = iprot.readByte();
                    struct.badTServers.put(_key66, _val67);
                }
                struct.setBadTServersIsSet(true);
            }
            if (incoming.get(3)) {
                struct.state = MasterState.findByValue(iprot.readI32());
                struct.setStateIsSet(true);
            }
            if (incoming.get(4)) {
                struct.goalState = MasterGoalState.findByValue(iprot.readI32());
                struct.setGoalStateIsSet(true);
            }
            if (incoming.get(5)) {
                struct.unassignedTablets = iprot.readI32();
                struct.setUnassignedTabletsIsSet(true);
            }
            if (incoming.get(6)) {
                TSet _set69 = new TSet(11, iprot.readI32());
                struct.serversShuttingDown = new HashSet<String>(2 * _set69.size);
                for (int _i71 = 0; _i71 < _set69.size; ++_i71) {
                    String _elem70 = iprot.readString();
                    struct.serversShuttingDown.add(_elem70);
                }
                struct.setServersShuttingDownIsSet(true);
            }
            if (incoming.get(7)) {
                TList _list72 = new TList(12, iprot.readI32());
                struct.deadTabletServers = new ArrayList<DeadServer>(_list72.size);
                for (int _i74 = 0; _i74 < _list72.size; ++_i74) {
                    DeadServer _elem73 = new DeadServer();
                    _elem73.read((TProtocol)iprot);
                    struct.deadTabletServers.add(_elem73);
                }
                struct.setDeadTabletServersIsSet(true);
            }
            if (incoming.get(8)) {
                TList _list75 = new TList(12, iprot.readI32());
                struct.bulkImports = new ArrayList<BulkImportStatus>(_list75.size);
                for (int _i77 = 0; _i77 < _list75.size; ++_i77) {
                    BulkImportStatus _elem76 = new BulkImportStatus();
                    _elem76.read((TProtocol)iprot);
                    struct.bulkImports.add(_elem76);
                }
                struct.setBulkImportsIsSet(true);
            }
        }
    }

    private static class MasterMonitorInfoTupleSchemeFactory
    implements SchemeFactory {
        private MasterMonitorInfoTupleSchemeFactory() {
        }

        public MasterMonitorInfoTupleScheme getScheme() {
            return new MasterMonitorInfoTupleScheme();
        }
    }

    private static class MasterMonitorInfoStandardScheme
    extends StandardScheme<MasterMonitorInfo> {
        private MasterMonitorInfoStandardScheme() {
        }

        public void read(TProtocol iprot, MasterMonitorInfo struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 13) {
                            TMap _map26 = iprot.readMapBegin();
                            struct.tableMap = new HashMap<String, TableInfo>(2 * _map26.size);
                            for (int _i29 = 0; _i29 < _map26.size; ++_i29) {
                                String _key27 = iprot.readString();
                                TableInfo _val28 = new TableInfo();
                                _val28.read(iprot);
                                struct.tableMap.put(_key27, _val28);
                            }
                            iprot.readMapEnd();
                            struct.setTableMapIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list30 = iprot.readListBegin();
                            struct.tServerInfo = new ArrayList<TabletServerStatus>(_list30.size);
                            for (int _i32 = 0; _i32 < _list30.size; ++_i32) {
                                TabletServerStatus _elem31 = new TabletServerStatus();
                                _elem31.read(iprot);
                                struct.tServerInfo.add(_elem31);
                            }
                            iprot.readListEnd();
                            struct.setTServerInfoIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 13) {
                            TMap _map33 = iprot.readMapBegin();
                            struct.badTServers = new HashMap<String, Byte>(2 * _map33.size);
                            for (int _i36 = 0; _i36 < _map33.size; ++_i36) {
                                String _key34 = iprot.readString();
                                byte _val35 = iprot.readByte();
                                struct.badTServers.put(_key34, _val35);
                            }
                            iprot.readMapEnd();
                            struct.setBadTServersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.state = MasterState.findByValue(iprot.readI32());
                            struct.setStateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.goalState = MasterGoalState.findByValue(iprot.readI32());
                            struct.setGoalStateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.unassignedTablets = iprot.readI32();
                            struct.setUnassignedTabletsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 14) {
                            TSet _set37 = iprot.readSetBegin();
                            struct.serversShuttingDown = new HashSet<String>(2 * _set37.size);
                            for (int _i39 = 0; _i39 < _set37.size; ++_i39) {
                                String _elem38 = iprot.readString();
                                struct.serversShuttingDown.add(_elem38);
                            }
                            iprot.readSetEnd();
                            struct.setServersShuttingDownIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 15) {
                            TList _list40 = iprot.readListBegin();
                            struct.deadTabletServers = new ArrayList<DeadServer>(_list40.size);
                            for (int _i42 = 0; _i42 < _list40.size; ++_i42) {
                                DeadServer _elem41 = new DeadServer();
                                _elem41.read(iprot);
                                struct.deadTabletServers.add(_elem41);
                            }
                            iprot.readListEnd();
                            struct.setDeadTabletServersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 15) {
                            TList _list43 = iprot.readListBegin();
                            struct.bulkImports = new ArrayList<BulkImportStatus>(_list43.size);
                            for (int _i45 = 0; _i45 < _list43.size; ++_i45) {
                                BulkImportStatus _elem44 = new BulkImportStatus();
                                _elem44.read(iprot);
                                struct.bulkImports.add(_elem44);
                            }
                            iprot.readListEnd();
                            struct.setBulkImportsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, MasterMonitorInfo struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.tableMap != null) {
                oprot.writeFieldBegin(TABLE_MAP_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 12, struct.tableMap.size()));
                for (Map.Entry entry : struct.tableMap.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    ((TableInfo)entry.getValue()).write(oprot);
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.tServerInfo != null) {
                oprot.writeFieldBegin(T_SERVER_INFO_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.tServerInfo.size()));
                for (TabletServerStatus tabletServerStatus : struct.tServerInfo) {
                    tabletServerStatus.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.badTServers != null) {
                oprot.writeFieldBegin(BAD_TSERVERS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 3, struct.badTServers.size()));
                for (Map.Entry entry : struct.badTServers.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeByte(((Byte)entry.getValue()).byteValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.state != null) {
                oprot.writeFieldBegin(STATE_FIELD_DESC);
                oprot.writeI32(struct.state.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(UNASSIGNED_TABLETS_FIELD_DESC);
            oprot.writeI32(struct.unassignedTablets);
            oprot.writeFieldEnd();
            if (struct.goalState != null) {
                oprot.writeFieldBegin(GOAL_STATE_FIELD_DESC);
                oprot.writeI32(struct.goalState.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.serversShuttingDown != null) {
                oprot.writeFieldBegin(SERVERS_SHUTTING_DOWN_FIELD_DESC);
                oprot.writeSetBegin(new TSet(11, struct.serversShuttingDown.size()));
                for (String string : struct.serversShuttingDown) {
                    oprot.writeString(string);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.deadTabletServers != null) {
                oprot.writeFieldBegin(DEAD_TABLET_SERVERS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.deadTabletServers.size()));
                for (DeadServer deadServer : struct.deadTabletServers) {
                    deadServer.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.bulkImports != null) {
                oprot.writeFieldBegin(BULK_IMPORTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.bulkImports.size()));
                for (BulkImportStatus bulkImportStatus : struct.bulkImports) {
                    bulkImportStatus.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class MasterMonitorInfoStandardSchemeFactory
    implements SchemeFactory {
        private MasterMonitorInfoStandardSchemeFactory() {
        }

        public MasterMonitorInfoStandardScheme getScheme() {
            return new MasterMonitorInfoStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE_MAP(1, "tableMap"),
        T_SERVER_INFO(2, "tServerInfo"),
        BAD_TSERVERS(3, "badTServers"),
        STATE(6, "state"),
        GOAL_STATE(8, "goalState"),
        UNASSIGNED_TABLETS(7, "unassignedTablets"),
        SERVERS_SHUTTING_DOWN(9, "serversShuttingDown"),
        DEAD_TABLET_SERVERS(10, "deadTabletServers"),
        BULK_IMPORTS(11, "bulkImports");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE_MAP;
                }
                case 2: {
                    return T_SERVER_INFO;
                }
                case 3: {
                    return BAD_TSERVERS;
                }
                case 6: {
                    return STATE;
                }
                case 8: {
                    return GOAL_STATE;
                }
                case 7: {
                    return UNASSIGNED_TABLETS;
                }
                case 9: {
                    return SERVERS_SHUTTING_DOWN;
                }
                case 10: {
                    return DEAD_TABLET_SERVERS;
                }
                case 11: {
                    return BULK_IMPORTS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

