/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.DispatchingFileFactory;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;

public abstract class FileOperations {
    private static final String HADOOP_JOBHISTORY_LOCATION = "_logs";
    private static final HashSet<String> validExtensions = new HashSet<String>(Arrays.asList("map", "rf"));
    private static final HashSet<String> bulkWorkingFiles = new HashSet<String>(Arrays.asList("loadmap.json", "renames.json", "_SUCCESS", "_logs"));

    public static Set<String> getValidExtensions() {
        return validExtensions;
    }

    public static Set<String> getBulkWorkingFiles() {
        return bulkWorkingFiles;
    }

    public static String getNewFileExtension(AccumuloConfiguration acuconf) {
        return acuconf.get(Property.TABLE_FILE_TYPE);
    }

    public static FileOperations getInstance() {
        return new DispatchingFileFactory();
    }

    protected abstract long getFileSize(FileOptions var1) throws IOException;

    protected abstract FileSKVWriter openWriter(FileOptions var1) throws IOException;

    protected abstract FileSKVIterator openIndex(FileOptions var1) throws IOException;

    protected abstract FileSKVIterator openScanReader(FileOptions var1) throws IOException;

    protected abstract FileSKVIterator openReader(FileOptions var1) throws IOException;

    public WriterBuilder newWriterBuilder() {
        return new WriterBuilder();
    }

    public IndexReaderBuilder newIndexReaderBuilder() {
        return new IndexReaderBuilder();
    }

    public ScanReaderBuilder newScanReaderBuilder() {
        return new ScanReaderBuilder();
    }

    public ReaderBuilder newReaderBuilder() {
        return new ReaderBuilder();
    }

    public static interface ScanReaderTableConfiguration {
        public ScanReaderBuilder withTableConfiguration(AccumuloConfiguration var1);
    }

    public class ScanReaderBuilder
    extends FileHelper
    implements ScanReaderTableConfiguration {
        private Range range;
        private Set<ByteSequence> columnFamilies;
        private boolean inclusive;

        public ScanReaderTableConfiguration forFile(String filename, FileSystem fs, Configuration fsConf, CryptoService cs) {
            this.filename(filename).fs(fs).fsConf(fsConf).cryptoService(cs);
            return this;
        }

        @Override
        public ScanReaderBuilder withTableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration(tableConfiguration);
            return this;
        }

        public ScanReaderBuilder overRange(Range range, Set<ByteSequence> columnFamilies, boolean inclusive) {
            Objects.requireNonNull(range);
            Objects.requireNonNull(columnFamilies);
            this.range = range;
            this.columnFamilies = columnFamilies;
            this.inclusive = inclusive;
            return this;
        }

        public FileSKVIterator build() throws IOException {
            return FileOperations.this.openScanReader(this.toScanReaderBuilderOptions(this.range, this.columnFamilies, this.inclusive));
        }
    }

    public static interface IndexReaderTableConfiguration {
        public IndexReaderBuilder withTableConfiguration(AccumuloConfiguration var1);
    }

    public class IndexReaderBuilder
    extends FileHelper
    implements IndexReaderTableConfiguration {
        private Cache<String, Long> fileLenCache;

        public IndexReaderBuilder() {
            this.fileLenCache = null;
        }

        public IndexReaderTableConfiguration forFile(String filename, FileSystem fs, Configuration fsConf, CryptoService cs) {
            this.filename(filename).fs(fs).fsConf(fsConf).cryptoService(cs);
            return this;
        }

        @Override
        public IndexReaderBuilder withTableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration(tableConfiguration);
            return this;
        }

        public IndexReaderBuilder withFileLenCache(Cache<String, Long> fileLenCache) {
            this.fileLenCache = fileLenCache;
            return this;
        }

        public FileSKVIterator build() throws IOException {
            return FileOperations.this.openIndex(this.toIndexReaderBuilderOptions(this.fileLenCache));
        }
    }

    public static interface ReaderTableConfiguration {
        public ReaderBuilder withTableConfiguration(AccumuloConfiguration var1);
    }

    public class ReaderBuilder
    extends FileHelper
    implements ReaderTableConfiguration {
        private BlockCache dataCache;
        private BlockCache indexCache;
        private Cache<String, Long> fileLenCache;
        private boolean seekToBeginning;

        public ReaderBuilder() {
            this.seekToBeginning = false;
        }

        public ReaderTableConfiguration forFile(String filename, FileSystem fs, Configuration fsConf, CryptoService cs) {
            this.filename(filename).fs(fs).fsConf(fsConf).cryptoService(cs);
            return this;
        }

        @Override
        public ReaderBuilder withTableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration(tableConfiguration);
            return this;
        }

        public ReaderBuilder withBlockCache(BlockCache dataCache, BlockCache indexCache) {
            this.dataCache = dataCache;
            this.indexCache = indexCache;
            return this;
        }

        public ReaderBuilder withDataCache(BlockCache dataCache) {
            this.dataCache = dataCache;
            return this;
        }

        public ReaderBuilder withIndexCache(BlockCache indexCache) {
            this.indexCache = indexCache;
            return this;
        }

        public ReaderBuilder withFileLenCache(Cache<String, Long> fileLenCache) {
            this.fileLenCache = fileLenCache;
            return this;
        }

        public ReaderBuilder withRateLimiter(RateLimiter rateLimiter) {
            this.rateLimiter(rateLimiter);
            return this;
        }

        public ReaderBuilder seekToBeginning() {
            this.seekToBeginning(true);
            return this;
        }

        public ReaderBuilder seekToBeginning(boolean seekToBeginning) {
            this.seekToBeginning = seekToBeginning;
            return this;
        }

        public FileSKVIterator build() throws IOException {
            if (!this.getTableConfiguration().getBoolean(Property.TABLE_INDEXCACHE_ENABLED)) {
                this.withIndexCache(null);
            }
            if (!this.getTableConfiguration().getBoolean(Property.TABLE_BLOCKCACHE_ENABLED)) {
                this.withDataCache(null);
            }
            return FileOperations.this.openReader(this.toReaderBuilderOptions(this.dataCache, this.indexCache, this.fileLenCache, this.seekToBeginning));
        }
    }

    public static interface WriterTableConfiguration {
        public WriterBuilder withTableConfiguration(AccumuloConfiguration var1);
    }

    public class WriterBuilder
    extends FileHelper
    implements WriterTableConfiguration {
        private String compression;
        private FSDataOutputStream outputStream;
        private boolean enableAccumuloStart;

        public WriterBuilder() {
            this.enableAccumuloStart = true;
        }

        public WriterTableConfiguration forOutputStream(String extension, FSDataOutputStream outputStream, Configuration fsConf, CryptoService cs) {
            this.outputStream = outputStream;
            this.filename("foo" + extension).fsConf(fsConf).cryptoService(cs);
            return this;
        }

        public WriterTableConfiguration forFile(String filename, FileSystem fs, Configuration fsConf, CryptoService cs) {
            this.filename(filename).fs(fs).fsConf(fsConf).cryptoService(cs);
            return this;
        }

        @Override
        public WriterBuilder withTableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration(tableConfiguration);
            return this;
        }

        public WriterBuilder withStartDisabled() {
            this.enableAccumuloStart = false;
            return this;
        }

        public WriterBuilder withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public WriterBuilder withRateLimiter(RateLimiter rateLimiter) {
            this.rateLimiter(rateLimiter);
            return this;
        }

        public FileSKVWriter build() throws IOException {
            return FileOperations.this.openWriter(this.toWriterBuilderOptions(this.compression, this.outputStream, this.enableAccumuloStart));
        }
    }

    public class FileHelper {
        private AccumuloConfiguration tableConfiguration;
        private String filename;
        private FileSystem fs;
        private Configuration fsConf;
        private RateLimiter rateLimiter;
        private CryptoService cryptoService;

        protected FileHelper fs(FileSystem fs) {
            this.fs = Objects.requireNonNull(fs);
            return this;
        }

        protected FileHelper fsConf(Configuration fsConf) {
            this.fsConf = Objects.requireNonNull(fsConf);
            return this;
        }

        protected FileHelper filename(String filename) {
            this.filename = Objects.requireNonNull(filename);
            return this;
        }

        protected FileHelper tableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration = Objects.requireNonNull(tableConfiguration);
            return this;
        }

        protected FileHelper rateLimiter(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        protected FileHelper cryptoService(CryptoService cs) {
            this.cryptoService = Objects.requireNonNull(cs);
            return this;
        }

        protected FileOptions toWriterBuilderOptions(String compression, FSDataOutputStream outputStream, boolean startEnabled) {
            return new FileOptions(this.tableConfiguration, this.filename, this.fs, this.fsConf, this.rateLimiter, compression, outputStream, startEnabled, null, null, null, false, this.cryptoService, null, null, true);
        }

        protected FileOptions toReaderBuilderOptions(BlockCache dataCache, BlockCache indexCache, Cache<String, Long> fileLenCache, boolean seekToBeginning) {
            return new FileOptions(this.tableConfiguration, this.filename, this.fs, this.fsConf, this.rateLimiter, null, null, false, dataCache, indexCache, fileLenCache, seekToBeginning, this.cryptoService, null, null, true);
        }

        protected FileOptions toIndexReaderBuilderOptions(Cache<String, Long> fileLenCache) {
            return new FileOptions(this.tableConfiguration, this.filename, this.fs, this.fsConf, this.rateLimiter, null, null, false, null, null, fileLenCache, false, this.cryptoService, null, null, true);
        }

        protected FileOptions toScanReaderBuilderOptions(Range range, Set<ByteSequence> columnFamilies, boolean inclusive) {
            return new FileOptions(this.tableConfiguration, this.filename, this.fs, this.fsConf, this.rateLimiter, null, null, false, null, null, null, false, this.cryptoService, range, columnFamilies, inclusive);
        }

        protected AccumuloConfiguration getTableConfiguration() {
            return this.tableConfiguration;
        }
    }

    public class FileOptions {
        public final AccumuloConfiguration tableConfiguration;
        public final String filename;
        public final FileSystem fs;
        public final Configuration fsConf;
        public final RateLimiter rateLimiter;
        public final String compression;
        public final FSDataOutputStream outputStream;
        public final boolean enableAccumuloStart;
        public final BlockCache dataCache;
        public final BlockCache indexCache;
        public final Cache<String, Long> fileLenCache;
        public final boolean seekToBeginning;
        public final CryptoService cryptoService;
        public final Range range;
        public final Set<ByteSequence> columnFamilies;
        public final boolean inclusive;

        public FileOptions(AccumuloConfiguration tableConfiguration, String filename, FileSystem fs, Configuration fsConf, RateLimiter rateLimiter, String compression, FSDataOutputStream outputStream, boolean enableAccumuloStart, BlockCache dataCache, BlockCache indexCache, Cache<String, Long> fileLenCache, boolean seekToBeginning, CryptoService cryptoService, Range range, Set<ByteSequence> columnFamilies, boolean inclusive) {
            this.tableConfiguration = tableConfiguration;
            this.filename = filename;
            this.fs = fs;
            this.fsConf = fsConf;
            this.rateLimiter = rateLimiter;
            this.compression = compression;
            this.outputStream = outputStream;
            this.enableAccumuloStart = enableAccumuloStart;
            this.dataCache = dataCache;
            this.indexCache = indexCache;
            this.fileLenCache = fileLenCache;
            this.seekToBeginning = seekToBeginning;
            this.cryptoService = Objects.requireNonNull(cryptoService);
            this.range = range;
            this.columnFamilies = columnFamilies;
            this.inclusive = inclusive;
        }

        public AccumuloConfiguration getTableConfiguration() {
            return this.tableConfiguration;
        }

        public String getFilename() {
            return this.filename;
        }

        public FileSystem getFileSystem() {
            return this.fs;
        }

        public Configuration getConfiguration() {
            return this.fsConf;
        }

        public RateLimiter getRateLimiter() {
            return this.rateLimiter;
        }

        public String getCompression() {
            return this.compression;
        }

        public FSDataOutputStream getOutputStream() {
            return this.outputStream;
        }

        public boolean isAccumuloStartEnabled() {
            return this.enableAccumuloStart;
        }

        public BlockCache getDataCache() {
            return this.dataCache;
        }

        public BlockCache getIndexCache() {
            return this.indexCache;
        }

        public Cache<String, Long> getFileLenCache() {
            return this.fileLenCache;
        }

        public boolean isSeekToBeginning() {
            return this.seekToBeginning;
        }

        public CryptoService getCryptoService() {
            return this.cryptoService;
        }

        public Range getRange() {
            return this.range;
        }

        public Set<ByteSequence> getColumnFamilies() {
            return this.columnFamilies;
        }

        public boolean isRangeInclusive() {
            return this.inclusive;
        }
    }
}

