/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.bloomfilter.DynamicBloomFilter;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.NoSuchMetaStoreException;
import org.apache.accumulo.core.file.keyfunctor.KeyFunctor;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.bloom.Key;
import org.apache.hadoop.util.hash.Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterLayer {
    private static final Logger LOG = LoggerFactory.getLogger(BloomFilterLayer.class);
    public static final String BLOOM_FILE_NAME = "acu_bloom";
    public static final int HASH_COUNT = 5;
    private static ExecutorService loadThreadPool = null;

    private static synchronized ExecutorService getLoadThreadPool(int maxLoadThreads) {
        if (loadThreadPool != null) {
            return loadThreadPool;
        }
        if (maxLoadThreads > 0) {
            LinkedBlockingQueue<Runnable> q = new LinkedBlockingQueue<Runnable>();
            loadThreadPool = new ThreadPoolExecutor(0, maxLoadThreads, 60L, TimeUnit.SECONDS, q, new NamingThreadFactory("bloom-loader"));
        }
        return loadThreadPool;
    }

    public static void main(String[] args) throws IOException {
        PrintStream out = System.out;
        SecureRandom r = new SecureRandom();
        HashSet<Integer> valsSet = new HashSet<Integer>();
        for (int i = 0; i < 100000; ++i) {
            valsSet.add(r.nextInt(Integer.MAX_VALUE));
        }
        ArrayList vals = new ArrayList(valsSet);
        Collections.sort(vals);
        ConfigurationCopy acuconf = new ConfigurationCopy(DefaultConfiguration.getInstance());
        acuconf.set(Property.TABLE_BLOOM_ENABLED, "true");
        acuconf.set(Property.TABLE_BLOOM_KEY_FUNCTOR, "accumulo.core.file.keyfunctor.ColumnFamilyFunctor");
        acuconf.set(Property.TABLE_FILE_TYPE, "rf");
        acuconf.set(Property.TABLE_BLOOM_LOAD_THRESHOLD, "1");
        acuconf.set(Property.TSERV_BLOOM_LOAD_MAXCONCURRENT, "1");
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        String suffix = FileOperations.getNewFileExtension(acuconf);
        String fname = "/tmp/test." + suffix;
        FileSKVWriter bmfw = FileOperations.getInstance().newWriterBuilder().forFile(fname, fs, conf, CryptoServiceFactory.newDefaultInstance()).withTableConfiguration(acuconf).build();
        long t1 = System.currentTimeMillis();
        bmfw.startDefaultLocalityGroup();
        for (Integer i : vals) {
            String fi = String.format("%010d", i);
            bmfw.append(new org.apache.accumulo.core.data.Key(new Text("r" + fi), new Text("cf1")), new Value(("v" + fi).getBytes(StandardCharsets.UTF_8)));
            bmfw.append(new org.apache.accumulo.core.data.Key(new Text("r" + fi), new Text("cf2")), new Value(("v" + fi).getBytes(StandardCharsets.UTF_8)));
        }
        long t2 = System.currentTimeMillis();
        out.printf("write rate %6.2f%n", (double)vals.size() / ((double)(t2 - t1) / 1000.0));
        bmfw.close();
        t1 = System.currentTimeMillis();
        FileSKVIterator bmfr = FileOperations.getInstance().newReaderBuilder().forFile(fname, fs, conf, CryptoServiceFactory.newDefaultInstance()).withTableConfiguration(acuconf).build();
        t2 = System.currentTimeMillis();
        out.println("Opened " + fname + " in " + (t2 - t1));
        t1 = System.currentTimeMillis();
        int hits = 0;
        for (int i = 0; i < 5000; ++i) {
            int row = r.nextInt(Integer.MAX_VALUE);
            String fi = String.format("%010d", row);
            org.apache.accumulo.core.data.Key k1 = new org.apache.accumulo.core.data.Key(new Text("r" + fi), new Text("cf1"));
            bmfr.seek(new Range(k1, true, k1.followingKey(PartialKey.ROW_COLFAM), false), new ArrayList<ByteSequence>(), false);
            if (!valsSet.contains(row)) continue;
            ++hits;
            if (bmfr.hasTop()) continue;
            out.println("ERROR " + row);
        }
        t2 = System.currentTimeMillis();
        out.printf("random lookup rate : %6.2f%n", 5000.0 / ((double)(t2 - t1) / 1000.0));
        out.println("hits = " + hits);
        int count = 0;
        t1 = System.currentTimeMillis();
        for (Integer row : valsSet) {
            String fi = String.format("%010d", row);
            org.apache.accumulo.core.data.Key k1 = new org.apache.accumulo.core.data.Key(new Text("r" + fi), new Text("cf1"));
            bmfr.seek(new Range(k1, true, k1.followingKey(PartialKey.ROW_COLFAM), false), new ArrayList<ByteSequence>(), false);
            if (!bmfr.hasTop()) {
                out.println("ERROR 2 " + row);
            }
            if (++count < 500) continue;
            break;
        }
        t2 = System.currentTimeMillis();
        out.printf("existant lookup rate %6.2f%n", 500.0 / ((double)(t2 - t1) / 1000.0));
        out.println("expected hits 500.  Receive hits: " + count);
        bmfr.close();
    }

    public static class Reader
    implements FileSKVIterator {
        private BloomFilterLoader bfl;
        private FileSKVIterator reader;
        private boolean checkSuper = true;

        public Reader(FileSKVIterator reader, AccumuloConfiguration acuconf) {
            this.reader = reader;
            this.bfl = new BloomFilterLoader(reader, acuconf);
        }

        private Reader(FileSKVIterator src, BloomFilterLoader bfl) {
            this.reader = src;
            this.bfl = bfl;
        }

        @Override
        public boolean hasTop() {
            return this.checkSuper ? this.reader.hasTop() : false;
        }

        @Override
        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            if (!this.bfl.probablyHasKey(range)) {
                this.checkSuper = false;
            } else {
                this.reader.seek(range, columnFamilies, inclusive);
                this.checkSuper = true;
            }
        }

        @Override
        public synchronized void close() throws IOException {
            this.bfl.close();
            this.reader.close();
        }

        @Override
        public org.apache.accumulo.core.data.Key getFirstKey() throws IOException {
            return this.reader.getFirstKey();
        }

        @Override
        public org.apache.accumulo.core.data.Key getLastKey() throws IOException {
            return this.reader.getLastKey();
        }

        @Override
        public SortedKeyValueIterator<org.apache.accumulo.core.data.Key, Value> deepCopy(IteratorEnvironment env) {
            return new Reader((FileSKVIterator)this.reader.deepCopy(env), this.bfl);
        }

        @Override
        public org.apache.accumulo.core.data.Key getTopKey() {
            return (org.apache.accumulo.core.data.Key)this.reader.getTopKey();
        }

        @Override
        public Value getTopValue() {
            return (Value)this.reader.getTopValue();
        }

        @Override
        public void init(SortedKeyValueIterator<org.apache.accumulo.core.data.Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void next() throws IOException {
            this.reader.next();
        }

        @Override
        public DataInputStream getMetaStore(String name) throws IOException {
            return this.reader.getMetaStore(name);
        }

        @Override
        public void closeDeepCopies() throws IOException {
            this.reader.closeDeepCopies();
        }

        @Override
        public void setInterruptFlag(AtomicBoolean flag) {
            this.reader.setInterruptFlag(flag);
        }

        @Override
        public FileSKVIterator getSample(SamplerConfigurationImpl sampleConfig) {
            return new Reader(this.reader.getSample(sampleConfig), this.bfl);
        }
    }

    static class BloomFilterLoader {
        private volatile DynamicBloomFilter bloomFilter;
        private int loadRequest = 0;
        private int loadThreshold = 1;
        private int maxLoadThreads;
        private Runnable loadTask;
        private volatile KeyFunctor transformer = null;
        private volatile boolean closed = false;

        BloomFilterLoader(FileSKVIterator reader, AccumuloConfiguration acuconf) {
            this.maxLoadThreads = acuconf.getCount(Property.TSERV_BLOOM_LOAD_MAXCONCURRENT);
            this.loadThreshold = acuconf.getCount(Property.TABLE_BLOOM_LOAD_THRESHOLD);
            String context = acuconf.get(Property.TABLE_CLASSPATH);
            this.loadTask = () -> {
                if (this.closed) {
                    return;
                }
                String ClassName = null;
                DataInputStream in = null;
                try {
                    in = reader.getMetaStore(BloomFilterLayer.BLOOM_FILE_NAME);
                    DynamicBloomFilter tmpBloomFilter = new DynamicBloomFilter();
                    if (this.closed) {
                        return;
                    }
                    ClassName = in.readUTF();
                    Class clazz = context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().loadClass(context, ClassName, KeyFunctor.class) : AccumuloVFSClassLoader.loadClass((String)ClassName, KeyFunctor.class);
                    this.transformer = (KeyFunctor)clazz.newInstance();
                    tmpBloomFilter.readFields(in);
                    this.bloomFilter = tmpBloomFilter;
                }
                catch (NoSuchMetaStoreException e) {
                }
                catch (IOException ioe) {
                    if (!this.closed) {
                        LOG.warn("Can't open BloomFilter", (Throwable)ioe);
                    } else {
                        LOG.debug("Can't open BloomFilter, file closed : {}", (Object)ioe.getMessage());
                    }
                    this.bloomFilter = null;
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Failed to find KeyFunctor in config: " + this.sanitize(ClassName), (Throwable)e);
                    this.bloomFilter = null;
                }
                catch (InstantiationException e) {
                    LOG.error("Could not instantiate KeyFunctor: " + this.sanitize(ClassName), (Throwable)e);
                    this.bloomFilter = null;
                }
                catch (IllegalAccessException e) {
                    LOG.error("Illegal acess exception", (Throwable)e);
                    this.bloomFilter = null;
                }
                catch (RuntimeException rte) {
                    if (!this.closed) {
                        throw rte;
                    }
                    LOG.debug("Can't open BloomFilter, RTE after closed ", (Throwable)rte);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to close ", (Throwable)e);
                        }
                    }
                }
            };
            this.initiateLoad(this.maxLoadThreads);
        }

        private String sanitize(String msg) {
            return msg.replaceAll("[\r\n]", "");
        }

        private synchronized void initiateLoad(int maxLoadThreads) {
            if (this.loadTask != null && this.loadRequest >= this.loadThreshold) {
                try {
                    ExecutorService ltp = BloomFilterLayer.getLoadThreadPool(maxLoadThreads);
                    if (ltp == null) {
                        this.loadTask.run();
                    } else {
                        ltp.execute(new LoggingRunnable(LOG, this.loadTask));
                    }
                }
                finally {
                    this.loadTask = null;
                }
            }
            ++this.loadRequest;
        }

        boolean probablyHasKey(Range range) {
            Key bloomKey;
            if (this.bloomFilter == null) {
                this.initiateLoad(this.maxLoadThreads);
                if (this.bloomFilter == null) {
                    return true;
                }
            }
            if ((bloomKey = this.transformer.transform(range)) == null || bloomKey.getBytes().length == 0) {
                return true;
            }
            return this.bloomFilter.membershipTest(bloomKey);
        }

        public void close() {
            this.closed = true;
        }
    }

    public static class Writer
    implements FileSKVWriter {
        private DynamicBloomFilter bloomFilter;
        private int numKeys;
        private int vectorSize;
        private FileSKVWriter writer;
        private KeyFunctor transformer = null;
        private boolean closed = false;
        private long length = -1L;

        Writer(FileSKVWriter writer, AccumuloConfiguration acuconf, boolean useAccumuloStart) {
            this.writer = writer;
            this.initBloomFilter(acuconf, useAccumuloStart);
        }

        private synchronized void initBloomFilter(AccumuloConfiguration acuconf, boolean useAccumuloStart) {
            this.numKeys = acuconf.getCount(Property.TABLE_BLOOM_SIZE);
            double errorRate = acuconf.getFraction(Property.TABLE_BLOOM_ERRORRATE);
            this.vectorSize = (int)Math.ceil((double)(-5 * this.numKeys) / Math.log(1.0 - Math.pow(errorRate, 0.2)));
            this.bloomFilter = new DynamicBloomFilter(this.vectorSize, 5, Hash.parseHashType((String)acuconf.get(Property.TABLE_BLOOM_HASHTYPE)), this.numKeys);
            try {
                String context = acuconf.get(Property.TABLE_CLASSPATH);
                String classname = acuconf.get(Property.TABLE_BLOOM_KEY_FUNCTOR);
                Class clazz = !useAccumuloStart ? Writer.class.getClassLoader().loadClass(classname).asSubclass(KeyFunctor.class) : (context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().loadClass(context, classname, KeyFunctor.class) : AccumuloVFSClassLoader.loadClass((String)classname, KeyFunctor.class));
                this.transformer = clazz.newInstance();
            }
            catch (Exception e) {
                LOG.error("Failed to find KeyFunctor: " + acuconf.get(Property.TABLE_BLOOM_KEY_FUNCTOR), (Throwable)e);
                throw new IllegalArgumentException("Failed to find KeyFunctor: " + acuconf.get(Property.TABLE_BLOOM_KEY_FUNCTOR));
            }
        }

        @Override
        public synchronized void append(org.apache.accumulo.core.data.Key key, Value val) throws IOException {
            this.writer.append(key, val);
            Key bloomKey = this.transformer.transform(key);
            if (bloomKey.getBytes().length > 0) {
                this.bloomFilter.add(bloomKey);
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            DataOutputStream out = this.writer.createMetaStore(BloomFilterLayer.BLOOM_FILE_NAME);
            out.writeUTF(this.transformer.getClass().getName());
            this.bloomFilter.write(out);
            out.flush();
            out.close();
            this.writer.close();
            this.length = this.writer.getLength();
            this.closed = true;
        }

        @Override
        public DataOutputStream createMetaStore(String name) throws IOException {
            return this.writer.createMetaStore(name);
        }

        @Override
        public void startDefaultLocalityGroup() throws IOException {
            this.writer.startDefaultLocalityGroup();
        }

        @Override
        public void startNewLocalityGroup(String name, Set<ByteSequence> columnFamilies) throws IOException {
            this.writer.startNewLocalityGroup(name, columnFamilies);
        }

        @Override
        public boolean supportsLocalityGroups() {
            return this.writer.supportsLocalityGroups();
        }

        @Override
        public long getLength() throws IOException {
            if (this.closed) {
                return this.length;
            }
            return this.writer.getLength();
        }
    }
}

