/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.cryptoImpl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.accumulo.core.spi.crypto.CryptoService;

public class AESKeyUtils {
    public static final String URI = "uri";
    public static final String KEY_WRAP_TRANSFORM = "AESWrap";

    public static Key generateKey(SecureRandom sr, int size) {
        byte[] bytes = new byte[size];
        sr.nextBytes(bytes);
        return new SecretKeySpec(bytes, "AES");
    }

    @SuppressFBWarnings(value={"CIPHER_INTEGRITY"}, justification="integrity not needed for key wrap")
    public static Key unwrapKey(byte[] fek, Key kek) {
        Key result = null;
        try {
            Cipher c = Cipher.getInstance(KEY_WRAP_TRANSFORM);
            c.init(4, kek);
            result = c.unwrap(fek, "AES", 3);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoService.CryptoException("Unable to unwrap file encryption key", e);
        }
        return result;
    }

    @SuppressFBWarnings(value={"CIPHER_INTEGRITY"}, justification="integrity not needed for key wrap")
    public static byte[] wrapKey(Key fek, Key kek) {
        byte[] result = null;
        try {
            Cipher c = Cipher.getInstance(KEY_WRAP_TRANSFORM);
            c.init(3, kek);
            result = c.wrap(fek);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoService.CryptoException("Unable to wrap file encryption key", e);
        }
        return result;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="keyId specified by admin")
    public static SecretKeySpec loadKekFromUri(String keyId) {
        SecretKeySpec key = null;
        try {
            URI uri = new URI(keyId);
            key = new SecretKeySpec(Files.readAllBytes(Paths.get(uri.getPath(), new String[0])), "AES");
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            throw new CryptoService.CryptoException("Unable to load key encryption key.", e);
        }
        return key;
    }
}

