/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.crypto.streams;

import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

public class RFileCipherOutputStream
extends CipherOutputStream {
    private final long maxOutputSize = 0x400000000L;
    private long count = 0L;

    public RFileCipherOutputStream(OutputStream os, Cipher c) {
        super(os, c);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.count += (long)len;
        if (this.count > 0x400000000L) {
            throw new IOException("Attempt to write " + this.count + " bytes was made. A maximum of " + 0x400000000L + " is allowed for an encryption stream.");
        }
        super.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        ++this.count;
        if (this.count > 0x400000000L) {
            throw new IOException("Attempt to write " + this.count + " bytes was made. A maximum of " + 0x400000000L + " is allowed for an encryption stream.");
        }
        super.write(b);
    }
}

