/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.accumulo.core.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccumuloConfiguration
implements Iterable<Map.Entry<String, String>> {
    private volatile EnumMap<Property, PrefixProps> cachedPrefixProps = new EnumMap(Property.class);
    private Lock prefixCacheUpdateLock = new ReentrantLock();
    private static final Logger log = LoggerFactory.getLogger(AccumuloConfiguration.class);
    boolean depPropWarned = false;
    private static final String SCAN_EXEC_THREADS = "threads";
    private static final String SCAN_EXEC_PRIORITY = "priority";
    private static final String SCAN_EXEC_PRIORITIZER = "prioritizer";
    private static final String SCAN_EXEC_PRIORITIZER_OPTS = "prioritizer.opts.";

    public String get(String property) {
        HashMap<String, String> propMap = new HashMap<String, String>(1);
        this.getProperties(propMap, key -> Objects.equals(property, key));
        return (String)propMap.get(property);
    }

    public abstract String get(Property var1);

    public Property resolve(Property property, Property deprecatedProperty) {
        if (this.isPropertySet(property, true)) {
            return property;
        }
        if (this.isPropertySet(deprecatedProperty, true)) {
            return deprecatedProperty;
        }
        return property;
    }

    public abstract void getProperties(Map<String, String> var1, Predicate<String> var2);

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        Predicate<String> all = x -> true;
        TreeMap<String, String> entries = new TreeMap<String, String>();
        this.getProperties(entries, all);
        return entries.entrySet().iterator();
    }

    private static void checkType(Property property, PropertyType type) {
        if (!property.getType().equals((Object)type)) {
            String msg = "Configuration method intended for type " + (Object)((Object)type) + " called with a " + (Object)((Object)property.getType()) + " argument (" + property.getKey() + ")";
            IllegalArgumentException err = new IllegalArgumentException(msg);
            log.error(msg, (Throwable)err);
            throw err;
        }
    }

    public long getUpdateCount() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAllPropertiesWithPrefix(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.PREFIX);
        PrefixProps prefixProps = this.cachedPrefixProps.get((Object)property);
        if (prefixProps == null || prefixProps.updateCount != this.getUpdateCount()) {
            this.prefixCacheUpdateLock.lock();
            try {
                long updateCount = this.getUpdateCount();
                prefixProps = this.cachedPrefixProps.get((Object)property);
                if (prefixProps == null || prefixProps.updateCount != updateCount) {
                    ImmutableMap propMap = new HashMap();
                    this.getProperties((Map<String, String>)propMap, key -> key.startsWith(property.getKey()));
                    propMap = ImmutableMap.copyOf(propMap);
                    EnumMap<Property, PrefixProps> localPrefixes = new EnumMap<Property, PrefixProps>(Property.class);
                    localPrefixes.putAll(this.cachedPrefixProps);
                    prefixProps = new PrefixProps((Map<String, String>)propMap, updateCount);
                    localPrefixes.put(property, prefixProps);
                    this.cachedPrefixProps = localPrefixes;
                }
            }
            finally {
                this.prefixCacheUpdateLock.unlock();
            }
        }
        return prefixProps.props;
    }

    public long getAsBytes(Property property) {
        String memString = this.get(property);
        if (property.getType() == PropertyType.MEMORY) {
            return ConfigurationTypeHelper.getMemoryAsBytes(memString);
        }
        if (property.getType() == PropertyType.BYTES) {
            return ConfigurationTypeHelper.getFixedMemoryAsBytes(memString);
        }
        throw new IllegalArgumentException(property.getKey() + " is not of BYTES or MEMORY type");
    }

    public long getTimeInMillis(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.TIMEDURATION);
        return ConfigurationTypeHelper.getTimeInMillis(this.get(property));
    }

    public boolean getBoolean(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.BOOLEAN);
        return Boolean.parseBoolean(this.get(property));
    }

    public double getFraction(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.FRACTION);
        return ConfigurationTypeHelper.getFraction(this.get(property));
    }

    public int[] getPort(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.PORT);
        String portString = this.get(property);
        int[] ports = null;
        try {
            Pair<Integer, Integer> portRange = PropertyType.PortRange.parse(portString);
            int low = portRange.getFirst();
            int high = portRange.getSecond();
            ports = new int[high - low + 1];
            int i = 0;
            int j = low;
            while (j <= high) {
                ports[i] = j++;
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            ports = new int[1];
            try {
                int port = Integer.parseInt(portString);
                if (port != 0) {
                    if (port < 1024 || port > 65535) {
                        log.error("Invalid port number {}; Using default {}", (Object)port, (Object)property.getDefaultValue());
                        ports[0] = Integer.parseInt(property.getDefaultValue());
                    } else {
                        ports[0] = port;
                    }
                } else {
                    ports[0] = port;
                }
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("Invalid port syntax. Must be a single positive integers or a range (M-N) of positive integers");
            }
        }
        return ports;
    }

    public int getCount(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.COUNT);
        String countString = this.get(property);
        return Integer.parseInt(countString);
    }

    public String getPath(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.PATH);
        String pathString = this.get(property);
        if (pathString == null) {
            return null;
        }
        if (pathString.contains("$ACCUMULO_")) {
            throw new IllegalArgumentException("Environment variable interpolation not supported here. Consider using '${env:ACCUMULO_HOME}' or similar in your configuration file.");
        }
        return pathString;
    }

    public int getMaxFilesPerTablet() {
        int maxFilesPerTablet = this.getCount(Property.TABLE_FILE_MAX);
        if (maxFilesPerTablet <= 0) {
            maxFilesPerTablet = this.getCount(Property.TSERV_SCAN_MAX_OPENFILES) - 1;
            log.debug("Max files per tablet {}", (Object)maxFilesPerTablet);
        }
        return maxFilesPerTablet;
    }

    public boolean isPropertySet(Property prop, boolean cacheAndWatch) {
        throw new UnsupportedOperationException();
    }

    Integer getDeprecatedScanThreads(String name) {
        Property deprecatedProp;
        Property prop;
        if (name.equals("default")) {
            prop = Property.TSERV_SCAN_EXECUTORS_DEFAULT_THREADS;
            deprecatedProp = Property.TSERV_READ_AHEAD_MAXCONCURRENT;
        } else if (name.equals("meta")) {
            prop = Property.TSERV_SCAN_EXECUTORS_META_THREADS;
            deprecatedProp = Property.TSERV_METADATA_READ_AHEAD_MAXCONCURRENT;
        } else {
            return null;
        }
        if (!this.isPropertySet(prop, true) && this.isPropertySet(deprecatedProp, true)) {
            if (!this.depPropWarned) {
                this.depPropWarned = true;
                log.warn("Property {} is deprecated, use {} instead.", (Object)deprecatedProp.getKey(), (Object)prop.getKey());
            }
            return Integer.valueOf(this.get(deprecatedProp));
        }
        if (this.isPropertySet(prop, true) && this.isPropertySet(deprecatedProp, true) && !this.depPropWarned) {
            this.depPropWarned = true;
            log.warn("Deprecated property {} ignored because {} is set", (Object)deprecatedProp.getKey(), (Object)prop.getKey());
        }
        return null;
    }

    public Collection<ScanExecutorConfig> getScanExecutors() {
        HashMap<String, Map> propsByName = new HashMap<String, Map>();
        ArrayList<ScanExecutorConfig> scanResources = new ArrayList<ScanExecutorConfig>();
        for (Map.Entry<String, String> entry : this.getAllPropertiesWithPrefix(Property.TSERV_SCAN_EXECUTORS_PREFIX).entrySet()) {
            String suffix = entry.getKey().substring(Property.TSERV_SCAN_EXECUTORS_PREFIX.getKey().length());
            String[] tokens = suffix.split("\\.", 2);
            String name = tokens[0];
            propsByName.computeIfAbsent(name, k -> new HashMap()).put(tokens[1], entry.getValue());
        }
        for (Map.Entry<String, String> entry : propsByName.entrySet()) {
            String name = entry.getKey();
            Integer threads = null;
            Integer prio = null;
            String prioritizerClass = null;
            HashMap<String, String> prioritizerOpts = new HashMap<String, String>();
            for (Map.Entry subEntry : ((Map)((Object)entry.getValue())).entrySet()) {
                String opt = (String)subEntry.getKey();
                String val = (String)subEntry.getValue();
                if (opt.equals(SCAN_EXEC_THREADS)) {
                    Integer depThreads = this.getDeprecatedScanThreads(name);
                    if (depThreads == null) {
                        threads = Integer.parseInt(val);
                        continue;
                    }
                    threads = depThreads;
                    continue;
                }
                if (opt.equals(SCAN_EXEC_PRIORITY)) {
                    prio = Integer.parseInt(val);
                    continue;
                }
                if (opt.equals(SCAN_EXEC_PRIORITIZER)) {
                    prioritizerClass = val;
                    continue;
                }
                if (opt.startsWith(SCAN_EXEC_PRIORITIZER_OPTS)) {
                    String key = opt.substring(SCAN_EXEC_PRIORITIZER_OPTS.length());
                    if (key.isEmpty()) {
                        throw new IllegalStateException("Invalid scan executor option : " + opt);
                    }
                    prioritizerOpts.put(key, val);
                    continue;
                }
                throw new IllegalStateException("Unkown scan executor option : " + opt);
            }
            Preconditions.checkArgument((threads != null && threads > 0 ? 1 : 0) != 0, (String)"Scan resource %s incorrectly specified threads", (Object)name);
            scanResources.add(new ScanExecutorConfig(name, threads, prio == null ? OptionalInt.empty() : OptionalInt.of(prio), Optional.ofNullable(prioritizerClass), prioritizerOpts));
        }
        return scanResources;
    }

    public void invalidateCache() {
    }

    public class ScanExecutorConfig {
        public final String name;
        public final int maxThreads;
        public final OptionalInt priority;
        public final Optional<String> prioritizerClass;
        public final Map<String, String> prioritizerOpts;

        public ScanExecutorConfig(String name, int maxThreads, OptionalInt priority, Optional<String> comparatorFactory, Map<String, String> comparatorFactoryOpts) {
            this.name = name;
            this.maxThreads = maxThreads;
            this.priority = priority;
            this.prioritizerClass = comparatorFactory;
            this.prioritizerOpts = comparatorFactoryOpts;
        }

        public int getCurrentMaxThreads() {
            Integer depThreads = AccumuloConfiguration.this.getDeprecatedScanThreads(this.name);
            if (depThreads != null) {
                return depThreads;
            }
            String prop = Property.TSERV_SCAN_EXECUTORS_PREFIX.getKey() + this.name + "." + AccumuloConfiguration.SCAN_EXEC_THREADS;
            String val = AccumuloConfiguration.this.getAllPropertiesWithPrefix(Property.TSERV_SCAN_EXECUTORS_PREFIX).get(prop);
            return Integer.parseInt(val);
        }
    }

    private static class PrefixProps {
        final long updateCount;
        final Map<String, String> props;

        PrefixProps(Map<String, String> props, long updateCount) {
            this.updateCount = updateCount;
            this.props = props;
        }
    }
}

