/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.util.Validator;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Namespaces {
    private static final Logger log = LoggerFactory.getLogger(Namespaces.class);
    public static final String VALID_NAME_REGEX = "^\\w*$";
    public static final Validator<String> VALID_NAME = new Validator<String>(){

        @Override
        public boolean test(String namespace) {
            return namespace != null && namespace.matches(Namespaces.VALID_NAME_REGEX);
        }

        @Override
        public String invalidMessage(String namespace) {
            if (namespace == null) {
                return "Namespace cannot be null";
            }
            return "Namespaces must only contain word characters (letters, digits, and underscores): " + namespace;
        }
    };
    public static final Validator<String> NOT_DEFAULT = new Validator<String>(){

        @Override
        public boolean test(String namespace) {
            return !Namespace.DEFAULT.name().equals(namespace);
        }

        @Override
        public String invalidMessage(String namespace) {
            return "Namespace cannot be the reserved empty namespace";
        }
    };
    public static final Validator<String> NOT_ACCUMULO = new Validator<String>(){

        @Override
        public boolean test(String namespace) {
            return !Namespace.ACCUMULO.name().equals(namespace);
        }

        @Override
        public String invalidMessage(String namespace) {
            return "Namespace cannot be the reserved namespace, " + Namespace.ACCUMULO.name();
        }
    };

    public static boolean exists(ClientContext context, NamespaceId namespaceId) {
        ZooCache zc = context.getZooCache();
        List<String> namespaceIds = zc.getChildren(context.getZooKeeperRoot() + "/namespaces");
        return namespaceIds.contains(namespaceId.canonical());
    }

    public static List<TableId> getTableIds(ClientContext context, NamespaceId namespaceId) throws NamespaceNotFoundException {
        String namespace = Namespaces.getNamespaceName(context, namespaceId);
        LinkedList<TableId> tableIds = new LinkedList<TableId>();
        for (Map.Entry<String, TableId> nameToId : Tables.getNameToIdMap(context).entrySet()) {
            if (!namespace.equals(Tables.qualify(nameToId.getKey()).getFirst())) continue;
            tableIds.add(nameToId.getValue());
        }
        return tableIds;
    }

    public static List<String> getTableNames(ClientContext context, NamespaceId namespaceId) throws NamespaceNotFoundException {
        String namespace = Namespaces.getNamespaceName(context, namespaceId);
        LinkedList<String> names = new LinkedList<String>();
        for (String name : Tables.getNameToIdMap(context).keySet()) {
            if (!namespace.equals(Tables.qualify(name).getFirst())) continue;
            names.add(name);
        }
        return names;
    }

    private static void getAllNamespaces(ClientContext context, BiConsumer<String, String> biConsumer) {
        ZooCache zc = context.getZooCache();
        List<String> namespaceIds = zc.getChildren(context.getZooKeeperRoot() + "/namespaces");
        for (String id : namespaceIds) {
            byte[] path = zc.get(context.getZooKeeperRoot() + "/namespaces" + "/" + id + "/name");
            if (path == null) continue;
            biConsumer.accept(id, new String(path, StandardCharsets.UTF_8));
        }
    }

    public static SortedMap<NamespaceId, String> getIdToNameMap(ClientContext context) {
        TreeMap<NamespaceId, String> idMap = new TreeMap<NamespaceId, String>();
        Namespaces.getAllNamespaces(context, (id, name) -> idMap.put(NamespaceId.of(id), (String)name));
        return idMap;
    }

    public static SortedMap<String, NamespaceId> getNameToIdMap(ClientContext context) {
        TreeMap<String, NamespaceId> nameMap = new TreeMap<String, NamespaceId>();
        Namespaces.getAllNamespaces(context, (id, name) -> nameMap.put((String)name, NamespaceId.of(id)));
        return nameMap;
    }

    public static NamespaceId getNamespaceId(ClientContext context, String namespaceName) throws NamespaceNotFoundException {
        ArrayList singleId = new ArrayList(1);
        Namespaces.getAllNamespaces(context, (id, name) -> {
            if (name.equals(namespaceName)) {
                singleId.add(NamespaceId.of(id));
            }
        });
        if (singleId.isEmpty()) {
            throw new NamespaceNotFoundException(null, namespaceName, "getNamespaceId() failed to find namespace");
        }
        return (NamespaceId)singleId.get(0);
    }

    public static NamespaceId lookupNamespaceId(ClientContext context, String namespaceName) {
        NamespaceId id;
        block2: {
            id = null;
            try {
                id = Namespaces.getNamespaceId(context, namespaceName);
            }
            catch (NamespaceNotFoundException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Failed to find namespace ID from name: " + namespaceName, (Throwable)e);
            }
        }
        return id;
    }

    public static boolean namespaceNameExists(ClientContext context, String namespaceName) {
        return Namespaces.lookupNamespaceId(context, namespaceName) != null;
    }

    public static String getNamespaceName(ClientContext context, NamespaceId namespaceId) throws NamespaceNotFoundException {
        ZooCache zc = context.getZooCache();
        byte[] path = zc.get(context.getZooKeeperRoot() + "/namespaces" + "/" + namespaceId.canonical() + "/name");
        if (path == null) {
            throw new NamespaceNotFoundException(namespaceId.canonical(), null, "getNamespaceName() failed to find namespace");
        }
        String name = new String(path, StandardCharsets.UTF_8);
        return name;
    }
}

