/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.rfile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.client.rfile.FSConfArgs;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileWriter;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class RFileWriterBuilder
implements RFile.OutputArguments,
RFile.WriterFSOptions {
    private OutputArgs out;
    private Map<String, String> tableConfig = Collections.emptyMap();
    private int visCacheSize = 1000;
    private Map<String, String> samplerProps = Collections.emptyMap();
    private Map<String, String> summarizerProps = Collections.emptyMap();

    RFileWriterBuilder() {
    }

    private void checkDisjoint(Map<String, String> props, Map<String, String> derivedProps, String kind) {
        Preconditions.checkArgument((boolean)Collections.disjoint(props.keySet(), derivedProps.keySet()), (String)"Properties and derived %s properties are not disjoint", (Object)kind);
    }

    @Override
    public RFile.WriterOptions withSampler(SamplerConfiguration samplerConf) {
        Objects.requireNonNull(samplerConf);
        Map<String, String> tmp = new SamplerConfigurationImpl(samplerConf).toTablePropertiesMap();
        this.checkDisjoint(this.tableConfig, tmp, "sampler");
        this.samplerProps = tmp;
        return this;
    }

    @Override
    public RFileWriter build() throws IOException {
        FileOperations fileops = FileOperations.getInstance();
        AccumuloConfiguration acuconf = DefaultConfiguration.getInstance();
        HashMap<String, String> userProps = new HashMap<String, String>();
        userProps.putAll(this.tableConfig);
        userProps.putAll(this.summarizerProps);
        userProps.putAll(this.samplerProps);
        if (userProps.size() > 0) {
            acuconf = new ConfigurationCopy(Iterables.concat((Iterable)acuconf, userProps.entrySet()));
        }
        CryptoService cs = CryptoServiceFactory.newInstance(acuconf, CryptoServiceFactory.ClassloaderType.JAVA);
        if (this.out.getOutputStream() != null) {
            FSDataOutputStream fsdo = this.out.getOutputStream() instanceof FSDataOutputStream ? (FSDataOutputStream)this.out.getOutputStream() : new FSDataOutputStream(this.out.getOutputStream(), new FileSystem.Statistics("foo"));
            return new RFileWriter(fileops.newWriterBuilder().forOutputStream(".rf", fsdo, this.out.getConf(), cs).withTableConfiguration(acuconf).withStartDisabled().build(), this.visCacheSize);
        }
        return new RFileWriter(fileops.newWriterBuilder().forFile(this.out.path.toString(), this.out.getFileSystem(), this.out.getConf(), cs).withTableConfiguration(acuconf).withStartDisabled().build(), this.visCacheSize);
    }

    @Override
    public RFile.WriterOptions withFileSystem(FileSystem fs) {
        Objects.requireNonNull(fs);
        this.out.fs = fs;
        return this;
    }

    @Override
    public RFile.WriterFSOptions to(String filename) {
        Objects.requireNonNull(filename);
        this.out = new OutputArgs(filename);
        return this;
    }

    @Override
    public RFile.WriterOptions to(OutputStream out) {
        Objects.requireNonNull(out);
        this.out = new OutputArgs(out);
        return this;
    }

    @Override
    public RFile.WriterOptions withTableProperties(Iterable<Map.Entry<String, String>> tableConfig) {
        Objects.requireNonNull(tableConfig);
        HashMap<String, String> cfg = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : tableConfig) {
            cfg.put(entry.getKey(), entry.getValue());
        }
        this.checkDisjoint(cfg, this.samplerProps, "sampler");
        this.checkDisjoint(cfg, this.summarizerProps, "summarizer");
        this.tableConfig = cfg;
        return this;
    }

    @Override
    public RFile.WriterOptions withTableProperties(Map<String, String> tableConfig) {
        Objects.requireNonNull(tableConfig);
        return this.withTableProperties(tableConfig.entrySet());
    }

    @Override
    public RFile.WriterOptions withVisibilityCacheSize(int maxSize) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0);
        this.visCacheSize = maxSize;
        return this;
    }

    @Override
    public RFile.WriterOptions withSummarizers(SummarizerConfiguration ... summarizerConf) {
        Objects.requireNonNull(summarizerConf);
        Map<String, String> tmp = SummarizerConfiguration.toTableProperties(summarizerConf);
        this.checkDisjoint(this.tableConfig, tmp, "summarizer");
        this.summarizerProps = tmp;
        return this;
    }

    private static class OutputArgs
    extends FSConfArgs {
        private Path path;
        private OutputStream out;

        OutputArgs(String filename) {
            this.path = new Path(filename);
        }

        OutputArgs(OutputStream out) {
            this.out = out;
        }

        OutputStream getOutputStream() {
            return this.out;
        }
    }
}

