/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.ActiveCompactionIterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ListCompactionsCommand
extends Shell.Command {
    private Option tserverOption;
    private Option disablePaginationOpt;
    private Option filterOption;

    @Override
    public String description() {
        return "lists what compactions are currently running in accumulo. See the accumulo.core.client.admin.ActiveCompaciton javadoc for more information about columns.";
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        ArrayList<String> tservers;
        boolean paginate;
        String filterText = null;
        InstanceOperations instanceOps = shellState.getAccumuloClient().instanceOperations();
        boolean bl = paginate = !cl.hasOption(this.disablePaginationOpt.getOpt());
        if (cl.hasOption(this.tserverOption.getOpt())) {
            tservers = new ArrayList<String>();
            tservers.add(cl.getOptionValue(this.tserverOption.getOpt()));
        } else {
            tservers = instanceOps.getTabletServers();
        }
        if (cl.hasOption(this.filterOption.getOpt())) {
            filterText = ".*" + cl.getOptionValue(this.filterOption.getOpt()) + ".*";
        }
        ActiveCompactionIterator activeCompactionIterator = new ActiveCompactionIterator(tservers, instanceOps);
        if (filterText != null) {
            String finalFilterText = filterText;
            activeCompactionIterator = Iterators.filter((Iterator)activeCompactionIterator, t -> t.matches(finalFilterText));
        }
        shellState.printLines(activeCompactionIterator, paginate);
        return 0;
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        this.filterOption = new Option("f", "filter", true, "show only compactions that match the regex");
        opts.addOption(this.filterOption);
        this.tserverOption = new Option("ts", "tabletServer", true, "tablet server to list compactions for");
        this.tserverOption.setArgName("tablet server");
        opts.addOption(this.tserverOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        opts.addOption(this.disablePaginationOpt);
        return opts;
    }
}

