/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class DeleteCommand
extends Shell.Command {
    private Option deleteOptAuths;
    private Option timestampOpt;
    private Option timeoutOption;

    protected long getTimeout(CommandLine cl) {
        if (cl.hasOption(this.timeoutOption.getLongOpt())) {
            return ConfigurationTypeHelper.getTimeInMillis((String)cl.getOptionValue(this.timeoutOption.getLongOpt()));
        }
        return Long.MAX_VALUE;
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException, ConstraintViolationException {
        shellState.checkTableState();
        Mutation m = new Mutation(new Text(cl.getArgs()[0].getBytes(Shell.CHARSET)));
        Text colf = new Text(cl.getArgs()[1].getBytes(Shell.CHARSET));
        Text colq = new Text(cl.getArgs()[2].getBytes(Shell.CHARSET));
        if (cl.hasOption(this.deleteOptAuths.getOpt())) {
            ColumnVisibility le = new ColumnVisibility(cl.getOptionValue(this.deleteOptAuths.getOpt()));
            if (cl.hasOption(this.timestampOpt.getOpt())) {
                m.putDelete(colf, colq, le, Long.parseLong(cl.getOptionValue(this.timestampOpt.getOpt())));
            } else {
                m.putDelete(colf, colq, le);
            }
        } else if (cl.hasOption(this.timestampOpt.getOpt())) {
            m.putDelete(colf, colq, Long.parseLong(cl.getOptionValue(this.timestampOpt.getOpt())));
        } else {
            m.putDelete(colf, colq);
        }
        BatchWriter bw = shellState.getAccumuloClient().createBatchWriter(shellState.getTableName(), new BatchWriterConfig().setMaxMemory(Math.max(m.estimatedMemoryUsed(), 1024L)).setMaxWriteThreads(1).setTimeout(this.getTimeout(cl), TimeUnit.MILLISECONDS));
        bw.addMutation(m);
        bw.close();
        return 0;
    }

    @Override
    public String description() {
        return "deletes a record from a table";
    }

    @Override
    public String usage() {
        return this.getName() + " <row> <colfamily> <colqualifier>";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.deleteOptAuths = new Option("l", "visibility-label", true, "formatted visibility");
        this.deleteOptAuths.setArgName("expression");
        o.addOption(this.deleteOptAuths);
        this.timestampOpt = new Option("ts", "timestamp", true, "timestamp to use for deletion");
        this.timestampOpt.setArgName("timestamp");
        o.addOption(this.timestampOpt);
        this.timeoutOption = new Option(null, "timeout", true, "time before insert should fail if no data is written. If no unit is given assumes seconds. Units d,h,m,s,and ms are supported. e.g. 30s or 100ms");
        this.timeoutOption.setArgName("timeout");
        o.addOption(this.timeoutOption);
        return o;
    }

    @Override
    public int numArgs() {
        return 3;
    }
}

