/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.compaction.CompactionSettings;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellUtil;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.accumulo.shell.commands.ScanCommand;
import org.apache.accumulo.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CompactCommand
extends TableOperation {
    private Option noFlushOption;
    private Option waitOpt;
    private Option profileOpt;
    private Option cancelOpt;
    private Option strategyOpt;
    private Option strategyConfigOpt;
    private Option enameOption;
    private Option epathOption;
    private Option sizeLtOption;
    private Option sizeGtOption;
    private Option minFilesOption;
    private Option outBlockSizeOpt;
    private Option outHdfsBlockSizeOpt;
    private Option outIndexBlockSizeOpt;
    private Option outCompressionOpt;
    private Option outReplication;
    private Option enoSampleOption;
    private Option extraSummaryOption;
    private Option enoSummaryOption;
    private CompactionConfig compactionConfig = null;
    private boolean cancel = false;

    @Override
    public String description() {
        return "Initiates a major compaction on tablets within the specified range that have one or more files. If no file selection options are specified, then all files will be compacted. Options that configure output settings are only applied to this compaction and not later compactions. If multiple concurrent user initiated compactions specify iterators or a compaction strategy, then all but one will fail to start.";
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException {
        if (this.cancel) {
            try {
                shellState.getAccumuloClient().tableOperations().cancelCompaction(tableName);
                Shell.log.info("Compaction canceled for table {}", (Object)tableName);
            }
            catch (TableNotFoundException e) {
                throw new AccumuloException((Throwable)e);
            }
        }
        try {
            if (this.compactionConfig.getWait()) {
                Shell.log.info("Compacting table ...");
            }
            for (IteratorSetting iteratorSetting : this.compactionConfig.getIterators()) {
                ScanCommand.ensureTserversCanLoadIterator(shellState, tableName, iteratorSetting.getIteratorClass());
            }
            shellState.getAccumuloClient().tableOperations().compact(tableName, this.compactionConfig);
            Shell.log.info("Compaction of table {} {} for given range", (Object)tableName, (Object)(this.compactionConfig.getWait() ? "completed" : "started"));
        }
        catch (Exception ex) {
            throw new AccumuloException((Throwable)ex);
        }
    }

    private void put(CommandLine cl, Map<String, String> opts, Option opt, CompactionSettings setting) {
        if (cl.hasOption(opt.getLongOpt())) {
            setting.put(opts, cl.getOptionValue(opt.getLongOpt()));
        }
    }

    private Map<String, String> getConfigurableCompactionStrategyOpts(CommandLine cl) {
        HashMap<String, String> opts = new HashMap<String, String>();
        this.put(cl, opts, this.extraSummaryOption, CompactionSettings.SF_EXTRA_SUMMARY);
        this.put(cl, opts, this.enoSummaryOption, CompactionSettings.SF_NO_SUMMARY);
        this.put(cl, opts, this.enoSampleOption, CompactionSettings.SF_NO_SAMPLE);
        this.put(cl, opts, this.enameOption, CompactionSettings.SF_NAME_RE_OPT);
        this.put(cl, opts, this.epathOption, CompactionSettings.SF_PATH_RE_OPT);
        this.put(cl, opts, this.sizeLtOption, CompactionSettings.SF_LT_ESIZE_OPT);
        this.put(cl, opts, this.sizeGtOption, CompactionSettings.SF_GT_ESIZE_OPT);
        this.put(cl, opts, this.minFilesOption, CompactionSettings.MIN_FILES_OPT);
        this.put(cl, opts, this.outCompressionOpt, CompactionSettings.OUTPUT_COMPRESSION_OPT);
        this.put(cl, opts, this.outBlockSizeOpt, CompactionSettings.OUTPUT_BLOCK_SIZE_OPT);
        this.put(cl, opts, this.outHdfsBlockSizeOpt, CompactionSettings.OUTPUT_HDFS_BLOCK_SIZE_OPT);
        this.put(cl, opts, this.outIndexBlockSizeOpt, CompactionSettings.OUTPUT_INDEX_BLOCK_SIZE_OPT);
        this.put(cl, opts, this.outReplication, CompactionSettings.OUTPUT_REPLICATION_OPT);
        return opts;
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        CompactionStrategyConfig csc;
        if (cl.hasOption(this.cancelOpt.getLongOpt())) {
            this.cancel = true;
            if (cl.getOptions().length > 2) {
                throw new IllegalArgumentException("Can not specify other options with cancel");
            }
        } else {
            this.cancel = false;
        }
        this.compactionConfig = new CompactionConfig();
        this.compactionConfig.setFlush(!cl.hasOption(this.noFlushOption.getOpt()));
        this.compactionConfig.setWait(cl.hasOption(this.waitOpt.getOpt()));
        this.compactionConfig.setStartRow(OptUtil.getStartRow(cl));
        this.compactionConfig.setEndRow(OptUtil.getEndRow(cl));
        if (cl.hasOption(this.profileOpt.getOpt())) {
            List<IteratorSetting> iterators = shellState.iteratorProfiles.get(cl.getOptionValue(this.profileOpt.getOpt()));
            if (iterators == null) {
                Shell.log.error("Profile {} does not exist", (Object)cl.getOptionValue(this.profileOpt.getOpt()));
                return -1;
            }
            this.compactionConfig.setIterators(new ArrayList<IteratorSetting>(iterators));
        }
        Map<String, String> configurableCompactOpt = this.getConfigurableCompactionStrategyOpts(cl);
        if (cl.hasOption(this.strategyOpt.getOpt())) {
            if (configurableCompactOpt.size() > 0) {
                throw new IllegalArgumentException("Can not specify compaction strategy with file selection and file output options.");
            }
            csc = new CompactionStrategyConfig(cl.getOptionValue(this.strategyOpt.getOpt()));
            csc.setOptions(ShellUtil.parseMapOpt(cl, this.strategyConfigOpt));
            this.compactionConfig.setCompactionStrategy(csc);
        }
        if (configurableCompactOpt.size() > 0) {
            csc = new CompactionStrategyConfig("org.apache.accumulo.tserver.compaction.strategies.ConfigurableCompactionStrategy");
            csc.setOptions(configurableCompactOpt);
            this.compactionConfig.setCompactionStrategy(csc);
        }
        return super.execute(fullCommand, cl, shellState);
    }

    private Option newLAO(String lopt, String desc) {
        return new Option(null, lopt, true, desc);
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption(OptUtil.startRowOpt());
        opts.addOption(OptUtil.endRowOpt());
        this.noFlushOption = new Option("nf", "noFlush", false, "do not flush table data in memory before compacting.");
        opts.addOption(this.noFlushOption);
        this.waitOpt = new Option("w", "wait", false, "wait for compact to finish");
        opts.addOption(this.waitOpt);
        this.profileOpt = new Option("pn", "profile", true, "Iterator profile name.");
        this.profileOpt.setArgName("profile");
        opts.addOption(this.profileOpt);
        this.strategyOpt = new Option("s", "strategy", true, "compaction strategy class name");
        opts.addOption(this.strategyOpt);
        this.strategyConfigOpt = new Option("sc", "strategyConfig", true, "Key value options for compaction strategy.  Expects <prop>=<value>{,<prop>=<value>}");
        opts.addOption(this.strategyConfigOpt);
        this.cancelOpt = new Option(null, "cancel", false, "cancel user initiated compactions");
        opts.addOption(this.cancelOpt);
        this.enoSummaryOption = new Option(null, "sf-no-summary", false, "Select files that do not have the summaries specified in the table configuration.");
        opts.addOption(this.enoSummaryOption);
        this.extraSummaryOption = new Option(null, "sf-extra-summary", false, "Select files that have summary information which exceeds the tablets boundries.");
        opts.addOption(this.extraSummaryOption);
        this.enoSampleOption = new Option(null, "sf-no-sample", false, "Select files that have no sample data or sample data that differes from the table configuration.");
        opts.addOption(this.enoSampleOption);
        this.enameOption = this.newLAO("sf-ename", "Select files using regular expression to match file names. Only matches against last part of path.");
        opts.addOption(this.enameOption);
        this.epathOption = this.newLAO("sf-epath", "Select files using regular expression to match file paths to compact. Matches against full path.");
        opts.addOption(this.epathOption);
        this.sizeLtOption = this.newLAO("sf-lt-esize", "Selects files less than specified size.  Uses the estimated size of file in metadata table. Can use K,M, and G suffixes");
        opts.addOption(this.sizeLtOption);
        this.sizeGtOption = this.newLAO("sf-gt-esize", "Selects files greater than specified size. Uses the estimated size of file in metadata table. Can use K,M, and G suffixes");
        opts.addOption(this.sizeGtOption);
        this.minFilesOption = this.newLAO("min-files", "Only compacts if at least the specified number of files are selected. When no file selection criteria are given, all files are selected.");
        opts.addOption(this.minFilesOption);
        this.outBlockSizeOpt = this.newLAO("out-data-bs", "Rfile data block size to use for compaction output file. Can use K,M, and G suffixes. Uses table settings if not specified.");
        opts.addOption(this.outBlockSizeOpt);
        this.outHdfsBlockSizeOpt = this.newLAO("out-hdfs-bs", "HDFS block size to use for compaction output file. Can use K,M, and G suffixes. Uses table settings if not specified.");
        opts.addOption(this.outHdfsBlockSizeOpt);
        this.outIndexBlockSizeOpt = this.newLAO("out-index-bs", "Rfile index block size to use for compaction output file. Can use K,M, and G suffixes. Uses table settings if not specified.");
        opts.addOption(this.outIndexBlockSizeOpt);
        this.outCompressionOpt = this.newLAO("out-compress", "Compression to use for compaction output file. Either snappy, gz, lzo, or none. Uses table settings if not specified.");
        opts.addOption(this.outCompressionOpt);
        this.outReplication = this.newLAO("out-replication", "HDFS replication to use for compaction output file. Uses table settings if not specified.");
        opts.addOption(this.outReplication);
        return opts;
    }
}

