/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;

public class AuthenticateCommand
extends Shell.Command {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException {
        String user = cl.getArgs()[0];
        String p = shellState.readMaskedLine("Enter current password for '" + user + "': ", Character.valueOf('*'));
        if (p == null) {
            shellState.getReader().println();
            return 0;
        }
        byte[] password = p.getBytes(StandardCharsets.UTF_8);
        boolean valid = shellState.getAccumuloClient().securityOperations().authenticateUser(user, (AuthenticationToken)new PasswordToken(password));
        shellState.getReader().println((CharSequence)((valid ? "V" : "Not v") + "alid"));
        return 0;
    }

    @Override
    public String description() {
        return "verifies a user's credentials";
    }

    @Override
    public String usage() {
        return this.getName() + " <username>";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        this.registerCompletionForUsers(root, completionSet);
    }

    @Override
    public int numArgs() {
        return 1;
    }
}

