/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.MasterClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.gc.thrift.GCMonitorService;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.monitor.EmbeddedWebServer;
import org.apache.accumulo.monitor.ZooKeeperStatus;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.HighlyAvailableService;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.monitor.LogService;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.TableInfoUtil;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor
extends AbstractServer
implements HighlyAvailableService {
    private static final Logger log = LoggerFactory.getLogger(Monitor.class);
    private static final int REFRESH_TIME = 5;
    private final long START_TIME;
    private final AtomicLong lastRecalc = new AtomicLong(0L);
    private double totalIngestRate = 0.0;
    private double totalQueryRate = 0.0;
    private double totalScanRate = 0.0;
    private long totalEntries = 0L;
    private int totalTabletCount = 0;
    private long totalHoldTime = 0L;
    private long totalLookups = 0L;
    private int totalTables = 0;
    private final AtomicBoolean monitorInitialized = new AtomicBoolean(false);
    private final List<Pair<Long, Double>> loadOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> ingestRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> ingestByteRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Integer>> minorCompactionsOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Integer>> majorCompactionsOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> lookupsOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Integer>> queryRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Integer>> scanRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> queryByteRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> indexCacheHitRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> dataCacheHitRateOverTime = Monitor.newMaxList();
    private EventCounter lookupRateTracker = new EventCounter();
    private EventCounter indexCacheHitTracker = new EventCounter();
    private EventCounter indexCacheRequestTracker = new EventCounter();
    private EventCounter dataCacheHitTracker = new EventCounter();
    private EventCounter dataCacheRequestTracker = new EventCounter();
    private final AtomicBoolean fetching = new AtomicBoolean(false);
    private MasterMonitorInfo mmi;
    private Map<TableId, Map<ProblemType, Integer>> problemSummary = Collections.emptyMap();
    private Exception problemException;
    private GCStatus gcStatus;
    private EmbeddedWebServer server;
    private ZooLock monitorLock;
    private final Map<HostAndPort, ScanStats> allScans = new HashMap<HostAndPort, ScanStats>();

    public static void main(String[] args) throws Exception {
        try (Monitor monitor = new Monitor(new ServerOpts(), args);){
            monitor.runServer();
        }
    }

    Monitor(ServerOpts opts, String[] args) {
        super("monitor", opts, args);
        this.START_TIME = System.currentTimeMillis();
    }

    private static <T> List<Pair<Long, T>> newMaxList() {
        return Collections.synchronizedList(new LinkedList<Pair<Long, T>>(){
            private static final long serialVersionUID = 1L;
            private final long maxDelta = 3600000L;

            @Override
            public boolean add(Pair<Long, T> obj) {
                boolean result = super.add(obj);
                if ((Long)obj.getFirst() - (Long)((Pair)this.get(0)).getFirst() > 3600000L) {
                    this.remove(0);
                }
                return result;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchData() {
        ServerContext context = this.getContext();
        double totalIngestRate = 0.0;
        double totalIngestByteRate = 0.0;
        double totalQueryRate = 0.0;
        double totalQueryByteRate = 0.0;
        double totalScanRate = 0.0;
        long totalEntries = 0L;
        int totalTabletCount = 0;
        long totalHoldTime = 0L;
        long totalLookups = 0L;
        boolean retry = true;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRecalc.get() < 5000L) {
            return;
        }
        if (!this.fetching.compareAndSet(false, true)) {
            return;
        }
        try {
            while (retry) {
                MasterClientService.Client client = null;
                try {
                    client = MasterClient.getConnection((ClientContext)context);
                    if (client != null) {
                        this.mmi = client.getMasterStats(TraceUtil.traceInfo(), context.rpcCreds());
                        retry = false;
                    } else {
                        this.mmi = null;
                        log.error("Unable to get info from Master");
                    }
                    this.gcStatus = this.fetchGcStatus();
                }
                catch (Exception e) {
                    this.mmi = null;
                    log.info("Error fetching stats: ", (Throwable)e);
                }
                finally {
                    if (client != null) {
                        MasterClient.close((MasterClientService.Iface)client);
                    }
                }
                if (this.mmi != null) continue;
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            if (this.mmi != null) {
                int majorCompactions = 0;
                int minorCompactions = 0;
                this.lookupRateTracker.startingUpdates();
                this.indexCacheHitTracker.startingUpdates();
                this.indexCacheRequestTracker.startingUpdates();
                this.dataCacheHitTracker.startingUpdates();
                this.dataCacheRequestTracker.startingUpdates();
                for (Object server : this.mmi.tServerInfo) {
                    TableInfo summary = TableInfoUtil.summarizeTableStats((TabletServerStatus)server);
                    totalIngestRate += summary.ingestRate;
                    totalIngestByteRate += summary.ingestByteRate;
                    totalQueryRate += summary.queryRate;
                    totalScanRate += summary.scanRate;
                    totalQueryByteRate += summary.queryByteRate;
                    totalEntries += summary.recs;
                    totalHoldTime += ((TabletServerStatus)server).holdTime;
                    totalLookups += ((TabletServerStatus)server).lookups;
                    majorCompactions += summary.majors.running;
                    minorCompactions += summary.minors.running;
                    this.lookupRateTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).lookups);
                    this.indexCacheHitTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).indexCacheHits);
                    this.indexCacheRequestTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).indexCacheRequest);
                    this.dataCacheHitTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).dataCacheHits);
                    this.dataCacheRequestTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).dataCacheRequest);
                }
                this.lookupRateTracker.finishedUpdating();
                this.indexCacheHitTracker.finishedUpdating();
                this.indexCacheRequestTracker.finishedUpdating();
                this.dataCacheHitTracker.finishedUpdating();
                this.dataCacheRequestTracker.finishedUpdating();
                int totalTables = 0;
                for (TableInfo tInfo : this.mmi.tableMap.values()) {
                    totalTabletCount += tInfo.tablets;
                    ++totalTables;
                }
                this.totalIngestRate = totalIngestRate;
                this.totalTables = totalTables;
                totalIngestByteRate /= 1000000.0;
                this.totalQueryRate = totalQueryRate;
                this.totalScanRate = totalScanRate;
                totalQueryByteRate /= 1000000.0;
                this.totalEntries = totalEntries;
                this.totalTabletCount = totalTabletCount;
                this.totalHoldTime = totalHoldTime;
                this.totalLookups = totalLookups;
                this.ingestRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalIngestRate));
                this.ingestByteRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalIngestByteRate));
                double totalLoad = 0.0;
                for (TabletServerStatus status : this.mmi.tServerInfo) {
                    if (status == null) continue;
                    totalLoad += status.osLoad;
                }
                this.loadOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalLoad));
                this.minorCompactionsOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)minorCompactions));
                this.majorCompactionsOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)majorCompactions));
                this.lookupsOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)this.lookupRateTracker.calculateRate()));
                this.queryRateOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)((int)totalQueryRate)));
                this.queryByteRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalQueryByteRate));
                this.scanRateOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)((int)totalScanRate)));
                Monitor.calcCacheHitRate(this.indexCacheHitRateOverTime, currentTime, this.indexCacheHitTracker, this.indexCacheRequestTracker);
                Monitor.calcCacheHitRate(this.dataCacheHitRateOverTime, currentTime, this.dataCacheHitTracker, this.dataCacheRequestTracker);
            }
            try {
                this.problemSummary = ProblemReports.getInstance((ServerContext)context).summarize();
                this.problemException = null;
            }
            catch (Exception e) {
                log.info("Failed to obtain problem reports ", (Throwable)e);
                this.problemSummary = Collections.emptyMap();
                this.problemException = e;
            }
        }
        finally {
            this.lastRecalc.set(currentTime);
            if (!this.fetching.compareAndSet(true, false)) {
                throw new AssertionError((Object)"Not supposed to happen; somebody broke this code");
            }
        }
    }

    private static void calcCacheHitRate(List<Pair<Long, Double>> hitRate, long currentTime, EventCounter cacheHits, EventCounter cacheReq) {
        long req = cacheReq.calculateCount();
        if (req > 0L) {
            hitRate.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)((double)cacheHits.calculateCount() / (double)cacheReq.calculateCount())));
        } else {
            hitRate.add((Pair<Long, Double>)new Pair((Object)currentTime, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GCStatus fetchGcStatus() {
        GCStatus result;
        block5: {
            ServerContext context = this.getContext();
            result = null;
            HostAndPort address = null;
            try {
                ZooReaderWriter zk = context.getZooReaderWriter();
                String path = context.getZooKeeperRoot() + "/gc/lock";
                List locks = zk.getChildren(path, null);
                if (locks == null || locks.size() <= 0) break block5;
                Collections.sort(locks);
                address = new ServerServices(new String(zk.getData(path + "/" + (String)locks.get(0), null), StandardCharsets.UTF_8)).getAddress(ServerServices.Service.GC_CLIENT);
                GCMonitorService.Client client = (GCMonitorService.Client)ThriftUtil.getClient((TServiceClientFactory)new GCMonitorService.Client.Factory(), (HostAndPort)address, (ClientContext)context);
                try {
                    result = client.getStatus(TraceUtil.traceInfo(), context.rpcCreds());
                }
                finally {
                    ThriftUtil.returnClient((TServiceClient)client);
                }
            }
            catch (Exception ex) {
                log.warn("Unable to contact the garbage collector at " + address, (Throwable)ex);
            }
        }
        return result;
    }

    public void run() {
        int[] ports;
        ServerContext context = this.getContext();
        for (int port : ports = this.getConfiguration().getPort(Property.MONITOR_PORT)) {
            try {
                log.debug("Creating monitor on port {}", (Object)port);
                this.server = new EmbeddedWebServer(this, port);
                this.server.addServlet(this.getDefaultServlet(), "/resources/*");
                this.server.addServlet(this.getRestServlet(), "/rest/*");
                this.server.addServlet(this.getViewServlet(), "/*");
                this.server.start();
                break;
            }
            catch (Throwable ex) {
                log.error("Unable to start embedded web server", ex);
            }
        }
        if (!this.server.isRunning()) {
            throw new RuntimeException("Unable to start embedded web server on ports: " + Arrays.toString(ports));
        }
        try {
            this.getMonitorLock();
        }
        catch (Exception e) {
            log.error("Failed to get Monitor ZooKeeper lock");
            throw new RuntimeException(e);
        }
        String advertiseHost = this.getHostname();
        if (advertiseHost.equals("0.0.0.0")) {
            try {
                advertiseHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.error("Unable to get hostname", (Throwable)e);
            }
        }
        log.debug("Using {} to advertise monitor location in ZooKeeper", (Object)advertiseHost);
        try {
            String monitorAddress = HostAndPort.fromParts((String)advertiseHost, (int)this.server.getPort()).toString();
            context.getZooReaderWriter().putPersistentData(context.getZooKeeperRoot() + "/monitor/http_addr", monitorAddress.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
            log.info("Set monitor address in zookeeper to {}", (Object)monitorAddress);
        }
        catch (Exception ex) {
            log.error("Unable to set monitor HTTP address in zookeeper", (Throwable)ex);
        }
        if (advertiseHost != null) {
            LogService.startLogListener((ServerContext)context, (String)advertiseHost);
        } else {
            log.warn("Not starting log4j listener as we could not determine address to use");
        }
        new Daemon((Runnable)new LoggingRunnable(log, (Runnable)new ZooKeeperStatus(context)), "ZooKeeperStatus").start();
        new Daemon((Runnable)new LoggingRunnable(log, () -> {
            while (true) {
                try {
                    this.fetchData();
                }
                catch (Exception e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                }
                UtilWaitThread.sleepUninterruptibly((long)333L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }), "Data fetcher").start();
        new Daemon((Runnable)new LoggingRunnable(log, () -> {
            while (true) {
                try {
                    this.fetchScans();
                }
                catch (Exception e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                }
                UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
        }), "Scan scanner").start();
        this.monitorInitialized.set(true);
    }

    private ServletHolder getDefaultServlet() {
        return new ServletHolder((Servlet)new DefaultServlet(){
            private static final long serialVersionUID = 1L;

            public Resource getResource(String pathInContext) {
                return Resource.newClassPathResource((String)("/org/apache/accumulo/monitor" + pathInContext));
            }
        });
    }

    private ServletHolder getViewServlet() {
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"org.apache.accumulo.monitor.view"}).register((Object)new MonitorFactory(this)).register((Object)new LoggingFeature(java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName()))).register(FreemarkerMvcFeature.class).property("jersey.config.server.mvc.templateBasePath", (Object)"/org/apache/accumulo/monitor/templates");
        return new ServletHolder((Servlet)new ServletContainer(rc));
    }

    private ServletHolder getRestServlet() {
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"org.apache.accumulo.monitor.rest"}).register((Object)new MonitorFactory(this)).register((Object)new LoggingFeature(java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName()))).register(JacksonFeature.class);
        return new ServletHolder((Servlet)new ServletContainer(rc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<HostAndPort, ScanStats> getScans() {
        Map<HostAndPort, ScanStats> map = this.allScans;
        synchronized (map) {
            return new HashMap<HostAndPort, ScanStats>(this.allScans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchScans() throws Exception {
        ServerContext context = this.getContext();
        for (String server : context.instanceOperations().getTabletServers()) {
            HostAndPort parsedServer = HostAndPort.fromString((String)server);
            TabletClientService.Client tserver = ThriftUtil.getTServerClient((HostAndPort)parsedServer, (ClientContext)context);
            try {
                List scans = tserver.getActiveScans(null, context.rpcCreds());
                Map<HostAndPort, ScanStats> map = this.allScans;
                synchronized (map) {
                    this.allScans.put(parsedServer, new ScanStats(scans));
                }
            }
            catch (Exception ex) {
                log.debug("Failed to get active scans from {}", (Object)server, (Object)ex);
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)tserver);
            }
        }
        Iterator<Map.Entry<HostAndPort, ScanStats>> entryIter = this.allScans.entrySet().iterator();
        long now = System.currentTimeMillis();
        while (entryIter.hasNext()) {
            Map.Entry<HostAndPort, ScanStats> entry = entryIter.next();
            if (now - entry.getValue().fetched <= 300000L) continue;
            entryIter.remove();
        }
    }

    private void getMonitorLock() throws KeeperException, InterruptedException {
        ServerContext context = this.getContext();
        String zRoot = context.getZooKeeperRoot();
        String monitorPath = zRoot + "/monitor";
        String monitorLockPath = zRoot + "/monitor/lock";
        ZooReaderWriter zoo = context.getZooReaderWriter();
        if (zoo.exists(monitorPath)) {
            byte[] data = zoo.getData(monitorPath, null);
            if (data.length != 0) {
                zoo.recursiveDelete(monitorPath, ZooUtil.NodeMissingPolicy.SKIP);
                zoo.putPersistentData(monitorPath, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
                zoo.putPersistentData(monitorLockPath, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            } else if (!zoo.exists(monitorLockPath)) {
                zoo.putPersistentData(monitorLockPath, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            }
        } else {
            zoo.putPersistentData(zRoot + "/monitor", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            if (!zoo.exists(monitorLockPath)) {
                zoo.putPersistentData(monitorLockPath, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            }
        }
        while (true) {
            MoniterLockWatcher monitorLockWatcher = new MoniterLockWatcher();
            this.monitorLock = new ZooLock(zoo, monitorLockPath);
            this.monitorLock.lockAsync((ZooLock.AsyncLockWatcher)monitorLockWatcher, new byte[0]);
            monitorLockWatcher.waitForChange();
            if (monitorLockWatcher.acquiredLock) break;
            if (!monitorLockWatcher.failedToAcquireLock) {
                throw new IllegalStateException("monitor lock in unknown state");
            }
            this.monitorLock.tryToCancelAsyncLockOrUnlock();
            UtilWaitThread.sleepUninterruptibly((long)context.getConfiguration().getTimeInMillis(Property.MONITOR_LOCK_CHECK_INTERVAL), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        log.info("Got Monitor lock.");
    }

    public MasterMonitorInfo getMmi() {
        return this.mmi;
    }

    public int getTotalTables() {
        return this.totalTables;
    }

    public int getTotalTabletCount() {
        return this.totalTabletCount;
    }

    public long getTotalEntries() {
        return this.totalEntries;
    }

    public double getTotalIngestRate() {
        return this.totalIngestRate;
    }

    public double getTotalQueryRate() {
        return this.totalQueryRate;
    }

    public double getTotalScanRate() {
        return this.totalScanRate;
    }

    public long getTotalHoldTime() {
        return this.totalHoldTime;
    }

    public Exception getProblemException() {
        return this.problemException;
    }

    public Map<TableId, Map<ProblemType, Integer>> getProblemSummary() {
        return this.problemSummary;
    }

    public GCStatus getGcStatus() {
        return this.gcStatus;
    }

    public long getTotalLookups() {
        return this.totalLookups;
    }

    public long getStartTime() {
        return this.START_TIME;
    }

    public List<Pair<Long, Double>> getLoadOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.loadOverTime);
    }

    public List<Pair<Long, Double>> getIngestRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.ingestRateOverTime);
    }

    public List<Pair<Long, Double>> getIngestByteRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.ingestByteRateOverTime);
    }

    public List<Pair<Long, Integer>> getMinorCompactionsOverTime() {
        return new ArrayList<Pair<Long, Integer>>(this.minorCompactionsOverTime);
    }

    public List<Pair<Long, Integer>> getMajorCompactionsOverTime() {
        return new ArrayList<Pair<Long, Integer>>(this.majorCompactionsOverTime);
    }

    public List<Pair<Long, Double>> getLookupsOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.lookupsOverTime);
    }

    public double getLookupRate() {
        return this.lookupRateTracker.calculateRate();
    }

    public List<Pair<Long, Integer>> getQueryRateOverTime() {
        return new ArrayList<Pair<Long, Integer>>(this.queryRateOverTime);
    }

    public List<Pair<Long, Integer>> getScanRateOverTime() {
        return new ArrayList<Pair<Long, Integer>>(this.scanRateOverTime);
    }

    public List<Pair<Long, Double>> getQueryByteRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.queryByteRateOverTime);
    }

    public List<Pair<Long, Double>> getIndexCacheHitRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.indexCacheHitRateOverTime);
    }

    public List<Pair<Long, Double>> getDataCacheHitRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.dataCacheHitRateOverTime);
    }

    public boolean isActiveService() {
        return this.monitorInitialized.get();
    }

    private static class MoniterLockWatcher
    implements ZooLock.AsyncLockWatcher {
        boolean acquiredLock = false;
        boolean failedToAcquireLock = false;

        private MoniterLockWatcher() {
        }

        public void lostLock(ZooLock.LockLossReason reason) {
            Halt.halt((String)("Monitor lock in zookeeper lost (reason = " + reason + "), exiting!"), (int)-1);
        }

        public void unableToMonitorLockNode(Throwable e) {
            Halt.halt((int)-1, () -> log.error("No longer able to monitor Monitor lock node", e));
        }

        public synchronized void acquiredLock() {
            if (this.acquiredLock || this.failedToAcquireLock) {
                Halt.halt((String)("Zoolock in unexpected state AL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
            }
            this.acquiredLock = true;
            this.notifyAll();
        }

        public synchronized void failedToAcquireLock(Exception e) {
            log.warn("Failed to get monitor lock " + e);
            if (this.acquiredLock) {
                Halt.halt((String)("Zoolock in unexpected state FAL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
            }
            this.failedToAcquireLock = true;
            this.notifyAll();
        }

        public synchronized void waitForChange() {
            while (!this.acquiredLock && !this.failedToAcquireLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class ScanStats {
        public final long scanCount;
        public final Long oldestScan;
        public final long fetched;

        ScanStats(List<ActiveScan> active) {
            this.scanCount = active.size();
            long oldest = -1L;
            for (ActiveScan scan : active) {
                oldest = Math.max(oldest, scan.age);
            }
            this.oldestScan = oldest < 0L ? null : Long.valueOf(oldest);
            this.fetched = System.currentTimeMillis();
        }
    }

    public static class MonitorFactory
    extends AbstractBinder
    implements Factory<Monitor> {
        private final Monitor monitor;

        public MonitorFactory(Monitor monitor) {
            this.monitor = monitor;
        }

        public Monitor provide() {
            return this.monitor;
        }

        public void dispose(Monitor instance) {
        }

        protected void configure() {
            this.bindFactory(this).to(Monitor.class).in(Singleton.class);
        }
    }

    private class EventCounter {
        Map<String, Pair<Long, Long>> prevSamples = new HashMap<String, Pair<Long, Long>>();
        Map<String, Pair<Long, Long>> samples = new HashMap<String, Pair<Long, Long>>();
        Set<String> serversUpdated = new HashSet<String>();

        private EventCounter() {
        }

        void startingUpdates() {
            this.serversUpdated.clear();
        }

        void updateTabletServer(String name, long sampleTime, long numEvents) {
            Pair newSample = new Pair((Object)sampleTime, (Object)numEvents);
            Pair<Long, Long> lastSample = this.samples.get(name);
            if (lastSample == null || !lastSample.equals((Object)newSample)) {
                this.samples.put(name, (Pair<Long, Long>)newSample);
                if (lastSample != null) {
                    this.prevSamples.put(name, lastSample);
                }
            }
            this.serversUpdated.add(name);
        }

        void finishedUpdating() {
            this.samples.keySet().retainAll(this.serversUpdated);
            this.prevSamples.keySet().retainAll(this.serversUpdated);
        }

        double calculateRate() {
            double totalRate = 0.0;
            for (Map.Entry<String, Pair<Long, Long>> entry : this.prevSamples.entrySet()) {
                Pair<Long, Long> prevSample = entry.getValue();
                Pair<Long, Long> sample = this.samples.get(entry.getKey());
                totalRate += (double)((Long)sample.getSecond() - (Long)prevSample.getSecond()) / ((double)((Long)sample.getFirst() - (Long)prevSample.getFirst()) / 1000.0);
            }
            return totalRate;
        }

        long calculateCount() {
            long count = 0L;
            for (Map.Entry<String, Pair<Long, Long>> entry : this.prevSamples.entrySet()) {
                Pair<Long, Long> prevSample = entry.getValue();
                Pair<Long, Long> sample = this.samples.get(entry.getKey());
                count += (Long)sample.getSecond() - (Long)prevSample.getSecond();
            }
            return count;
        }
    }
}

