/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.performance;

import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.categories.PerformanceTests;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.mrit.IntegrationTestMapReduce;
import org.apache.accumulo.test.performance.ContinuousIngest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiniClusterOnlyTests.class, PerformanceTests.class})
public class RollWALPerformanceIT
extends ConfigurableMacBase {
    @BeforeClass
    public static void checkMR() {
        Assume.assumeFalse((boolean)IntegrationTestMapReduce.isMapReduce());
    }

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_WAL_REPLICATION, "1");
        cfg.setProperty(Property.TSERV_WALOG_MAX_SIZE, "5M");
        cfg.setProperty(Property.TSERV_WALOG_MAX_REFERENCED, "100");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.useMiniDFS(true);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 300;
    }

    private long ingest(AccumuloClient c) throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        log.info("Creating the table");
        c.tableOperations().create(tableName);
        log.info("Splitting the table");
        long SPLIT_COUNT = 100L;
        long distance = 92233720368547758L;
        TreeSet<Text> splits = new TreeSet<Text>();
        int i = 1;
        while ((long)i < 100L) {
            splits.add(new Text(String.format("%016x", (long)i * 92233720368547758L)));
            ++i;
        }
        c.tableOperations().addSplits(tableName, splits);
        log.info("Waiting for balance");
        c.instanceOperations().waitForBalance();
        log.info("Starting ingest");
        long start = System.nanoTime();
        ContinuousIngest.main(new String[]{"-c", this.cluster.getClientPropsPath(), "--table", tableName, "--num", Long.toString(50000L)});
        long result = System.nanoTime() - start;
        log.debug(String.format("Finished in %,d ns", result));
        log.debug("Dropping table");
        c.tableOperations().delete(tableName);
        return result;
    }

    private long getAverage(AccumuloClient c) throws Exception {
        int REPEAT = 3;
        long totalTime = 0L;
        for (int i = 0; i < 3; ++i) {
            totalTime += this.ingest(c);
        }
        return totalTime / 3L;
    }

    @Test
    public void testWalPerformanceOnce() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            long avg1 = this.getAverage(c);
            c.instanceOperations().setProperty(Property.TSERV_WALOG_MAX_SIZE.getKey(), "1G");
            c.tableOperations().flush(MetadataTable.NAME, null, null, true);
            c.tableOperations().flush(RootTable.NAME, null, null, true);
            this.getCluster().getClusterControl().stop(ServerType.TABLET_SERVER);
            this.getCluster().start();
            long avg2 = this.getAverage(c);
            log.info(String.format("Average run time with small WAL %,d with large WAL %,d", avg1, avg2));
            Assert.assertTrue((avg1 > avg2 ? 1 : 0) != 0);
            double percent = 100.0 * (double)avg1 / (double)avg2;
            log.info(String.format("Percent of large log: %.2f%%", percent));
        }
    }
}

