/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.master;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.master.state.MergeStats;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.accumulo.server.master.state.MetaDataStateStore;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class MergeStateIT
extends ConfigurableMacBase {
    private static void update(AccumuloClient c, Mutation m) throws TableNotFoundException, MutationsRejectedException {
        try (BatchWriter bw = c.createBatchWriter(MetadataTable.NAME);){
            bw.addMutation(m);
        }
    }

    @Test
    public void test() throws Exception {
        ServerContext context = this.getServerContext();
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            accumuloClient.securityOperations().grantTablePermission(accumuloClient.whoami(), MetadataTable.NAME, TablePermission.WRITE);
            BatchWriter bw = accumuloClient.createBatchWriter(MetadataTable.NAME, new BatchWriterConfig());
            String[] splits = new String[]{"a", "e", "j", "o", "t", "z"};
            TableId tableId = TableId.of((String)"t");
            Text pr = null;
            for (String s : splits) {
                Text split = new Text(s);
                Mutation prevRow = KeyExtent.getPrevRowUpdateMutation((KeyExtent)new KeyExtent(tableId, split, pr));
                prevRow.put(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, new Text("123456"), new Value("127.0.0.1:1234".getBytes()));
                MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.put(prevRow, new Value("junk".getBytes()));
                bw.addMutation(prevRow);
                pr = split;
            }
            Mutation defaultTablet = KeyExtent.getPrevRowUpdateMutation((KeyExtent)new KeyExtent(tableId, null, pr));
            defaultTablet.put(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, new Text("123456"), new Value("127.0.0.1:1234".getBytes()));
            bw.addMutation(defaultTablet);
            bw.close();
            MockCurrentState state = new MockCurrentState(new MergeInfo(new KeyExtent(tableId, new Text("p"), new Text("e")), MergeInfo.Operation.MERGE));
            MetaDataStateStore metaDataStateStore = new MetaDataStateStore((ClientContext)context, (CurrentState)state);
            int count = 0;
            for (TabletLocationState tss : metaDataStateStore) {
                if (tss == null) continue;
                ++count;
            }
            Assert.assertEquals((long)0L, (long)count);
            Mutation m = new KeyExtent(tableId, new Text("t"), new Text("p")).getPrevRowUpdateMutation();
            MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.put(m, new Value("0.5".getBytes()));
            MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow((Text)new Text("o")));
            MergeStateIT.update(accumuloClient, m);
            MergeStats stats = this.scan(state, metaDataStateStore);
            MergeState newState = stats.nextMergeState(accumuloClient, (CurrentState)state);
            Assert.assertEquals((Object)MergeState.WAITING_FOR_OFFLINE, (Object)newState);
            BatchDeleter deleter = accumuloClient.createBatchDeleter(MetadataTable.NAME, Authorizations.EMPTY, 1000, new BatchWriterConfig());
            deleter.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            deleter.setRanges(Collections.singletonList(new Range()));
            deleter.delete();
            stats = this.scan(state, metaDataStateStore);
            Assert.assertEquals((Object)MergeState.WAITING_FOR_OFFLINE, (Object)stats.nextMergeState(accumuloClient, (CurrentState)state));
            KeyExtent tablet = new KeyExtent(tableId, new Text("p"), new Text("o"));
            m = tablet.getPrevRowUpdateMutation();
            MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.put(m, new Value("0.5".getBytes()));
            MergeStateIT.update(accumuloClient, m);
            metaDataStateStore.setLocations(Collections.singletonList(new Assignment(tablet, state.someTServer)));
            stats = this.scan(state, metaDataStateStore);
            Assert.assertEquals((Object)MergeState.WAITING_FOR_CHOPPED, (Object)stats.nextMergeState(accumuloClient, (CurrentState)state));
            m = tablet.getPrevRowUpdateMutation();
            MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.put(m, new Value("junk".getBytes()));
            MergeStateIT.update(accumuloClient, m);
            stats = this.scan(state, metaDataStateStore);
            Assert.assertEquals((Object)MergeState.WAITING_FOR_OFFLINE, (Object)stats.nextMergeState(accumuloClient, (CurrentState)state));
            m = tablet.getPrevRowUpdateMutation();
            List walogs = Collections.emptyList();
            metaDataStateStore.unassign(Collections.singletonList(new TabletLocationState(tablet, null, state.someTServer, null, null, walogs, false)), null);
            stats = this.scan(state, metaDataStateStore);
            Assert.assertEquals((Object)MergeState.MERGING, (Object)stats.nextMergeState(accumuloClient, (CurrentState)state));
        }
    }

    private MergeStats scan(MockCurrentState state, MetaDataStateStore metaDataStateStore) {
        MergeStats stats = new MergeStats(state.mergeInfo);
        stats.getMergeInfo().setState(MergeState.WAITING_FOR_OFFLINE);
        for (TabletLocationState tss : metaDataStateStore) {
            stats.update(tss.extent, tss.getState(state.onlineTabletServers()), tss.chopped, false);
        }
        return stats;
    }

    private static class MockCurrentState
    implements CurrentState {
        TServerInstance someTServer = new TServerInstance(HostAndPort.fromParts((String)"127.0.0.1", (int)1234), 1193046L);
        MergeInfo mergeInfo;

        MockCurrentState(MergeInfo info) {
            this.mergeInfo = info;
        }

        public Set<TableId> onlineTables() {
            return Collections.singleton(TableId.of((String)"t"));
        }

        public Set<TServerInstance> onlineTabletServers() {
            return Collections.singleton(this.someTServer);
        }

        public Collection<MergeInfo> merges() {
            return Collections.singleton(this.mergeInfo);
        }

        public Set<KeyExtent> migrationsSnapshot() {
            return Collections.emptySet();
        }

        public MasterState getMasterState() {
            return MasterState.NORMAL;
        }

        public Set<TServerInstance> shutdownServers() {
            return Collections.emptySet();
        }
    }
}

