/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartStressIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(RestartStressIT.class);
    private ExecutorService svc;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map opts = cfg.getSiteConfig();
        opts.put(Property.TSERV_MAXMEM.getKey(), "100K");
        opts.put(Property.TSERV_MAJC_DELAY.getKey(), "100ms");
        opts.put(Property.TSERV_WALOG_MAX_SIZE.getKey(), "1M");
        opts.put(Property.INSTANCE_ZK_TIMEOUT.getKey(), "15s");
        opts.put(Property.MASTER_RECOVERY_DELAY.getKey(), "1s");
        cfg.setSiteConfig(opts);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 600;
    }

    @Before
    public void setup() {
        this.svc = Executors.newFixedThreadPool(1);
    }

    @After
    public void teardown() throws Exception {
        if (this.svc == null) {
            return;
        }
        if (!this.svc.isShutdown()) {
            this.svc.shutdown();
        }
        while (!this.svc.awaitTermination(10L, TimeUnit.SECONDS)) {
            log.info("Waiting for threadpool to terminate");
        }
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartStressIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "500K");
            ClusterControl control = RestartStressIT.getCluster().getClusterControl();
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartStressIT.getClientProps(), tableName, 10000);
            Future<Integer> retCode = this.svc.submit(() -> {
                try {
                    return control.exec(TestIngest.class, new String[]{"-c", cluster.getClientPropsPath(), "--rows", "" + params.rows, "--table", tableName});
                }
                catch (Exception e) {
                    log.error("Error running TestIngest", (Throwable)e);
                    return -1;
                }
            });
            for (int i = 0; i < 2; ++i) {
                UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
                control.stopAllServers(ServerType.TABLET_SERVER);
                control.startAllServers(ServerType.TABLET_SERVER);
            }
            Assert.assertEquals((long)0L, (long)retCode.get().intValue());
            VerifyIngest.verifyIngest(c, params);
        }
    }
}

