/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Map;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.junit.Test;

public class MasterFailoverIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.INSTANCE_ZK_TIMEOUT.getKey(), "15s");
        cfg.setSiteConfig(siteConfig);
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 90;
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(MasterFailoverIT.getClientProps()).build();){
            String[] names = this.getUniqueNames(2);
            c.tableOperations().create(names[0]);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(MasterFailoverIT.getClientProps(), names[0]);
            TestIngest.ingest(c, params);
            ClusterControl control = cluster.getClusterControl();
            control.stopAllServers(ServerType.MASTER);
            control.startAllServers(ServerType.MASTER);
            c.tableOperations().rename(names[0], names[1]);
            params.tableName = names[1];
            VerifyIngest.verifyIngest(c, params);
        }
    }
}

