/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalTimeIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(LogicalTimeIT.class);

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void run() throws Exception {
        int tc = 0;
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(LogicalTimeIT.getClientProps()).build();){
            this.runMergeTest(c, tableName + tc++, new String[]{"m"}, new String[]{"a"}, null, null, "b", 2L);
            this.runMergeTest(c, tableName + tc++, new String[]{"m"}, new String[]{"z"}, null, null, "b", 2L);
            this.runMergeTest(c, tableName + tc++, new String[]{"m"}, new String[]{"a", "z"}, null, null, "b", 2L);
            this.runMergeTest(c, tableName + tc++, new String[]{"m"}, new String[]{"a", "c", "z"}, null, null, "b", 3L);
            this.runMergeTest(c, tableName + tc++, new String[]{"m"}, new String[]{"a", "y", "z"}, null, null, "b", 3L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"a"}, null, null, "b", 2L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"h"}, null, null, "b", 2L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"s"}, null, null, "b", 2L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"a", "h", "s"}, null, null, "b", 2L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"a", "c", "h", "s"}, null, null, "b", 3L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"a", "h", "s", "i"}, null, null, "b", 3L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"t", "a", "h", "s"}, null, null, "b", 3L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"a"}, null, "h", "b", 2L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"h"}, null, "h", "b", 2L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"s"}, null, "h", "b", 1L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"a", "h", "s"}, null, "h", "b", 2L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"a", "c", "h", "s"}, null, "h", "b", 3L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"a", "h", "s", "i"}, null, "h", "b", 3L);
            this.runMergeTest(c, tableName + tc++, new String[]{"g", "r"}, new String[]{"t", "a", "h", "s"}, null, "h", "b", 2L);
        }
    }

    private void runMergeTest(AccumuloClient client, String table, String[] splits, String[] inserts, String start, String end, String last, long expected) throws Exception {
        log.info("table {}", (Object)table);
        client.tableOperations().create(table, new NewTableConfiguration().setTimeType(TimeType.LOGICAL));
        TreeSet<Text> splitSet = new TreeSet<Text>();
        for (String split : splits) {
            splitSet.add(new Text(split));
        }
        client.tableOperations().addSplits(table, splitSet);
        BatchWriter bw = client.createBatchWriter(table);
        for (String row : inserts) {
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"v");
            bw.addMutation(m);
        }
        bw.flush();
        client.tableOperations().merge(table, start == null ? null : new Text(start), end == null ? null : new Text(end));
        Mutation m = new Mutation((CharSequence)last);
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"v");
        bw.addMutation(m);
        bw.flush();
        try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
            scanner.setRange(new Range((CharSequence)last));
            bw.close();
            long time = ((Key)((Map.Entry)scanner.iterator().next()).getKey()).getTimestamp();
            if (time != expected) {
                throw new RuntimeException("unexpected time " + time + " " + expected);
            }
        }
    }
}

