/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiniClusterOnlyTests.class})
public class ClassLoaderIT
extends AccumuloClusterHarness {
    private static final long ZOOKEEPER_PROPAGATION_TIME = 10000L;
    private String rootPath;

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Before
    public void checkCluster() {
        Assume.assumeThat((Object)((Object)ClassLoaderIT.getClusterType()), (Matcher)CoreMatchers.is((Object)((Object)AccumuloClusterHarness.ClusterType.MINI)));
        MiniAccumuloClusterImpl mac = (MiniAccumuloClusterImpl)ClassLoaderIT.getCluster();
        this.rootPath = mac.getConfig().getDir().getAbsolutePath();
    }

    private static void copyStreamToFileSystem(FileSystem fs, String jarName, Path path) throws IOException {
        byte[] buffer = new byte[10240];
        try (FSDataOutputStream dest = fs.create(path);
             InputStream stream = ClassLoaderIT.class.getResourceAsStream(jarName);){
            int n;
            while ((n = stream.read(buffer, 0, buffer.length)) > 0) {
                dest.write(buffer, 0, n);
            }
        }
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ClassLoaderIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"row1");
                m.put((CharSequence)"cf", (CharSequence)"col1", (CharSequence)"Test");
                bw.addMutation(m);
            }
            this.scanCheck(c, tableName, "Test");
            FileSystem fs = ClassLoaderIT.getCluster().getFileSystem();
            Path jarPath = new Path(this.rootPath + "/lib/ext/Test.jar");
            ClassLoaderIT.copyStreamToFileSystem(fs, "/TestCombinerX.jar", jarPath);
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            IteratorSetting is = new IteratorSetting(10, "TestCombiner", "org.apache.accumulo.test.functional.TestCombiner");
            Combiner.setColumns((IteratorSetting)is, Collections.singletonList(new IteratorSetting.Column("cf")));
            c.tableOperations().attachIterator(tableName, is, EnumSet.of(IteratorUtil.IteratorScope.scan));
            UtilWaitThread.sleepUninterruptibly((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.scanCheck(c, tableName, "TestX");
            fs.delete(jarPath, true);
            ClassLoaderIT.copyStreamToFileSystem(fs, "/TestCombinerY.jar", jarPath);
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            this.scanCheck(c, tableName, "TestY");
            fs.delete(jarPath, true);
        }
    }

    private void scanCheck(AccumuloClient c, String tableName, String expected) throws Exception {
        try (Scanner bs = c.createScanner(tableName, Authorizations.EMPTY);){
            Iterator iterator = bs.iterator();
            Assert.assertTrue((boolean)iterator.hasNext());
            Map.Entry next = (Map.Entry)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            Assert.assertEquals((Object)expected, (Object)((Value)next.getValue()).toString());
        }
    }
}

