/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;

public class BasicSummarizer
implements Summarizer {
    public static final String DELETES_STAT = "deletes";
    public static final String MIN_TIMESTAMP_STAT = "minTimestamp";
    public static final String MAX_TIMESTAMP_STAT = "maxTimestamp";
    public static final String TOTAL_STAT = "total";

    public Summarizer.Collector collector(SummarizerConfiguration sc) {
        return new Summarizer.Collector(){
            private long minStamp = Long.MAX_VALUE;
            private long maxStamp = Long.MIN_VALUE;
            private long deletes = 0L;
            private long total = 0L;

            public void accept(Key k, Value v) {
                if (k.getTimestamp() < this.minStamp) {
                    this.minStamp = k.getTimestamp();
                }
                if (k.getTimestamp() > this.maxStamp) {
                    this.maxStamp = k.getTimestamp();
                }
                if (k.isDeleted()) {
                    ++this.deletes;
                }
                ++this.total;
            }

            public void summarize(Summarizer.StatisticConsumer sc) {
                sc.accept(BasicSummarizer.MIN_TIMESTAMP_STAT, this.minStamp);
                sc.accept(BasicSummarizer.MAX_TIMESTAMP_STAT, this.maxStamp);
                sc.accept(BasicSummarizer.DELETES_STAT, this.deletes);
                sc.accept(BasicSummarizer.TOTAL_STAT, this.total);
            }
        };
    }

    public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
        return (stats1, stats2) -> {
            stats1.merge(DELETES_STAT, (Long)stats2.get(DELETES_STAT), Long::sum);
            stats1.merge(TOTAL_STAT, (Long)stats2.get(TOTAL_STAT), Long::sum);
            stats1.merge(MIN_TIMESTAMP_STAT, (Long)stats2.get(MIN_TIMESTAMP_STAT), Long::min);
            stats1.merge(MAX_TIMESTAMP_STAT, (Long)stats2.get(MAX_TIMESTAMP_STAT), Long::max);
        };
    }
}

