/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.YieldingIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YieldScannersIT
extends AccumuloClusterHarness {
    Logger log = LoggerFactory.getLogger(YieldScannersIT.class);
    private static final char START_ROW = 'a';

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
    }

    @Test
    public void testScan() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(YieldScannersIT.getClientProps()).build();){
            client.tableOperations().create(tableName);
            BatchWriter writer = client.createBatchWriter(tableName, new BatchWriterConfig());
            for (int i = 0; i < 10; ++i) {
                byte[] row = new byte[]{(byte)(97 + i)};
                Mutation m = new Mutation(new Text(row));
                m.put(new Text(), new Text(), new Value());
                writer.addMutation(m);
            }
            writer.flush();
            writer.close();
            this.log.info("Creating scanner");
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                IteratorSetting cfg = new IteratorSetting(100, YieldingIterator.class);
                scanner.addScanIterator(cfg);
                this.log.info("iterating");
                Iterator it = scanner.iterator();
                int keyCount = 0;
                int yieldNextCount = 0;
                int yieldSeekCount = 0;
                while (it.hasNext()) {
                    Map.Entry next = (Map.Entry)it.next();
                    this.log.info(Integer.toString(keyCount) + ": Got key " + next.getKey() + " with value " + next.getValue());
                    char expected = (char)(97 + keyCount);
                    Assert.assertEquals((String)"Unexpected row", (Object)Character.toString(expected), (Object)((Key)next.getKey()).getRow().toString());
                    if ((keyCount & 1) != 0) {
                        ++yieldNextCount;
                        ++yieldSeekCount;
                    }
                    String[] value = StringUtils.split((String)((Value)next.getValue()).toString(), (char)',');
                    Assert.assertEquals((String)"Unexpected yield next count", (Object)Integer.toString(yieldNextCount), (Object)value[0]);
                    Assert.assertEquals((String)"Unexpected yield seek count", (Object)Integer.toString(yieldSeekCount), (Object)value[1]);
                    Assert.assertEquals((String)"Unexpected rebuild count", (Object)Integer.toString(yieldNextCount + yieldSeekCount), (Object)value[2]);
                    ++keyCount;
                }
                Assert.assertEquals((String)"Did not get the expected number of results", (long)10L, (long)keyCount);
            }
        }
    }

    @Test
    public void testBatchScan() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(YieldScannersIT.getClientProps()).build();){
            client.tableOperations().create(tableName);
            BatchWriter writer = client.createBatchWriter(tableName, new BatchWriterConfig());
            for (int i = 0; i < 10; ++i) {
                byte[] row = new byte[]{(byte)(97 + i)};
                Mutation m = new Mutation(new Text(row));
                m.put(new Text(), new Text(), new Value());
                writer.addMutation(m);
            }
            writer.flush();
            writer.close();
            this.log.info("Creating batch scanner");
            try (BatchScanner scanner = client.createBatchScanner(tableName);){
                IteratorSetting cfg = new IteratorSetting(100, YieldingIterator.class);
                scanner.addScanIterator(cfg);
                scanner.setRanges(Collections.singleton(new Range()));
                this.log.info("iterating");
                Iterator it = scanner.iterator();
                int keyCount = 0;
                int yieldNextCount = 0;
                int yieldSeekCount = 0;
                while (it.hasNext()) {
                    Map.Entry next = (Map.Entry)it.next();
                    this.log.info(Integer.toString(keyCount) + ": Got key " + next.getKey() + " with value " + next.getValue());
                    char expected = (char)(97 + keyCount);
                    Assert.assertEquals((String)"Unexpected row", (Object)Character.toString(expected), (Object)((Key)next.getKey()).getRow().toString());
                    if ((keyCount & 1) != 0) {
                        ++yieldNextCount;
                        ++yieldSeekCount;
                    }
                    String[] value = StringUtils.split((String)((Value)next.getValue()).toString(), (char)',');
                    Assert.assertEquals((String)"Unexpected yield next count", (Object)Integer.toString(yieldNextCount), (Object)value[0]);
                    Assert.assertEquals((String)"Unexpected yield seek count", (Object)Integer.toString(yieldSeekCount), (Object)value[1]);
                    Assert.assertEquals((String)"Unexpected rebuild count", (Object)Integer.toString(yieldNextCount + yieldSeekCount), (Object)value[2]);
                    ++keyCount;
                }
                Assert.assertEquals((String)"Did not get the expected number of results", (long)10L, (long)keyCount);
            }
        }
    }
}

