/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.fs.PerTableVolumeChooser;
import org.apache.accumulo.server.fs.PreferredVolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.accumulo.test.VolumeChooserIT;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class VolumeChooserFailureIT
extends ConfigurableMacBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private File volDirBase;
    private Path v1;
    private Path v2;
    private Path v3;
    private Path v4;
    private static String[] rows = "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z".split(",");
    private String namespace1;

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(2);
        this.namespace1 = "ns_" + this.getUniqueNames(1)[0];
        HashMap<String, String> siteConfig = new HashMap<String, String>();
        siteConfig.put(Property.GENERAL_VOLUME_CHOOSER.getKey(), PerTableVolumeChooser.class.getName());
        siteConfig.put(VolumeChooserIT.PERTABLE_CHOOSER_PROP, PreferredVolumeChooser.class.getName());
        File baseDir = cfg.getDir();
        this.volDirBase = new File(baseDir, "volumes");
        File v1f = new File(this.volDirBase, "v1");
        File v2f = new File(this.volDirBase, "v2");
        File v3f = new File(this.volDirBase, "v3");
        File v4f = new File(this.volDirBase, "v4");
        this.v1 = new Path("file://" + v1f.getAbsolutePath());
        this.v2 = new Path("file://" + v2f.getAbsolutePath());
        this.v3 = new Path("file://" + v3f.getAbsolutePath());
        this.v4 = new Path("file://" + v4f.getAbsolutePath());
        cfg.setSiteConfig(siteConfig);
        siteConfig.put(VolumeChooserIT.getPerTableProp(VolumeChooserEnvironment.ChooserScope.LOGGER), PreferredVolumeChooser.class.getName());
        cfg.setSiteConfig(siteConfig);
        cfg.setProperty(Property.INSTANCE_VOLUMES, this.v1 + "," + this.v2 + "," + this.v4);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        super.configure(cfg, hadoopCoreSite);
    }

    public static void addSplits(AccumuloClient accumuloClient, String tableName) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        TreeSet<Text> partitions = new TreeSet<Text>();
        for (String s : rows) {
            partitions.add(new Text(s));
        }
        accumuloClient.tableOperations().addSplits(tableName, partitions);
    }

    @Test
    public void missingVolumePreferredVolumeChooser() throws Exception {
        log.info("Starting missingVolumePreferredVolumeChooser");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            client.namespaceOperations().create(this.namespace1);
            client.namespaceOperations().setProperty(this.namespace1, VolumeChooserIT.PERTABLE_CHOOSER_PROP, PreferredVolumeChooser.class.getName());
            String tableName = this.namespace1 + ".1";
            this.thrown.expect(AccumuloException.class);
            client.tableOperations().create(tableName);
        }
    }

    @Test
    public void notInstancePreferredVolumeChooser() throws Exception {
        log.info("Starting notInstancePreferredVolumeChooser");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            client.namespaceOperations().create(this.namespace1);
            String propertyName = VolumeChooserIT.PERTABLE_CHOOSER_PROP;
            String volume = PreferredVolumeChooser.class.getName();
            client.namespaceOperations().setProperty(this.namespace1, propertyName, volume);
            propertyName = VolumeChooserIT.PREFERRED_CHOOSER_PROP;
            volume = this.v3.toString();
            client.namespaceOperations().setProperty(this.namespace1, propertyName, volume);
            String tableName = this.namespace1 + ".1";
            this.thrown.expect(AccumuloException.class);
            client.tableOperations().create(tableName);
        }
    }
}

