/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ThriftTransportKey;
import org.apache.accumulo.core.clientImpl.ThriftTransportPool;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportCachingIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(TransportCachingIT.class);
    private static int ATTEMPTS = 0;

    @Test
    public void testCachedTransport() throws InterruptedException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(TransportCachingIT.getClientProps()).build();){
            while (client.instanceOperations().getTabletServers().isEmpty()) {
                Thread.sleep(50L);
            }
            ClientContext context = (ClientContext)client;
            long rpcTimeout = ConfigurationTypeHelper.getTimeInMillis((String)Property.GENERAL_RPC_TIMEOUT.getDefaultValue());
            ZooCache zc = context.getZooCache();
            String zkRoot = context.getZooKeeperRoot();
            List children = zc.getChildren(zkRoot + "/tservers");
            while (children.isEmpty()) {
                Thread.sleep(100L);
                children = zc.getChildren(zkRoot + "/tservers");
            }
            ArrayList<ThriftTransportKey> servers = new ArrayList<ThriftTransportKey>();
            while (servers.isEmpty()) {
                for (String tserver : children) {
                    String strData;
                    String path = zkRoot + "/tservers" + "/" + tserver;
                    byte[] data = ZooUtil.getLockData((ZooCache)zc, (String)path);
                    if (data == null || (strData = new String(data, StandardCharsets.UTF_8)).equals("master")) continue;
                    servers.add(new ThriftTransportKey(new ServerServices(strData).getAddress(ServerServices.Service.TSERV_CLIENT), rpcTimeout, context));
                }
                ++ATTEMPTS;
                if (!servers.isEmpty()) break;
                if (ATTEMPTS < 100) {
                    log.warn("Making another attempt to add ThriftTransportKey servers");
                    Thread.sleep(100L);
                    continue;
                }
                log.error("Failed to add ThriftTransportKey servers - Failing TransportCachingIT test");
                Assert.fail((String)"Failed to add ThriftTransportKey servers - Failing TransportCachingIT test");
            }
            ThriftTransportPool pool = ThriftTransportPool.getInstance();
            TTransport first = null;
            while (first == null) {
                try {
                    first = (TTransport)pool.getAnyTransport(servers, true).getSecond();
                }
                catch (TTransportException e) {
                    log.warn("Failed to obtain transport to {}", servers);
                }
            }
            Assert.assertNotNull(first);
            pool.returnTransport(first);
            TTransport second = null;
            while (second == null) {
                try {
                    second = (TTransport)pool.getAnyTransport(servers, true).getSecond();
                }
                catch (TTransportException e) {
                    log.warn("Failed obtain 2nd transport to {}", servers);
                }
            }
            Assert.assertSame((String)"Expected the first and second to be the same instance", (Object)first, second);
            pool.returnTransport(second);
            TTransport third = null;
            while (third == null) {
                try {
                    third = (TTransport)pool.getAnyTransport(servers, false).getSecond();
                }
                catch (TTransportException e) {
                    log.warn("Failed obtain 2nd transport to {}", servers);
                }
            }
            Assert.assertNotSame((String)"Expected second and third transport to be different instances", (Object)second, third);
            pool.returnTransport(third);
        }
    }
}

