/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tracer.TraceDump;
import org.apache.accumulo.tracer.TraceServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.junit.Assert;
import org.junit.Test;

public class TracerRecoversAfterOfflineTableIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
        cfg.setNumTservers(1);
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void test() throws Exception {
        Process tracer = null;
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            long rootTraceId;
            if (!client.tableOperations().exists("trace")) {
                MiniAccumuloClusterImpl mac = this.cluster;
                tracer = mac.exec(TraceServer.class, new String[0]).getProcess();
                while (!client.tableOperations().exists("trace")) {
                    UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                }
                UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            log.info("Taking table offline");
            client.tableOperations().offline("trace", true);
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            log.info("Start a distributed trace span");
            TraceUtil.enableClientTraces((String)"localhost", (String)"testTrace", (Properties)this.getClientProperties());
            try (TraceScope root = Trace.startSpan((String)"traceTest", (Sampler)Sampler.ALWAYS);){
                rootTraceId = root.getSpan().getTraceId();
                try (BatchWriter bw = client.createBatchWriter(tableName);){
                    Mutation m = new Mutation((CharSequence)"m");
                    m.put((CharSequence)"a", (CharSequence)"b", (CharSequence)"c");
                    bw.addMutation(m);
                }
            }
            log.info("Bringing trace table back online");
            client.tableOperations().online("trace", true);
            log.info("Trace table is online, should be able to find trace");
            try (Scanner scanner = client.createScanner("trace", Authorizations.EMPTY);){
                scanner.setRange(new Range(new Text(Long.toHexString(rootTraceId))));
                while (true) {
                    StringBuilder finalBuffer = new StringBuilder();
                    int traceCount = TraceDump.printTrace((Scanner)scanner, line -> {
                        try {
                            finalBuffer.append(line).append("\n");
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    });
                    String traceOutput = finalBuffer.toString();
                    log.info("Trace output:{}", (Object)traceOutput);
                    if (traceCount > 0) {
                        int lastPos = 0;
                        for (String part : "traceTest,close,binMutations".split(",")) {
                            log.info("Looking in trace output for '{}'", (Object)part);
                            int pos = traceOutput.indexOf(part);
                            Assert.assertTrue((String)("Did not find '" + part + "' in output"), (pos > 0 ? 1 : 0) != 0);
                            Assert.assertTrue((String)("'" + part + "' occurred earlier than the previous element unexpectedly"), (pos > lastPos ? 1 : 0) != 0);
                            lastPos = pos;
                        }
                        break;
                    }
                    log.info("Ignoring trace output as traceCount not greater than zero: {}", (Object)traceCount);
                    Thread.sleep(1000L);
                }
                if (tracer != null) {
                    tracer.destroy();
                }
            }
        }
    }
}

