/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class SplitRecoveryIT
extends AccumuloClusterHarness {
    private Mutation m(String row) {
        Mutation result = new Mutation((CharSequence)row);
        result.put((CharSequence)"cf", (CharSequence)"cq", new Value("value".getBytes()));
        return result;
    }

    boolean isOffline(String tablename, AccumuloClient client) throws TableNotFoundException {
        String tableId = (String)client.tableOperations().tableIdMap().get(tablename);
        try (Scanner scanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            scanner.setRange(new Range(new Text(tableId + ";"), new Text(tableId + "<")));
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            boolean bl = Iterators.size((Iterator)scanner.iterator()) == 0;
            return bl;
        }
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(SplitRecoveryIT.getClientProps()).build();){
            for (int tn = 0; tn < 2; ++tn) {
                block35: {
                    client.tableOperations().create(tableName);
                    try (BatchWriter bw = client.createBatchWriter(tableName);){
                        bw.addMutation(this.m("a"));
                        bw.addMutation(this.m("b"));
                        bw.addMutation(this.m("c"));
                    }
                    client.tableOperations().offline(tableName);
                    while (!this.isOffline(tableName, client)) {
                        UtilWaitThread.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    client.securityOperations().grantTablePermission(SplitRecoveryIT.getAdminPrincipal(), MetadataTable.NAME, TablePermission.WRITE);
                    TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableName)));
                    KeyExtent extent = new KeyExtent(tableId, null, new Text("b"));
                    Mutation m = extent.getPrevRowUpdateMutation();
                    MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.put(m, new Value(Double.toString(0.5).getBytes()));
                    MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow(null));
                    try (BatchWriter bw = client.createBatchWriter(MetadataTable.NAME);){
                        bw.addMutation(m);
                        if (tn != 1) break block35;
                        bw.flush();
                        try (Scanner scanner = client.createScanner(MetadataTable.NAME);){
                            scanner.setRange(extent.toMetadataRange());
                            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                            KeyExtent extent2 = new KeyExtent(tableId, new Text("b"), null);
                            m = extent2.getPrevRowUpdateMutation();
                            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value("/t2".getBytes()));
                            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value("M0".getBytes()));
                            for (Map.Entry entry : scanner) {
                                m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, ((Key)entry.getKey()).getColumnQualifier(), (Value)entry.getValue());
                            }
                            bw.addMutation(m);
                        }
                    }
                }
                client.tableOperations().online(tableName);
                try (Scanner scanner = client.createScanner(tableName);){
                    int i = 0;
                    String[] expected = new String[]{"a", "b", "c"};
                    for (Map.Entry entry : scanner) {
                        Assert.assertEquals((Object)expected[i], (Object)((Key)entry.getKey()).getRow().toString());
                        ++i;
                    }
                    Assert.assertEquals((long)3L, (long)i);
                    client.tableOperations().delete(tableName);
                    continue;
                }
            }
        }
    }
}

