/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Map;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;

public class SizeCompactionStrategy
extends CompactionStrategy {
    private long size = 0L;

    public void init(Map<String, String> options) {
        this.size = Long.parseLong(options.get("size"));
    }

    public boolean shouldCompact(MajorCompactionRequest request) {
        for (DataFileValue dfv : request.getFiles().values()) {
            if (dfv.getSize() >= this.size) continue;
            return true;
        }
        return false;
    }

    public CompactionPlan getCompactionPlan(MajorCompactionRequest request) {
        CompactionPlan plan = new CompactionPlan();
        for (Map.Entry entry : request.getFiles().entrySet()) {
            if (((DataFileValue)entry.getValue()).getSize() >= this.size) continue;
            plan.inputFiles.add((FileRef)entry.getKey());
        }
        return plan;
    }
}

