/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class CompactionRateLimitingIT
extends ConfigurableMacBase {
    public static final long BYTES_TO_WRITE = 0xA00000L;
    public static final long RATE = 0x100000L;

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration fsConf) {
        cfg.setProperty(Property.TSERV_MAJC_THROUGHPUT, "1048576B");
        cfg.setProperty(Property.TABLE_MAJC_RATIO, "20");
        cfg.setProperty(Property.TABLE_FILE_COMPRESSION_TYPE, "none");
    }

    @Test
    public void majorCompactionsAreRateLimited() throws Exception {
        long bytesWritten;
        String tableName = this.getUniqueNames(1)[0];
        AccumuloClient client = this.getCluster().createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        client.tableOperations().create(tableName);
        try (BatchWriter bw = client.createBatchWriter(tableName);){
            byte[] value;
            byte[] qual;
            byte[] rowKey;
            SecureRandom r = new SecureRandom();
            for (bytesWritten = 0L; bytesWritten < 0xA00000L; bytesWritten += (long)(rowKey.length + qual.length + value.length)) {
                rowKey = new byte[32];
                ((Random)r).nextBytes(rowKey);
                qual = new byte[32];
                ((Random)r).nextBytes(qual);
                value = new byte[1024];
                ((Random)r).nextBytes(value);
                Mutation m = new Mutation(rowKey);
                m.put(new byte[0], qual, value);
                bw.addMutation(m);
            }
        }
        client.tableOperations().flush(tableName, null, null, true);
        long compactionStart = System.currentTimeMillis();
        client.tableOperations().compact(tableName, null, null, false, true);
        long duration = System.currentTimeMillis() - compactionStart;
        Assert.assertTrue((String)String.format("Expected a compaction rate of no more than %,d bytes/sec, but saw a rate of %,f bytes/sec", 0L, 1000.0 * (double)bytesWritten / (double)duration), ((double)duration > 8000.0 ? 1 : 0) != 0);
    }
}

