/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuditMessageIT
extends ConfigurableMacBase {
    private static final String AUDIT_USER_1 = "AuditUser1";
    private static final String AUDIT_USER_2 = "AuditUser2";
    private static final String PASSWORD = "password";
    private static final String OLD_TEST_TABLE_NAME = "apples";
    private static final String NEW_TEST_TABLE_NAME = "oranges";
    private static final String THIRD_TEST_TABLE_NAME = "pears";
    private static final Authorizations auths = new Authorizations(new String[]{"private", "public"});
    private static String lastAuditTimestamp;
    private AccumuloClient auditAccumuloClient;
    private AccumuloClient client;

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Override
    public void beforeClusterStart(MiniAccumuloConfigImpl cfg) {
        cfg.setNumTservers(1);
    }

    private static long findAuditMessage(ArrayList<String> input, String pattern) {
        return input.stream().filter(s -> s.matches(".*" + pattern + ".*")).count();
    }

    private ArrayList<String> getAuditMessages(String stepName) throws IOException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted waiting for data to be flushed to output streams");
        }
        System.out.println("Start of captured audit messages for step " + stepName);
        ArrayList<String> result = new ArrayList<String>();
        File[] files = this.getCluster().getConfig().getLogDir().listFiles();
        Assert.assertNotNull((Object)files);
        for (File file : files) {
            if (!file.getName().contains(".out") || !file.isFile() || !file.canRead()) continue;
            try (java.util.Scanner it = new java.util.Scanner(file, StandardCharsets.UTF_8.name());){
                while (it.hasNext()) {
                    String pattern;
                    String line = it.nextLine();
                    if (!line.matches(pattern = ".* \\[" + "org.apache.accumulo.audit".replace("org.apache.", "").replace(".", "[.]") + "\\] .*") || lastAuditTimestamp != null && line.substring(0, 23).compareTo(lastAuditTimestamp) <= 0) continue;
                    result.add(line);
                }
            }
        }
        Collections.sort(result);
        for (String s : result) {
            System.out.println(s);
        }
        System.out.println("End of captured audit messages for step " + stepName);
        if (!result.isEmpty()) {
            lastAuditTimestamp = result.get(result.size() - 1).substring(0, 23);
        }
        return result;
    }

    private void grantEverySystemPriv(AccumuloClient client, String user) throws AccumuloSecurityException, AccumuloException {
        SystemPermission[] arrayOfP;
        for (SystemPermission p : arrayOfP = new SystemPermission[]{SystemPermission.SYSTEM, SystemPermission.ALTER_TABLE, SystemPermission.ALTER_USER, SystemPermission.CREATE_TABLE, SystemPermission.CREATE_USER, SystemPermission.DROP_TABLE, SystemPermission.DROP_USER}) {
            client.securityOperations().grantSystemPermission(user, p);
        }
    }

    @Before
    public void resetInstance() throws Exception {
        this.client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        this.removeUsersAndTables();
        this.getAuditMessages("setup");
    }

    @After
    public void cleanUp() throws Exception {
        this.removeUsersAndTables();
        this.client.close();
    }

    private void removeUsersAndTables() throws Exception {
        for (String user : Arrays.asList(AUDIT_USER_1, AUDIT_USER_2)) {
            if (!this.client.securityOperations().listLocalUsers().contains(user)) continue;
            this.client.securityOperations().dropLocalUser(user);
        }
        TableOperations tops = this.client.tableOperations();
        for (String table : Arrays.asList(THIRD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME, OLD_TEST_TABLE_NAME)) {
            if (!tops.exists(table)) continue;
            tops.delete(table);
        }
    }

    @Test
    public void testTableOperationsAudits() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, IOException {
        this.client.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.CREATE_TABLE);
        this.auditAccumuloClient = this.getCluster().createAccumuloClient(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditAccumuloClient.tableOperations().create(OLD_TEST_TABLE_NAME);
        this.auditAccumuloClient.tableOperations().rename(OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME);
        Map emptyMap = Collections.emptyMap();
        Set emptySet = Collections.emptySet();
        this.auditAccumuloClient.tableOperations().clone(NEW_TEST_TABLE_NAME, OLD_TEST_TABLE_NAME, true, emptyMap, emptySet);
        this.auditAccumuloClient.tableOperations().delete(OLD_TEST_TABLE_NAME);
        this.auditAccumuloClient.tableOperations().offline(NEW_TEST_TABLE_NAME);
        this.auditAccumuloClient.tableOperations().delete(NEW_TEST_TABLE_NAME);
        ArrayList<String> auditMessages = this.getAuditMessages("testTableOperationsAudits");
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: createTable; targetTable: apples"));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: renameTable; targetTable: apples"));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: cloneTable; targetTable: oranges"));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: deleteTable; targetTable: apples"));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: offlineTable; targetTable: oranges"));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: deleteTable; targetTable: oranges"));
    }

    @Test
    public void testUserOperationsAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, IOException {
        this.client.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.CREATE_USER);
        this.grantEverySystemPriv(this.client, AUDIT_USER_1);
        this.auditAccumuloClient = this.getCluster().createAccumuloClient(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditAccumuloClient.securityOperations().createLocalUser(AUDIT_USER_2, new PasswordToken((CharSequence)PASSWORD));
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_2, SystemPermission.ALTER_TABLE);
        this.client.securityOperations().revokeSystemPermission(AUDIT_USER_2, SystemPermission.ALTER_TABLE);
        this.auditAccumuloClient.tableOperations().create(NEW_TEST_TABLE_NAME);
        this.client.securityOperations().grantTablePermission(AUDIT_USER_2, NEW_TEST_TABLE_NAME, TablePermission.READ);
        this.client.securityOperations().revokeTablePermission(AUDIT_USER_2, NEW_TEST_TABLE_NAME, TablePermission.READ);
        this.auditAccumuloClient.securityOperations().changeLocalUserPassword(AUDIT_USER_2, new PasswordToken((CharSequence)"anything"));
        this.auditAccumuloClient.securityOperations().changeUserAuthorizations(AUDIT_USER_2, auths);
        this.auditAccumuloClient.securityOperations().dropLocalUser(AUDIT_USER_2);
        ArrayList<String> auditMessages = this.getAuditMessages("testUserOperationsAudits");
        Assert.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: createUser; targetUser: AuditUser2"));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: grantSystemPermission; permission: " + SystemPermission.ALTER_TABLE + "; targetUser: " + AUDIT_USER_2));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: revokeSystemPermission; permission: " + SystemPermission.ALTER_TABLE + "; targetUser: " + AUDIT_USER_2));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: grantTablePermission; permission: " + TablePermission.READ + "; targetTable: " + NEW_TEST_TABLE_NAME));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: revokeTablePermission; permission: " + TablePermission.READ + "; targetTable: " + NEW_TEST_TABLE_NAME));
        Assert.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: changePassword; targetUser: AuditUser2"));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: changeAuthorizations; targetUser: AuditUser2; authorizations: " + auths));
        Assert.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: dropUser; targetUser: AuditUser2"));
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="paths provided by test")
    public void testImportExportOperationsAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException {
        this.client.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.client.securityOperations().changeUserAuthorizations(AUDIT_USER_1, auths);
        this.grantEverySystemPriv(this.client, AUDIT_USER_1);
        this.auditAccumuloClient = this.getCluster().createAccumuloClient(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditAccumuloClient.tableOperations().create(OLD_TEST_TABLE_NAME);
        try (BatchWriter bw = this.auditAccumuloClient.createBatchWriter(OLD_TEST_TABLE_NAME);){
            Mutation m = new Mutation((CharSequence)"myRow");
            m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
            m.put((CharSequence)"cf1", (CharSequence)"cq2", (CharSequence)"v3");
            bw.addMutation(m);
        }
        File exportDir = new File(this.getCluster().getConfig().getDir() + "/export");
        File exportDirBulk = new File(this.getCluster().getConfig().getDir() + "/export_bulk");
        Assert.assertTrue((exportDirBulk.mkdir() || exportDirBulk.isDirectory() ? 1 : 0) != 0);
        this.auditAccumuloClient.tableOperations().offline(OLD_TEST_TABLE_NAME, true);
        this.auditAccumuloClient.tableOperations().exportTable(OLD_TEST_TABLE_NAME, exportDir.toString());
        File distCpTxt = new File(exportDir + "/distcp.txt");
        File importFile = null;
        String filePrefix = "file:";
        try (java.util.Scanner it = new java.util.Scanner(distCpTxt, StandardCharsets.UTF_8.name());){
            while (it.hasNext() && importFile == null) {
                String line = it.nextLine();
                if (!line.matches(".*\\.rf")) continue;
                importFile = new File(line.replaceFirst(filePrefix, ""));
            }
        }
        FileUtils.copyFileToDirectory(importFile, (File)exportDir);
        FileUtils.copyFileToDirectory(importFile, (File)exportDirBulk);
        this.auditAccumuloClient.tableOperations().importTable(NEW_TEST_TABLE_NAME, exportDir.toString());
        this.auditAccumuloClient.tableOperations().create(THIRD_TEST_TABLE_NAME);
        this.auditAccumuloClient.tableOperations().importDirectory(exportDirBulk.toString()).to(THIRD_TEST_TABLE_NAME).load();
        this.auditAccumuloClient.tableOperations().online(OLD_TEST_TABLE_NAME);
        ArrayList<String> auditMessages = this.getAuditMessages("testImportExportOperationsAudits");
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: createTable; targetTable: %s;", OLD_TEST_TABLE_NAME)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: %s; targetTable: %s;", "offlineTable", OLD_TEST_TABLE_NAME)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: export; targetTable: %s; dataDir: %s;", OLD_TEST_TABLE_NAME, exportDir.toString())));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: import; targetTable: %s; dataDir: %s;", NEW_TEST_TABLE_NAME, filePrefix + exportDir)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: createTable; targetTable: %s;", THIRD_TEST_TABLE_NAME)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: bulkImport; targetTable: %s; dataDir: %s; failDir: %s;", THIRD_TEST_TABLE_NAME, filePrefix + exportDirBulk, null)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: %s; targetTable: %s;", "onlineTable", OLD_TEST_TABLE_NAME)));
    }

    @Test
    public void testDataOperationsAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException {
        this.client.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.client.securityOperations().changeUserAuthorizations(AUDIT_USER_1, auths);
        this.grantEverySystemPriv(this.client, AUDIT_USER_1);
        this.auditAccumuloClient = this.getCluster().createAccumuloClient(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditAccumuloClient.tableOperations().create(OLD_TEST_TABLE_NAME);
        try (BatchWriter bw = this.auditAccumuloClient.createBatchWriter(OLD_TEST_TABLE_NAME);){
            Mutation m = new Mutation((CharSequence)"myRow");
            m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
            m.put((CharSequence)"cf1", (CharSequence)"cq2", (CharSequence)"v3");
            bw.addMutation(m);
        }
        try (Scanner scanner = this.auditAccumuloClient.createScanner(OLD_TEST_TABLE_NAME, auths);){
            for (Map.Entry entry : scanner) {
                System.out.println("Scanner row: " + entry.getKey() + " " + entry.getValue());
            }
        }
        try (BatchScanner bs = this.auditAccumuloClient.createBatchScanner(OLD_TEST_TABLE_NAME, auths, 1);){
            bs.fetchColumn(new Text("cf1"), new Text("cq1"));
            bs.setRanges(Arrays.asList(new Range((CharSequence)"myRow", (CharSequence)"myRow~")));
            for (Map.Entry entry : bs) {
                System.out.println("BatchScanner row: " + entry.getKey() + " " + entry.getValue());
            }
        }
        this.auditAccumuloClient.tableOperations().deleteRows(OLD_TEST_TABLE_NAME, new Text("myRow"), new Text("myRow~"));
        ArrayList<String> auditMessages = this.getAuditMessages("testDataOperationsAudits");
        Assert.assertTrue((AuditMessageIT.findAuditMessage(auditMessages, "action: scan; targetTable: apples") >= 1L ? 1 : 0) != 0);
        Assert.assertTrue((AuditMessageIT.findAuditMessage(auditMessages, "action: scan; targetTable: apples") >= 1L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: deleteData; targetTable: %s; startRange: %s; endRange: %s;", OLD_TEST_TABLE_NAME, "myRow", "myRow~")));
    }

    @Test
    public void testDeniedAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException {
        this.client.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.client.tableOperations().create(OLD_TEST_TABLE_NAME);
        this.auditAccumuloClient = this.getCluster().createAccumuloClient(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        try {
            this.auditAccumuloClient.tableOperations().create(NEW_TEST_TABLE_NAME);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.auditAccumuloClient.tableOperations().rename(OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.auditAccumuloClient.tableOperations().clone(OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME, false, Collections.emptyMap(), Collections.emptySet());
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.auditAccumuloClient.tableOperations().delete(OLD_TEST_TABLE_NAME);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.auditAccumuloClient.tableOperations().offline(OLD_TEST_TABLE_NAME);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try (Scanner scanner2 = this.auditAccumuloClient.createScanner(OLD_TEST_TABLE_NAME, auths);){
            ((Map.Entry)scanner2.iterator().next()).getKey();
        }
        catch (RuntimeException scanner2) {
            // empty catch block
        }
        try {
            this.auditAccumuloClient.tableOperations().deleteRows(OLD_TEST_TABLE_NAME, new Text("myRow"), new Text("myRow~"));
        }
        catch (AccumuloSecurityException scanner2) {
            // empty catch block
        }
        try {
            this.auditAccumuloClient.tableOperations().flush(OLD_TEST_TABLE_NAME, new Text("myRow"), new Text("myRow~"), false);
        }
        catch (AccumuloSecurityException scanner2) {
            // empty catch block
        }
        ArrayList<String> auditMessages = this.getAuditMessages("testDeniedAudits");
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: createTable; targetTable: %s;", NEW_TEST_TABLE_NAME)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: renameTable; targetTable: %s; newTableName: %s;", OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: cloneTable; targetTable: %s; newTableName: %s", OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: deleteTable; targetTable: %s;", OLD_TEST_TABLE_NAME)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: %s; targetTable: %s;", "offlineTable", OLD_TEST_TABLE_NAME)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*action: scan; targetTable: apples"));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: deleteData; targetTable: %s; startRange: %s; endRange: %s;", OLD_TEST_TABLE_NAME, "myRow", "myRow~")));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: flushTable; targetTable: %s; targetNamespace: %s;", "1", "\\+default")));
    }

    @Test
    public void testFailedAudits() throws AccumuloException, IOException {
        try {
            this.client.securityOperations().dropLocalUser(AUDIT_USER_2);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.client.securityOperations().revokeSystemPermission(AUDIT_USER_2, SystemPermission.ALTER_TABLE);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.client.securityOperations().createLocalUser("root", new PasswordToken((CharSequence)"super secret"));
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        ArrayList<String> auditMessages = this.getAuditMessages("testFailedAudits");
        Assert.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: dropUser; targetUser: %s;", AUDIT_USER_2)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: revokeSystemPermission; permission: %s; targetUser: %s;", SystemPermission.ALTER_TABLE, AUDIT_USER_2)));
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: createUser; targetUser: %s; Authorizations: %s;", "root", "")));
    }
}

